/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.init.table;

import java.sql.ResultSet;
import java.util.Set;
import kd.bos.bdsync.init.table.AbstractTableCreater;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class MySQLTableCreater
extends AbstractTableCreater {
    @Override
    public void createTable(Set<String> tables, DBRoute sourceRoute, DBRoute destinationRoute) {
        for (String table : tables) {
            table = table.toUpperCase();
            this.executeSql(destinationRoute, this.getDialectSql(this.getTableStructure(table, sourceRoute)));
        }
    }

    @Override
    public void createIndex(Set<String> tables, DBRoute sourceRoute, DBRoute destinationRoute) {
    }

    @Override
    public void dropTable(Set<String> tables, DBRoute sourceRoute, DBRoute destinationRoute) {
        tables.forEach(tableName -> {
            tableName = tableName.toUpperCase();
            StringBuilder dropSql = new StringBuilder();
            dropSql.append("drop table if exists ").append((String)tableName);
            this.executeSql(destinationRoute, this.getDialectSql(dropSql.toString()));
        });
    }

    private String getTableStructure(final String table, DBRoute sourceRoute) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SHOW CREATE TABLE ").append(table).append(";");
        return (String)DB.query((DBRoute)sourceRoute, (String)this.getDialectSql(sqlBuilder.toString()), null, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String sourceTableStructure = null;
                while (rs.next()) {
                    sourceTableStructure = rs.getString(2);
                }
                if (sourceTableStructure == null) {
                    throw new KDException(BosErrorCode.bOS, new Object[]{"The table of \"" + table + "\" Structure is null!"});
                }
                return sourceTableStructure;
            }
        });
    }
}

