/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.init.table.hybrid.load;

import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bdsync.init.table.hybrid.Column;
import kd.bos.bdsync.init.table.hybrid.ColumnType;
import kd.bos.bdsync.init.table.hybrid.ConstraintType;
import kd.bos.bdsync.init.table.hybrid.Index;
import kd.bos.bdsync.init.table.hybrid.Table;
import kd.bos.bdsync.init.table.hybrid.TableConstraint;
import kd.bos.bdsync.init.table.hybrid.load.Loader;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.xdb.hint.NoShardingHint;

public class PGLoader
implements Loader {
    static final PGLoader instance = new PGLoader();

    public static String wrapSQL(String sql, boolean dialect, boolean noSharding) {
        if (noSharding) {
            sql = NoShardingHint.genNoShardingSQL((String)sql);
        }
        if (dialect) {
            sql = "/*dialect*/" + sql;
        }
        return sql;
    }

    protected int parseIntNullAsZero(String s) {
        return s == null ? 0 : Integer.parseInt(s);
    }

    protected long parseLongNullAsZero(String s) {
        return s == null ? 0L : Long.parseLong(s);
    }

    private ColumnType convertColumnType(String type) {
        switch (type = type.toLowerCase(Locale.ENGLISH)) {
            case "int8": {
                return ColumnType.BIGINT;
            }
            case "int2": {
                return ColumnType.SMALLINT;
            }
            case "int4": {
                return ColumnType.INT;
            }
            case "numeric": {
                return ColumnType.DECIMAL;
            }
            case "timestamp": {
                return ColumnType.DATETIME;
            }
            case "bytea": {
                return ColumnType.BLOB;
            }
            case "text": {
                return ColumnType.NCLOB;
            }
            case "bpchar": {
                return ColumnType.CHAR;
            }
            case "varchar": {
                return ColumnType.VARCHAR;
            }
        }
        throw new UnsupportedOperationException("Unsupported convert column type: " + type);
    }

    private String convertColumnDefault(String defaultValueExpression) {
        if (defaultValueExpression == null) {
            return null;
        }
        int index = defaultValueExpression.indexOf("::");
        if (index >= 0) {
            return defaultValueExpression.substring(0, index);
        }
        return defaultValueExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Table loadTable(String routeKey, String tableName) {
        DBRoute route = DBRoute.of((String)routeKey);
        Table table = new Table(DB.getDBType((DBRoute)DBRoute.of((String)routeKey)), tableName);
        String likeTable = DB.getOriginalsnapTableNameIfShardingTable((String)tableName);
        String sqlQueryColumn = " select s.column_name,t.typname as data_type ,s.character_maximum_length,s.numeric_precision,s.numeric_scale,s.is_nullable,s.column_default,s.ordinal_position  ,col_description((table_schema||'.'||table_name)::regclass::oid, ordinal_position) as column_comment  from information_schema.columns s,pg_attribute a, pg_class c, pg_type t  where  table_schema = current_schema () and s.table_name = c.relname and s.ordinal_position = a.attnum  and a.attrelid = c.oid and a.atttypid = t.oid and s.table_name=? order by s.ordinal_position ";
        DB.query((DBRoute)route, (String)PGLoader.wrapSQL(sqlQueryColumn, true, true), (Object[])new Object[]{likeTable}, rs -> {
            ArrayList<Column> columns = new ArrayList<Column>(50);
            while (rs.next()) {
                String column_name = rs.getString("column_name");
                String dataType = rs.getString("data_type");
                int data_length = this.parseIntNullAsZero(rs.getString("character_maximum_length"));
                int data_precision = this.parseIntNullAsZero(rs.getString("numeric_precision"));
                int data_scale = this.parseIntNullAsZero(rs.getString("numeric_scale"));
                boolean nullable = "YES".equals(rs.getString("is_nullable"));
                String column_default = rs.getString("column_default");
                String column_comment = rs.getString("column_comment");
                ColumnType columnType = this.convertColumnType(dataType);
                column_default = this.convertColumnDefault(column_default);
                Column column = new Column(column_name, columnType, data_length, data_precision, data_scale, nullable, column_default, column_comment);
                columns.add(column);
            }
            table.setColumns(columns);
            return null;
        });
        String sqlQueryIndex = "select t.relname as table_name,i.relname as index_name,idx.indisunique,idx.indisprimary,idx.indisclustered,a.attname as column_name \nfrom (select indexrelid,indrelid,indisunique,indisprimary,indisclustered,unnest(indkey) as indkey from pg_index where indrelid = (select t.oid from pg_class t left join pg_namespace as s on t.relnamespace = s.oid where relname = ?)) as idx\nleft join pg_class as i on i.oid = idx.indexrelid\nleft join pg_class as t on t.oid = idx.indrelid\nleft join pg_attribute a on a.attrelid = t.oid and a.attnum = idx.indkey;";
        final RowMeta indexResultMeta = new RowMeta(new String[]{"table_name", "index_name", "indisunique", "indisprimary", "indisclustered", "columns"}, new DataType[]{DataType.StringType, DataType.StringType, DataType.BooleanType, DataType.BooleanType, DataType.BooleanType, DataType.StringType});
        try (DataSet dataSet = DB.queryDataSet((String)"QueryPGIndexInfo", (DBRoute)route, (String)PGLoader.wrapSQL(sqlQueryIndex, true, true), (Object[])new String[]{likeTable});){
            dataSet = dataSet.groupBy(new String[]{"index_name"}).reduceGroup(new ReduceGroupFunctionWithCollector(){

                public void reduce(Iterator<Row> iterator, Collector collector) {
                    ArrayList<String> columnNameList = new ArrayList<String>(10);
                    Row first = null;
                    while (iterator.hasNext()) {
                        Row current = iterator.next();
                        if (first == null) {
                            first = current;
                        }
                        columnNameList.add(current.getString("column_name"));
                    }
                    if (first == null) {
                        collector.collect(null);
                        return;
                    }
                    Object[] newRow = new Object[]{first.getString("table_name"), first.getString("index_name"), first.getBoolean("indisunique"), first.getBoolean("indisprimary"), first.getBoolean("indisclustered"), String.join((CharSequence)",", columnNameList)};
                    collector.collect(newRow);
                }

                public RowMeta getResultRowMeta() {
                    return indexResultMeta;
                }
            });
            String sqlQueryConstraint = "select constraint_name from information_schema.table_constraints tc where table_name = ? and table_schema = current_schema()";
            List constraintNameList = (List)DB.query((DBRoute)route, (String)PGLoader.wrapSQL(sqlQueryConstraint, true, true), (Object[])new Object[]{likeTable}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet resultSet) throws Exception {
                    ArrayList<String> names = new ArrayList<String>(10);
                    while (resultSet.next()) {
                        names.add(resultSet.getString("constraint_name"));
                    }
                    return names;
                }
            });
            ArrayList<TableConstraint> constraints = new ArrayList<TableConstraint>(10);
            ArrayList<Index> indices = new ArrayList<Index>(10);
            for (Row row : dataSet) {
                TableConstraint tableConstraint;
                ArrayList columnNameList = Lists.newArrayList((Object[])row.getString("columns").split(","));
                String indexName = row.getString("index_name");
                if (row.getBoolean("indisprimary").booleanValue()) {
                    tableConstraint = new TableConstraint(indexName, ConstraintType.PRIMARY_KEY, columnNameList);
                    constraints.add(tableConstraint);
                    continue;
                }
                if (constraintNameList.contains(indexName)) {
                    tableConstraint = new TableConstraint(indexName, ConstraintType.UNIQUE, columnNameList);
                    constraints.add(tableConstraint);
                    continue;
                }
                Index index = new Index(indexName, tableName, row.getBoolean("indisunique"), "btree", row.getBoolean("indisclustered"), true, columnNameList);
                indices.add(index);
            }
            table.setConstraints(constraints);
            table.setIndices(indices);
        }
        String sqlQueryTableComment = "select cast(obj_description(t.relfilenode,'pg_class') as varchar) as table_comment from pg_class t left join pg_namespace as s on t.relnamespace = s.oid where relname = ?";
        String tableComment = (String)DB.query((DBRoute)route, (String)PGLoader.wrapSQL(sqlQueryTableComment, true, true), (Object[])new Object[]{likeTable}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getString("table_comment");
                }
                return null;
            }
        });
        table.setComment(tableComment);
        return table;
    }
}

