/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.output;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.bdsync.BDSyncRowInfo;
import kd.bos.bdsync.sql.SqlInfo;
import kd.bos.bdsync.sql.SqlInfoContext;
import kd.bos.bdsync.sql.SqlInfoType;
import kd.bos.bundle.Resources;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.AbstractOutput;
import kd.bos.dts.RowInfo;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.exception.ApplyException;
import kd.bos.dts.log.DtsStatusReporterFactory;
import kd.bos.dts.oplog.Oplog;
import kd.bos.dts.retry.Retry;
import kd.bos.orm.datasync.ColumnInfo;
import kd.bos.orm.datasync.DataSyncValue;
import kd.bos.orm.datasync.DeleteDataSyncValue;
import kd.bos.orm.datasync.DestinationTransRule;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.orm.datasync.InsertDataSyncValue;
import kd.bos.orm.datasync.OperationType;
import kd.bos.orm.datasync.UpdateDataSyncValue;

public class BDSyncOutput
extends AbstractOutput {
    public BDSyncOutput(DestinationTransRule ruleType) {
        super(ruleType);
    }

    public void trans(String type, DataSyncValue value) {
        long accpettime = System.currentTimeMillis() - value.getTimestap();
        ArrayList<RowInfo> esconsumers = new ArrayList<RowInfo>(100);
        Consumer<ApplyException> logOp = e -> {
            List ids = e.getErrorIds();
            String entityNumber = value.getEntityNumber();
            String msg = e.getMsg() + ",failureIds:" + ids;
            Oplog.get().error(this.destinationRule.getType().getName() + "-" + this.destinationRule.getRegion(), "type", entityNumber, ids.size(), msg);
            DestinationRuleConfig entityRuleConfig = DestinationRuleConfig.get((String)entityNumber, (DestinationTransRule)this.destinationRule);
            DtsStatusReporterFactory.get().confInitCountReportError((Exception)e, entityRuleConfig, ids.size(), "type");
            Retry.get().retry(this.destinationRule, entityNumber, ids);
        };
        try {
            int i;
            if (OperationType.INSERT.getName().equals(type)) {
                InsertDataSyncValue insertValue = (InsertDataSyncValue)value;
                List datas = insertValue.getRows();
                for (i = 0; i < datas.size(); ++i) {
                    BDSyncRowInfo r = new BDSyncRowInfo();
                    r.setType(type);
                    r.setTable(insertValue.getTableName().toLowerCase());
                    r.setEntityNumber(value.getEntityNumber());
                    Object[] columnValues = (Object[])datas.get(i);
                    for (ColumnInfo columnInfo : insertValue.getColumnsLs()) {
                        Object columnValue = columnValues[columnInfo.getColumnIndex()];
                        r.getData().put(columnInfo.getFiledName().toLowerCase(), columnValue);
                    }
                    esconsumers.add(r);
                }
                this.insertTrans(esconsumers);
            } else if (OperationType.UPDATE.getName().equals(type)) {
                UpdateDataSyncValue updateValue = (UpdateDataSyncValue)value;
                List datas = updateValue.getRows();
                for (i = 0; i < datas.size(); ++i) {
                    BDSyncRowInfo r = new BDSyncRowInfo();
                    r.setType(type);
                    r.setTable(updateValue.getTableName().toLowerCase());
                    r.setEntityNumber(value.getEntityNumber());
                    Object[] columnValues = (Object[])datas.get(i);
                    for (ColumnInfo columnInfo : updateValue.getColumnsLs()) {
                        Object columnValue = columnValues[columnInfo.getColumnIndex()];
                        r.getData().put(columnInfo.getFiledName().toLowerCase(), columnValue);
                    }
                    r.setPkName(updateValue.getTablePkFieldStr());
                    r.setPkValue(updateValue.getTableOids().get(i));
                    esconsumers.add(r);
                }
                this.updateTrans(esconsumers);
            } else if (OperationType.DELETE.getName().equals(type)) {
                DeleteDataSyncValue deleteValue = (DeleteDataSyncValue)value;
                for (Object obj : deleteValue.getOids()) {
                    BDSyncRowInfo r = new BDSyncRowInfo();
                    r.setType(type);
                    r.setKey(obj);
                    r.setTable(deleteValue.getTableName().toLowerCase());
                    r.setEntityNumber(value.getEntityNumber());
                    esconsumers.add(r);
                }
                this.deleteTrans(esconsumers);
            }
            long delay = System.currentTimeMillis() - value.getTimestap();
            StringBuilder desc = new StringBuilder();
            desc.append("accpet:").append(accpettime);
            desc.append(Resources.get((String)"bos-dts", (String)"AbstractOutput_0", (String)("ms,\u5ef6\u65f6:" + delay + "ms"), (Object[])new Object[0]));
            if (esconsumers.size() > 0) {
                desc.append(",table:").append(((RowInfo)esconsumers.get(0)).getTable());
            }
            Oplog.get().record(this.destinationRule.getType().getName() + "-" + this.destinationRule.getRegion(), type, value.getEntityNumber(), esconsumers.size(), desc.toString());
        }
        catch (ApplyException e2) {
            logOp.accept(e2);
        }
    }

    public void deleteTrans(List<RowInfo> esconsumers) {
        this.excute(esconsumers, SqlInfoType.DELETE);
    }

    public void insertTrans(List<RowInfo> esconsumers) {
        this.excute(esconsumers, SqlInfoType.INSERT);
    }

    public void updateTrans(List<RowInfo> esconsumers) {
        this.excute(esconsumers, SqlInfoType.UPDATE);
    }

    private void excute(List<RowInfo> esconsumers, SqlInfoType sqlInfoType) {
        if (!esconsumers.isEmpty()) {
            DBRoute route = DBRoute.of((String)this.region);
            SqlInfoContext sqlInfoContext = new SqlInfoContext(esconsumers, sqlInfoType, route);
            for (SqlInfo sqlInfo : sqlInfoContext.getSqlInfoList()) {
                DtsExcludeSyncContext context = DtsExcludeSyncContext.create();
                Throwable throwable = null;
                try {
                    TXHandle h = TX.requiresNew((String)"BDSyncOutput");
                    Throwable throwable2 = null;
                    try {
                        if (sqlInfo.getSqlBuilder() != null) {
                            DB.execute((DBRoute)route, (SqlBuilder)sqlInfo.getSqlBuilder());
                            continue;
                        }
                        DB.executeBatch((DBRoute)route, (String)sqlInfo.getSql(), sqlInfo.getParams());
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable2 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        h.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    context.close();
                }
            }
        }
    }

    public void ddlTrans(String ddl) {
        DBRoute route = DBRoute.of((String)this.region);
        try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();
             TXHandle h = TX.requiresNew((String)"BDSyncOutput");){
            DB.execute((DBRoute)route, (String)ddl);
        }
    }
}

