/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.sql.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bdsync.sql.SqlInfoCreater;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.db.DBRoute;
import kd.bos.dts.RowInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;

public abstract class AbstractSqlInfoCreater
implements SqlInfoCreater {
    protected List<RowInfo> rowInfos;
    protected RowInfo row0;
    protected String tableName;
    protected String entityNumber;
    protected DBRoute dbRoute;

    public AbstractSqlInfoCreater(List<RowInfo> rowInfos, DBRoute dbRoute) {
        if (rowInfos == null || rowInfos.isEmpty()) {
            throw new KDException(BosErrorCode.nullError, new Object[]{"Param rowInfos can not be null."});
        }
        this.rowInfos = rowInfos;
        this.row0 = rowInfos.get(0);
        this.tableName = this.row0.getTable();
        this.entityNumber = this.row0.getEntityNumber();
        this.dbRoute = dbRoute;
        if (this.entityNumber == null) {
            this.entityNumber = DataSyncConfigCache.get().getEntityNumberByTableName(this.tableName);
        }
    }

    protected Map<String, Set<String>> getExtTableFieldsMap() {
        DynamicObjectType entityType = DataCacheReader.get().getDataEntityType(this.entityNumber);
        String entytyTableName = entityType.getAlias().toLowerCase();
        HashMap<String, Set<String>> extTableFieldMap = new HashMap<String, Set<String>>(1);
        boolean isEntytyExt = entytyTableName.equals(this.tableName);
        if (isEntytyExt) {
            try {
                entityType.getProperties().forEach(v -> {
                    String tableGroup;
                    String alias;
                    if (!(v instanceof DynamicCollectionProperty) && (alias = v.getAlias()) != null && alias.length() > 0 && (tableGroup = v.getTableGroup()) != null) {
                        String extTableName = this.tableName + "_" + tableGroup.toLowerCase();
                        Set fieldSet = (Set)extTableFieldMap.get(extTableName);
                        if (fieldSet == null) {
                            extTableFieldMap.put(extTableName, new HashSet(10));
                        }
                        ((Set)extTableFieldMap.get(extTableName)).add(alias);
                    }
                });
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.findPropertyFailed, new Object[]{"MuliLangTextProp not found"});
            }
        }
        return extTableFieldMap;
    }

    protected Map<String, Set<String>> getTableSaveFieldsMap(Map<String, Set<String>> extTableFieldsMap, Set<String> saveFields) {
        HashMap<String, Set<String>> tableFieldsMap = new HashMap<String, Set<String>>(3);
        if (extTableFieldsMap.isEmpty()) {
            tableFieldsMap.put(this.tableName, saveFields);
        } else {
            tableFieldsMap.put(this.tableName, new HashSet(10));
            for (Map.Entry<String, Set<String>> entry : extTableFieldsMap.entrySet()) {
                String extTable = entry.getKey();
                tableFieldsMap.put(extTable, new HashSet(10));
            }
            for (String field : saveFields) {
                boolean isExtTableField = false;
                for (Map.Entry<String, Set<String>> entry : extTableFieldsMap.entrySet()) {
                    String extTable = entry.getKey();
                    if (!entry.getValue().contains(field)) continue;
                    ((Set)tableFieldsMap.get(extTable)).add(field);
                    isExtTableField = true;
                    break;
                }
                if (isExtTableField) continue;
                ((Set)tableFieldsMap.get(this.tableName)).add(field);
            }
        }
        return tableFieldsMap;
    }
}

