/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bdsync.sql.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bdsync.sql.SqlInfo;
import kd.bos.bdsync.sql.impl.AbstractSqlInfoCreater;
import kd.bos.db.DBRoute;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.RowInfo;

public class InsertSqlInfoCreater
extends AbstractSqlInfoCreater {
    public InsertSqlInfoCreater(List<RowInfo> rowInfos, DBRoute dbRoute) {
        super(rowInfos, dbRoute);
    }

    @Override
    public List<SqlInfo> create() {
        ArrayList<SqlInfo> sqlInfos = new ArrayList<SqlInfo>(5);
        Set<String> fields = this.row0.getData().keySet();
        Map<String, Set<String>> extTableFieldsMap = this.getExtTableFieldsMap();
        if (extTableFieldsMap.isEmpty()) {
            SqlInfo info = this.createSqlInfo(this.tableName, new ArrayList<String>(fields));
            if (info != null) {
                sqlInfos.add(info);
            }
        } else {
            String pkField = DtsUtils.getEntityPKFiled((String)this.entityNumber).toLowerCase();
            Map<String, Set<String>> tableFieldsMap = this.getTableSaveFieldsMap(extTableFieldsMap, fields);
            for (Map.Entry<String, Set<String>> entry : tableFieldsMap.entrySet()) {
                Set<String> fieldSet = entry.getValue();
                if (fieldSet.isEmpty()) continue;
                String tempTableName = entry.getKey();
                SqlInfo info = null;
                info = this.tableName.equals(tempTableName) ? this.createSqlInfo(tempTableName, new ArrayList<String>(fieldSet)) : this.createExtSqlInfo(tempTableName, new ArrayList<String>(fieldSet), pkField);
                if (info == null) continue;
                sqlInfos.add(info);
            }
        }
        return sqlInfos;
    }

    private SqlInfo createSqlInfo(String tableName, List<String> fields) {
        String sql = this.getSql(tableName, fields);
        ArrayList<Object[]> values = new ArrayList<Object[]>(10);
        for (RowInfo row : this.rowInfos) {
            ArrayList rowvalue = new ArrayList(10);
            Map rowMap = row.getData();
            for (String v : fields) {
                rowvalue.add(rowMap.get(v));
            }
            values.add(rowvalue.toArray(new Object[0]));
        }
        if (!values.isEmpty()) {
            return new SqlInfo(sql, values);
        }
        return null;
    }

    private SqlInfo createExtSqlInfo(String tableName, List<String> fields, String pkField) {
        if (!fields.contains(pkField)) {
            fields.add(pkField);
        }
        String sql = this.getSql(tableName, fields);
        ArrayList<Object[]> values = new ArrayList<Object[]>(10);
        for (RowInfo row : this.rowInfos) {
            ArrayList rowvalue = new ArrayList(10);
            Map rowMap = row.getData();
            boolean allFieldsIsNull = true;
            for (String v : fields) {
                Object fieldValue = rowMap.get(v);
                if (fieldValue != null && !pkField.equals(v)) {
                    allFieldsIsNull = false;
                }
                rowvalue.add(fieldValue);
            }
            if (allFieldsIsNull) continue;
            values.add(rowvalue.toArray(new Object[0]));
        }
        if (!values.isEmpty()) {
            return new SqlInfo(sql, values);
        }
        return null;
    }

    private String getSql(String tableName, List<String> fields) {
        StringBuilder sb = new StringBuilder("insert into ");
        sb.append(tableName).append('(');
        fields.forEach(v -> sb.append((String)v).append(','));
        sb.setLength(sb.length() - 1);
        sb.append(") values( ");
        fields.forEach(v -> sb.append("?,"));
        sb.setLength(sb.length() - 1);
        sb.append(')');
        return sb.toString();
    }
}

