/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.ORM;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.PkTypeEnum;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.MetaFactory;
import kd.bos.xdb.temptable.pk.PKTempTableHint;

public final class XDBManagerUtil
implements XDBLogable {
    public static void logInfo(String lot) {
        if (log.isInfoEnabled() || ShardTaskConfig.isEnableMovingLog()) {
            log.info(lot);
        }
    }

    public static void logError(String error, Throwable e) {
        log.error(error, e);
    }

    public static void wrapSqlBuilderExecute(DBRoute dbRoute, SqlBuilder sqlBuilder) {
        DBType dbType = DB.getDBType((DBRoute)dbRoute);
        if (dbType == DBType.MySQL) {
            try (PKTempTableHint hint = PKTempTableHint.skip();){
                DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
            }
        } else {
            DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
        }
    }

    public static PkTypeEnum getPkTypeEnum(String entitynumber) {
        ISimpleProperty property = ORM.create().getDataEntityType(entitynumber).getPrimaryKey();
        PkTypeEnum type = null;
        type = property.getPropertyType() == String.class ? PkTypeEnum.pk_string : PkTypeEnum.pk_long;
        return type;
    }

    public static void checkAllShardTableColumn(String tableName, String entityNumber) throws SQLException {
        TableManager tm = XDBConfig.getTableManager();
        List<String> shardingTables = Arrays.asList(tm.getShardingTable(tableName));
        shardingTables.sort((key1, key2) -> {
            long tableName1 = TableName.of((String)key1).getShardingIndex();
            long tableName2 = TableName.of((String)key2).getShardingIndex();
            return (int)(tableName1 - tableName2);
        });
        String originalTable = TableName.of((String)tableName).getOriginalsnapTable();
        List originalColumnList = MetaFactory.getMeta().queryColumns(originalTable);
        if (shardingTables.size() > 0) {
            String prototypeTable = TableName.of((String)tableName).getPrototypeTable();
            List prototypeColumnList = MetaFactory.getMeta().queryColumns(prototypeTable);
            if (!XDBManagerUtil.isColumnMatch(originalColumnList, prototypeColumnList)) {
                String error = MessageFormat.format("ShardTaskMovingHandler ShardingDataMoveService error, entitynumber:{0}, originalTable:{1}, shardingTable:{2}, column do not match.", entityNumber, originalTable, prototypeTable);
                throw ExceptionUtil.wrap((String)error);
            }
            for (String shardingTable : shardingTables) {
                MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getMainConfig(TableName.of((String)shardingTable).getOriginalName());
                String curRoute = mainConfig.getOptions().getIndexRoute().getRoute(shardingTable);
                DBRoute dbRoute = DBRoute.of((String)(StringUtils.isEmpty((String)curRoute) ? mainConfig.getOptions().getDbRouteKey() : curRoute));
                List shardingColumnList = MetaFactory.getMeta().queryColumns(dbRoute.getRouteKey(), shardingTable);
                if (XDBManagerUtil.isColumnMatch(originalColumnList, shardingColumnList)) continue;
                String error = MessageFormat.format("ShardTaskMovingHandler ShardingDataMoveService error, entitynumber:{0}, originalTable:{1}, shardingTable:{2}, column do not match.", entityNumber, originalTable, shardingTable);
                throw ExceptionUtil.wrap((String)error);
            }
        }
    }

    private static boolean isColumnMatch(List<Column> columnList, List<Column> toCompareColumnList) {
        Set fromColumnNames = columnList.stream().map(Column::getColumnName).map(String::toLowerCase).collect(Collectors.toSet());
        Set toColumnNames = toCompareColumnList.stream().map(Column::getColumnName).map(String::toLowerCase).collect(Collectors.toSet());
        fromColumnNames.removeAll(toColumnNames);
        if (!fromColumnNames.isEmpty()) {
            return false;
        }
        Set fromColumnNames2 = columnList.stream().map(Column::getColumnName).map(String::toLowerCase).collect(Collectors.toSet());
        Set toColumnNames2 = toCompareColumnList.stream().map(Column::getColumnName).map(String::toLowerCase).collect(Collectors.toSet());
        toColumnNames2.removeAll(fromColumnNames2);
        return toColumnNames2.isEmpty();
    }

    public static Multimap<ShardingConfig, ShardingConfig> getGroupConfigs(List<ShardingConfig> shardingConfigs) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (ShardingConfig sc : shardingConfigs) {
            if (ShardConfigEntity.isLangOrGroupTableShardingDBConfig(sc) || ShardConfigEntity.isLkTableShardingDBConfig(sc) || ShardConfigEntity.isPrivacyTableShardingDBConfig(sc)) {
                multimap.put((Object)((ChildrenTableConfig)sc).getParent(), (Object)sc);
                continue;
            }
            multimap.put((Object)sc, (Object)sc);
        }
        return multimap;
    }

    public static boolean validateFastIndexConfigurable(String fastIndex, String lastFastIndex) {
        HashSet<String> fastIndexSet = new HashSet<String>(Arrays.asList(fastIndex.split(",")));
        HashSet<String> lastFastIndexSet = new HashSet<String>(Arrays.asList(lastFastIndex.split(",")));
        HashSet<String> fastIndexTmp = new HashSet<String>(fastIndexSet);
        HashSet<String> lastFastIndexTmp = new HashSet<String>(lastFastIndexSet);
        fastIndexTmp.removeAll(lastFastIndexSet);
        lastFastIndexTmp.removeAll(fastIndexSet);
        return !fastIndexTmp.isEmpty() || !lastFastIndexTmp.isEmpty();
    }

    public static Properties getStrategyParamsProperties(String strategyParams) {
        Properties ps = new Properties();
        try {
            ps.load(new StringReader(strategyParams));
        }
        catch (IOException e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
        return ps;
    }
}

