/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.entity;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.IPrivacyDataQueryService;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.sharding.tablerw.DBAnyRWContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardConfigStrategyFactory;
import kd.bos.xdb.entity.ShardDetailEntity;
import kd.bos.xdb.entity.ShardDetailUpgradUtil;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mservice.SyncEntityTableContext;
import kd.bos.xdb.repository.ShardDetailRepository;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.sharding.config.AttributeEnum;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.DataRowsRange;
import kd.bos.xdb.sharding.config.FieldDefine;
import kd.bos.xdb.sharding.config.FieldType;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingIndexRoute;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.hash.HashModStrategy;
import kd.bos.xdb.sharding.strategy.map.MapStrategy;
import kd.bos.xdb.sharding.strategy.map.mapper.ValueMapper;
import kd.bos.xdb.tablemanager.TableName;

public class ShardConfigEntity {
    private static final Log log = LogFactory.getLog(ShardConfigEntity.class);
    private static Class<?> linkEntryType;
    private static Method getLinkSet;
    private static Method getTrackerTable;
    private static Method getWbSnapTable;
    private static Method getItems;
    private static Method getGroupTableConfigs;
    private static IPrivacyDataQueryService privacyQueryService;
    private long id;
    private String entitynumber;
    private String shardingfields;
    private String[] shardingProperties;
    private String strategy;
    private String strategyparams;
    private ShardConfigStatusEnum configstatus;
    private long version;
    private String rwmark;
    private List<ShardingConfig> shardingConfigs = null;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getEntitynumber() {
        return this.entitynumber;
    }

    public void setEntitynumber(String entitynumber) {
        this.entitynumber = entitynumber;
    }

    public String getShardingfields() {
        return this.shardingfields;
    }

    public void setShardingfields(String shardingfields) {
        this.shardingfields = shardingfields;
    }

    public String[] getShardingProperties() {
        return this.shardingProperties;
    }

    public void setShardingProperties(String[] shardingProperties) {
        if (shardingProperties != null) {
            ArrayList<String> fs = new ArrayList<String>(shardingProperties.length);
            for (String f : shardingProperties) {
                if (f == null || (f = f.trim()).length() == 0) continue;
                fs.add(f);
            }
            shardingProperties = fs.toArray(new String[fs.size()]);
        }
        this.shardingProperties = shardingProperties;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getStrategyparams() {
        return this.strategyparams;
    }

    public void setStrategyparams(String strategyparams) {
        this.strategyparams = strategyparams;
    }

    public ShardConfigStatusEnum getConfigstatus() {
        return this.configstatus;
    }

    public void setConfigstatus(ShardConfigStatusEnum configstatus) {
        this.configstatus = configstatus;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getRwmark() {
        return this.rwmark;
    }

    public void setRwmark(String rwmark) {
        this.rwmark = rwmark;
    }

    public String toString() {
        return this.entitynumber + ' ' + Arrays.asList(this.shardingProperties) + ' ' + this.strategy;
    }

    public List<ShardingConfig> toShardingConfigs() {
        return this.toShardingConfigs(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShardingConfig> toShardingConfigs(boolean isMock) {
        if (this.shardingConfigs == null) {
            ShardConfigEntity shardConfigEntity = this;
            synchronized (shardConfigEntity) {
                if (this.shardingConfigs == null) {
                    String[] fields;
                    ArrayList<ShardingConfig> ret = new ArrayList<ShardingConfig>();
                    ShardingStrategy ss = ShardConfigStrategyFactory.create(this.strategy, StringUtils.isEmpty((String)this.strategyparams) ? "index_pk=true" : (this.strategyparams.indexOf("index_pk=false") != -1 ? this.strategyparams : this.strategyparams + "\nindex_pk=true"));
                    Properties paramsProperties = XDBManagerUtil.getStrategyParamsProperties(this.strategyparams);
                    String range = paramsProperties.getProperty("range", DataRowsRange.less10.name());
                    DataRowsRange dataRowsRange = DataRowsRange.valueOf((String)range);
                    boolean isDetailInited = ShardTaskConfig.isConfigInitFromDetailEnable() && !isMock && ShardDetailUpgradUtil.isUpgraded() && ShardDetailRepository.get().countDetail(this.entitynumber) > 0L;
                    boolean isDeatilToConfig = false;
                    if (isDetailInited && SyncEntityTableContext.get() == null) {
                        List<ShardDetailEntity> detailEntityList = ShardDetailRepository.get().loadDetailList(this.entitynumber);
                        ShardDetailEntity mainEntity = (ShardDetailEntity)detailEntityList.stream().filter(item -> item.getLevel() == 1).collect(Collectors.toList()).get(0);
                        if (this.isConfigDetailSame(mainEntity)) {
                            fields = new String[this.shardingProperties.length];
                            String shardfield = mainEntity.getShardfield();
                            IndexDefine[] fieldsDefine = this.buildIndexDefines(shardfield);
                            int i = 0;
                            for (IndexDefine fieldDefine : fieldsDefine) {
                                fields[i] = fieldDefine.getField();
                                ++i;
                            }
                            String dbRouteKey = mainEntity.getDbRouteKey();
                            String indexfield = mainEntity.getIndexfield();
                            IndexDefine[] indexDefines = this.buildIndexDefines(indexfield);
                            ShardingConfig rootConfig = ShardingConfig.table((String)this.entitynumber, (String)mainEntity.getName().toLowerCase(), (String)mainEntity.getTablename(), (FieldDefine[])fieldsDefine, (ShardingStrategy)ss, (DataRowsRange)dataRowsRange, (IndexDefine[])indexDefines, (boolean)false);
                            rootConfig.getOptions().setIndexRoute(this.handleShardingIndexRoute(dbRouteKey, rootConfig.getTable()));
                            ((MainTableConfig)rootConfig).setPKField(mainEntity.getParentfield());
                            if (ss.getConfig() instanceof MainTableConfig && ((AbstractShardingStrategy)ss).isIndexPK()) {
                                ((AbstractShardingStrategy)ss).setPKField(mainEntity.getParentfield());
                            }
                            if (ss instanceof MapStrategy) {
                                this.setRetainIndexFields((MapStrategy)ss, (FieldDefine[])fieldsDefine, fields);
                            }
                            rootConfig.setEnabled(ShardConfigStatusEnum.ENABLE == this.configstatus);
                            ret.add(rootConfig);
                            HashMap<String, ShardingConfig> shardingConfigMap = new HashMap<String, ShardingConfig>(8);
                            shardingConfigMap.put(rootConfig.getTable(), rootConfig);
                            List childEntityList = detailEntityList.stream().filter(item -> item.getLevel() > 1).collect(Collectors.toList());
                            for (ShardDetailEntity detailEntity : childEntityList) {
                                ShardingConfig childrenConfig = ShardingConfig.childrenTable((String)detailEntity.getName().toLowerCase(), (String)detailEntity.getTablename(), (String)detailEntity.getJoinfield(), (String)detailEntity.getParentfield(), (ShardingConfig)((ShardingConfig)shardingConfigMap.get(detailEntity.getParenttable())), (boolean)false);
                                if (StringUtils.isNotEmpty((String)detailEntity.getAtrribute())) {
                                    AttributeEnum attributeEnum = AttributeEnum.valueOf((String)detailEntity.getAtrribute());
                                    if (attributeEnum == AttributeEnum.is_lang_table) {
                                        ((ChildrenTableConfig)childrenConfig).setLangTableConfig();
                                    } else if (attributeEnum == AttributeEnum.is_group_table) {
                                        ((ChildrenTableConfig)childrenConfig).setGroupTableConfig();
                                    } else if (attributeEnum == AttributeEnum.is_lk_table) {
                                        ((ChildrenTableConfig)childrenConfig).setLkTableConfig();
                                    } else if (attributeEnum == AttributeEnum.is_tc_table) {
                                        ((ChildrenTableConfig)childrenConfig).setTcTableConfig();
                                    } else if (attributeEnum == AttributeEnum.is_wb_table) {
                                        ((ChildrenTableConfig)childrenConfig).setWbTableConfig();
                                    } else if (attributeEnum == AttributeEnum.is_privacy_table) {
                                        ((ChildrenTableConfig)childrenConfig).setPrivacyTableConfig();
                                    }
                                }
                                ret.add(childrenConfig);
                                shardingConfigMap.put(childrenConfig.getTable(), childrenConfig);
                            }
                            ret.forEach(sc -> sc.getOptions().setDbRouteKey(dbRouteKey));
                            isDeatilToConfig = true;
                        } else {
                            ShardDetailRepository.get().deleteDetail(this.entitynumber);
                        }
                    }
                    if (!isDeatilToConfig) {
                        IDataEntityType dt;
                        try {
                            dt = ORM.create().getDataEntityType(this.entitynumber);
                        }
                        catch (Exception e) {
                            if (ShardTaskConfig.isMetaloadErrorIgnore()) {
                                XDBManagerUtil.logError(String.format("ShardConfigEntity toShardingConfigs error, entityNumber:%s", this.entitynumber), e);
                                return ret;
                            }
                            throw ExceptionUtil.wrap((Throwable)e);
                        }
                        String dbRouteKey = dt.getDBRouteKey();
                        fields = new String[this.shardingProperties.length];
                        FieldDefine[] fieldsDefine = new FieldDefine[this.shardingProperties.length];
                        int i = 0;
                        for (String p : this.shardingProperties) {
                            fields[i] = ((IDataEntityProperty)dt.getProperties().get((Object)p)).getAlias();
                            fieldsDefine[i] = this.createIndexDefile(p, dt);
                            ++i;
                        }
                        IndexDefine[] indexDefines = this.buildIndexDefines(dt, paramsProperties.getProperty("indices"));
                        ShardingConfig rootConfig = ShardingConfig.table((String)this.entitynumber, (String)dt.getName().toLowerCase(), (String)dt.getAlias(), (FieldDefine[])fieldsDefine, (ShardingStrategy)ss, (DataRowsRange)dataRowsRange, (IndexDefine[])indexDefines, (boolean)isMock);
                        rootConfig.getOptions().setIndexRoute(this.handleShardingIndexRoute(dbRouteKey, rootConfig.getTable()));
                        ((MainTableConfig)rootConfig).setPKField(dt.getPrimaryKey().getAlias());
                        if (ss.getConfig() instanceof MainTableConfig && ((AbstractShardingStrategy)ss).isIndexPK()) {
                            ((AbstractShardingStrategy)ss).setPKField(dt.getPrimaryKey().getAlias());
                        }
                        if (ss instanceof MapStrategy) {
                            this.setRetainIndexFields((MapStrategy)ss, fieldsDefine, fields);
                        }
                        rootConfig.setEnabled(ShardConfigStatusEnum.ENABLE == this.configstatus);
                        ret.add(rootConfig);
                        this.collectBOTPShardingConfig(ret, dt, rootConfig, isMock);
                        this.collectShardingConfig(dt, true, rootConfig, ret, isMock);
                        this.collectRuntimeShardingConfig(ret, isMock);
                        this.collectPrivacyShardingConfig(ret, isMock);
                        ret.forEach(sc -> sc.getOptions().setDbRouteKey(dbRouteKey));
                        if (ShardDetailUpgradUtil.isUpgraded() && !isMock) {
                            ShardDetailUpgradUtil.initShardingDeatil(this, ret);
                        }
                    }
                    this.shardingConfigs = ret;
                }
            }
        }
        return this.shardingConfigs;
    }

    private boolean isConfigDetailSame(ShardDetailEntity mainEntity) {
        if (StringUtils.isEmpty((String)mainEntity.getParentfield())) {
            return false;
        }
        String shardProperties = mainEntity.getShardproperties();
        String[] detailShardArray = StringUtils.isNotEmpty((String)shardProperties) ? shardProperties.split(",") : new String[]{};
        String indices = XDBManagerUtil.getStrategyParamsProperties(this.strategyparams).getProperty("indices");
        String indexProperties = mainEntity.getIndexproperties();
        String[] detailIndexArray = StringUtils.isNotEmpty((String)indexProperties) ? indexProperties.split(",") : new String[]{};
        String[] configIndexArray = StringUtils.isNotEmpty((String)indices) ? indices.split(",") : new String[]{};
        String[] tempShardingProperties = new String[this.shardingProperties.length];
        System.arraycopy(this.shardingProperties, 0, tempShardingProperties, 0, this.shardingProperties.length);
        return this.isArraySame(detailShardArray, tempShardingProperties) && this.isArraySame(detailIndexArray, configIndexArray);
    }

    private boolean isArraySame(String[] str1, String[] str2) {
        Arrays.sort(str1);
        Arrays.sort(str2);
        return Arrays.equals(str1, str2);
    }

    private IndexDefine[] buildIndexDefines(String indices) {
        if (StringUtils.isNotEmpty((String)indices)) {
            String[] indexArray = indices.split(",");
            ArrayList<IndexDefine> ret = new ArrayList<IndexDefine>(indexArray.length);
            for (String property : indexArray) {
                String[] split = property.split("#");
                IndexDefine def = new IndexDefine(split[0], split[1], FieldType.valueOf((String)split[2]));
                ret.add(def);
            }
            return ret.toArray(new IndexDefine[ret.size()]);
        }
        return null;
    }

    private IndexDefine[] buildIndexDefines(IDataEntityType dt, String indices) {
        if (StringUtils.isNotEmpty((String)indices)) {
            String[] indexArray = indices.split(",");
            ArrayList<IndexDefine> ret = new ArrayList<IndexDefine>(indexArray.length);
            for (String property : indexArray) {
                IndexDefine def = this.createIndexDefile(property, dt);
                if (def == null) continue;
                ret.add(def);
            }
            return ret.toArray(new IndexDefine[ret.size()]);
        }
        return null;
    }

    private IndexDefine createIndexDefile(String property, IDataEntityType dt) {
        IDataEntityProperty dp = (IDataEntityProperty)dt.getProperties().get((Object)property);
        if (dp == null) {
            return null;
        }
        Class propertyType = dp instanceof IComplexProperty ? ((IComplexProperty)dp).getComplexType().getPrimaryKey().getPropertyType() : dp.getPropertyType();
        FieldType fieldType = this.findFieldType(propertyType);
        String table = dt.getAlias();
        String group = dp.getTableGroup();
        if (group != null && group.length() > 0) {
            table = table + '_' + group;
        }
        return new IndexDefine(table, dp.getAlias(), fieldType);
    }

    private FieldType findFieldType(Class<?> propertyType) {
        if (propertyType == Integer.class) {
            return FieldType.INTEGER;
        }
        if (propertyType == String.class) {
            return FieldType.STRING;
        }
        if (propertyType == Date.class) {
            return FieldType.DATE;
        }
        return FieldType.LONG;
    }

    private void collectBOTPShardingConfig(List<ShardingConfig> ret, IDataEntityType dt, ShardingConfig rootConfig, boolean isMock) {
        try {
            String tc;
            ArrayList linkItems;
            Object linkSet = getLinkSet.invoke(null, this.entitynumber);
            if (linkSet != null && (linkItems = (ArrayList)getItems.invoke(linkSet, new Object[0])) != null && !linkItems.isEmpty() && (tc = (String)getTrackerTable.invoke(linkSet, new Object[0])) != null && tc.trim().length() > 0) {
                tc = tc.trim().toLowerCase();
                ShardingConfig tcConfig = ShardingConfig.childrenTable((String)(dt.getName().toLowerCase() + ".track"), (String)tc, (String)"FTBillId", (String)dt.getPrimaryKey().getAlias(), (ShardingConfig)rootConfig, (boolean)isMock);
                ((ChildrenTableConfig)tcConfig).setTcTableConfig();
                String wb = (String)getWbSnapTable.invoke(linkSet, new Object[0]);
                ret.add(tcConfig);
                if (wb != null && wb.trim().length() > 0) {
                    wb = wb.trim().toLowerCase();
                    ShardingConfig wbConfig = ShardingConfig.childrenTable((String)(dt.getName().toLowerCase() + ".wb"), (String)wb, (String)"FID", (String)"FID", (ShardingConfig)tcConfig, (boolean)isMock);
                    ((ChildrenTableConfig)wbConfig).setWbTableConfig();
                    ret.add(wbConfig);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    private void collectPrivacyShardingConfig(List<ShardingConfig> ret, boolean isMock) {
        ArrayList trunkConfig = new ArrayList(3);
        ret.forEach(sc -> {
            if (sc instanceof MainTableConfig || ((ChildrenTableConfig)sc).isEntryTableConfig() || ((ChildrenTableConfig)sc).isGroupTableConfig()) {
                trunkConfig.add(sc);
            }
        });
        trunkConfig.forEach(sc -> {
            try {
                boolean isPrivacy = privacyQueryService.isTableHaveEncryptField(sc.getTable());
                if (isPrivacy) {
                    String parentField;
                    String privacyTableName = privacyQueryService.getEncryptTableName(sc.getTable());
                    ShardingConfig parent = sc;
                    if (sc instanceof MainTableConfig) {
                        parentField = "fid";
                    } else {
                        ShardingConfig parentConfig = ((ChildrenTableConfig)sc).getParent();
                        parentField = parentConfig instanceof MainTableConfig ? "fentryid" : "fdetailid";
                        if (((ChildrenTableConfig)sc).isGroupTableConfig()) {
                            parent = parentConfig;
                        }
                    }
                    ShardingConfig privacyConfig = ShardingConfig.childrenTable((String)(sc.getName() + ".privacy"), (String)privacyTableName, (String)"FbizId", (String)parentField, (ShardingConfig)parent, (boolean)isMock);
                    ((ChildrenTableConfig)privacyConfig).setPrivacyTableConfig();
                    ret.add(privacyConfig);
                }
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
        });
    }

    private void collectShardingConfig(IDataEntityType dt, boolean rootDT, ShardingConfig parent, List<ShardingConfig> list, boolean isMock) {
        ShardingConfig currentLevelShardingConfig = parent;
        if (!rootDT) {
            String pkField = dt.getParent().getPrimaryKey().getAlias();
            ShardingConfig children = ShardingConfig.childrenTable((String)(parent.getName() + '.' + dt.getName().toLowerCase()), (String)dt.getAlias(), (String)pkField, (String)pkField, (ShardingConfig)parent, (boolean)isMock);
            list.add(children);
            currentLevelShardingConfig = children;
        }
        ArrayList<ShardingConfig> childList = new ArrayList<ShardingConfig>();
        HashSet<String> tableGroupSet = new HashSet<String>();
        DataEntityPropertyCollection dps = dt.getProperties();
        int n = dps.size();
        for (int i = 0; i < n; ++i) {
            IDataEntityProperty dp = (IDataEntityProperty)dps.get(i);
            this.collectShardingConfig(dp, tableGroupSet, currentLevelShardingConfig, childList, isMock);
        }
        String pkField = dt.getPrimaryKey().getAlias();
        String name = rootDT ? dt.getName().toLowerCase() : parent.getName() + '.' + dt.getName().toLowerCase();
        for (String ext : tableGroupSet) {
            ShardingConfig extConfig = ShardingConfig.childrenTable((String)name, (String)(dt.getAlias() + '_' + ext.toLowerCase()), (String)pkField, (String)pkField, (ShardingConfig)currentLevelShardingConfig, (boolean)isMock);
            ShardConfigEntity.setAttr(extConfig);
            list.add(extConfig);
        }
        if (!childList.isEmpty()) {
            list.addAll(childList);
        }
    }

    private void collectShardingConfig(IDataEntityProperty dp, Set<String> tableGroupSet, ShardingConfig currentLevelShardingConfig, List<ShardingConfig> childList, boolean isMock) {
        if (dp instanceof ICollectionProperty) {
            if (dp instanceof DynamicLocaleProperty) {
                tableGroupSet.add("L");
            } else {
                IDataEntityType itemDT = ((ICollectionProperty)dp).getItemType();
                if (IEntryType.class.isAssignableFrom(itemDT.getClass()) && itemDT.getAlias() != null && itemDT.getAlias().trim().length() > 0 && !itemDT.isDbIgnore()) {
                    Class<?> cls = itemDT.getClass();
                    if (linkEntryType.isAssignableFrom(cls)) {
                        String pkField = itemDT.getParent().getPrimaryKey().getAlias();
                        ShardingConfig children = ShardingConfig.childrenTable((String)(currentLevelShardingConfig.getName() + '.' + itemDT.getName().toLowerCase()), (String)itemDT.getAlias(), (String)pkField, (String)pkField, (ShardingConfig)currentLevelShardingConfig, (boolean)isMock);
                        ((ChildrenTableConfig)children).setLkTableConfig();
                        childList.add(children);
                    } else {
                        this.collectShardingConfig(itemDT, false, currentLevelShardingConfig, childList, isMock);
                    }
                }
            }
        } else if (!(dp instanceof IComplexProperty) && !ORMUtil.isDbIgnoreRefBaseData((IDataEntityProperty)dp)) {
            String tableGroup;
            if (ORMUtil.isDbIgnore((IDataEntityProperty)dp)) {
                // empty if block
            }
            if ((tableGroup = dp.getTableGroup()) != null && tableGroup.length() > 0) {
                tableGroupSet.add(tableGroup.toUpperCase());
            }
        }
    }

    private void collectRuntimeShardingConfig(List<ShardingConfig> ret, boolean isMock) {
        try {
            List groupTableConfigs;
            Object invoke = getGroupTableConfigs.invoke(null, this.entitynumber, ret, isMock);
            if (invoke != null && !(groupTableConfigs = (List)invoke).isEmpty()) {
                groupTableConfigs.removeIf(sc -> {
                    for (ShardingConfig shardingConfig : ret) {
                        if (!shardingConfig.getTable().equals(sc.getTable())) continue;
                        return true;
                    }
                    return false;
                });
                if (!groupTableConfigs.isEmpty()) {
                    ret.addAll(groupTableConfigs);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    private void setRetainIndexFields(MapStrategy ss, FieldDefine[] fieldsDefine, String[] fields) {
        HashSet<String> retainIndexFieldsSet = new HashSet<String>();
        Properties paramsProperties = XDBManagerUtil.getStrategyParamsProperties(this.strategyparams);
        String pattern = paramsProperties.getProperty("pattern");
        for (FieldDefine fieldDefine : fieldsDefine) {
            if (fieldDefine.getType() != FieldType.DATE || !"yyyy".equalsIgnoreCase(pattern)) continue;
            retainIndexFieldsSet.add(fieldDefine.getField());
        }
        ValueMapper[] valueMappers = ss.getValueMappers();
        if (null != valueMappers) {
            for (int j = 0; j < valueMappers.length; ++j) {
                if (valueMappers[j] == null) continue;
                retainIndexFieldsSet.add(fields[j]);
            }
        }
        String[] retainIndexFields = retainIndexFieldsSet.toArray(new String[0]);
        ss.setRetainIndexFields(retainIndexFields);
    }

    public static boolean isLangOrGroupTableShardingDBConfig(ShardingConfig sc) {
        return ShardConfigEntity.isLangTableShardingDBConfig(sc) || ShardConfigEntity.isGroupTableShardingDBConfig(sc);
    }

    public static boolean isLangTableShardingDBConfig(ShardingConfig sc) {
        return sc instanceof ChildrenTableConfig && ((ChildrenTableConfig)sc).isLangTableConfig();
    }

    public static boolean isGroupTableShardingDBConfig(ShardingConfig sc) {
        return sc instanceof ChildrenTableConfig && ((ChildrenTableConfig)sc).isGroupTableConfig();
    }

    public static boolean isTcTableShardingDBConfig(ShardingConfig sc) {
        return sc instanceof ChildrenTableConfig && ((ChildrenTableConfig)sc).isTcTableConfig();
    }

    public static boolean isWbTableShardingDBConfig(ShardingConfig sc) {
        return sc instanceof ChildrenTableConfig && ((ChildrenTableConfig)sc).isWbTableConfig();
    }

    public static boolean isLkTableShardingDBConfig(ShardingConfig sc) {
        return sc instanceof ChildrenTableConfig && ((ChildrenTableConfig)sc).isLkTableConfig();
    }

    public static boolean isPrivacyTableShardingDBConfig(ShardingConfig sc) {
        return sc instanceof ChildrenTableConfig && ((ChildrenTableConfig)sc).isPrivacyTableConfig();
    }

    private static void setAttr(ShardingConfig sc) {
        if (sc.getTable().endsWith("_l")) {
            ((ChildrenTableConfig)sc).setLangTableConfig();
        } else {
            ((ChildrenTableConfig)sc).setGroupTableConfig();
        }
    }

    public static ShardConfigEntity mockShardConfigEntity(String entityName) {
        IDataEntityType dt = ORM.create().getDataEntityType(entityName);
        ShardConfigEntity config = new ShardConfigEntity();
        config.setEntitynumber(entityName);
        config.setStrategy(HashModStrategy.class.getSimpleName());
        config.setStrategyparams("mod=2");
        config.setShardingProperties(new String[]{dt.getPrimaryKey().getName()});
        config.setConfigstatus(ShardConfigStatusEnum.DISABLE);
        return config;
    }

    private ShardingIndexRoute handleShardingIndexRoute(String mainDbRoute, String mainTable) {
        String rtTable = TableName.of((String)mainTable).getRTTable();
        ConcurrentHashMap ret = new ConcurrentHashMap(256);
        if (DB.exitsTable((DBRoute)DBRoute.of((String)mainDbRoute), (String)rtTable)) {
            String sql = String.format("/*dialect*/select findex,froute from %s", rtTable);
            try (DBAnyRWContext ctx = DBShardingRuntime.get().setupThreadDBAnyRWContext();){
                DB.query((DBRoute)DBRoute.of((String)mainDbRoute), (String)sql, rs -> {
                    while (rs.next()) {
                        long shardingIndex = rs.getLong(1);
                        String curRoute = rs.getString(2);
                        ret.put(shardingIndex, curRoute);
                    }
                    return ret;
                });
            }
        }
        ShardingIndexRoute shardingIndexRoute = new ShardingIndexRoute(ret);
        shardingIndexRoute.setMainRouteKey(mainDbRoute);
        return shardingIndexRoute;
    }

    static {
        try {
            linkEntryType = Class.forName("kd.bos.entity.LinkEntryType");
            getLinkSet = Class.forName("kd.bos.entity.EntityMetadataCache").getMethod("getLinkSet", String.class);
            Class<?> ecls = Class.forName("kd.bos.entity.LinkSetElement");
            getTrackerTable = ecls.getMethod("getTrackerTable", new Class[0]);
            getWbSnapTable = ecls.getMethod("getWbSnapTable", new Class[0]);
            getItems = ecls.getMethod("getItems", new Class[0]);
            getTrackerTable.setAccessible(true);
            getWbSnapTable.setAccessible(true);
            getItems.setAccessible(true);
            getGroupTableConfigs = Class.forName("kd.bos.metadata.dao.ShardingUtil").getMethod("getGroupTableShardingConfigsInEntityByNumber", String.class, List.class, Boolean.TYPE);
            privacyQueryService = (IPrivacyDataQueryService)Class.forName("kd.bos.privacy.service.PrivacyDataQueryService").newInstance();
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }
}

