/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.dlock.DLock;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.entity.ShardDetailEntity;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mservice.SyncEntityTableContext;
import kd.bos.xdb.repository.ShardDetailRepository;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.sharding.config.AttributeEnum;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.FieldDefine;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;

public class ShardDetailUpgradUtil {
    private static final Log log = LogFactory.getLog(ShardDetailUpgradUtil.class);
    private static final Map<String, UpgradedCache> upgradMap = new ConcurrentHashMap<String, UpgradedCache>();

    public static boolean isUpgraded() {
        RequestContextInfo rci = RequestContextInfo.get();
        String accountId = rci.getAccountId();
        return upgradMap.computeIfAbsent(accountId, key -> new UpgradedCache()).isUpgraded();
    }

    public static void initShardingDeatil(ShardConfigEntity configEntity, List<ShardingConfig> shardingConfigs) {
        String entityNumber = configEntity.getEntitynumber();
        if (SyncEntityTableContext.get() != null) {
            if (ShardDetailUpgradUtil.isRuntimeChange(entityNumber, shardingConfigs)) {
                RequestContextInfo rc = RequestContextInfo.get();
                String lockKey = ShardDetailUpgradUtil.getInitShardDetailLockKey(rc.getAccountId(), entityNumber);
                try {
                    DLock.lock((String)lockKey, () -> {
                        if (ShardDetailUpgradUtil.isRuntimeChange(entityNumber, shardingConfigs)) {
                            ShardDetailRepository.get().deleteDetail(entityNumber);
                            ShardDetailUpgradUtil.inertShardingDeatil(configEntity, shardingConfigs);
                            if (ShardTaskConfig.isConfigInitFromDetailEnable()) {
                                ShardingManager.get().notifyReloadShardingConfig(entityNumber);
                            }
                        }
                        return null;
                    });
                }
                catch (Exception e) {
                    XDBManagerUtil.logError(String.format("ShardDetailUpgradUtil runtimeChange inertShardingDeatil error, entityNumber:%s", entityNumber), e);
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        } else {
            long cnt = ShardDetailRepository.get().countDetail(entityNumber);
            if (cnt > 0L) {
                return;
            }
            RequestContextInfo rc = RequestContextInfo.get();
            String lockKey = ShardDetailUpgradUtil.getInitShardDetailLockKey(rc.getAccountId(), entityNumber);
            kd.bos.dlock.DLock lock = kd.bos.dlock.DLock.create((String)lockKey);
            if (lock.tryLock()) {
                try {
                    cnt = ShardDetailRepository.get().countDetail(entityNumber);
                    if (cnt > 0L) {
                        return;
                    }
                    ShardDetailUpgradUtil.inertShardingDeatil(configEntity, shardingConfigs);
                }
                catch (Exception e) {
                    XDBManagerUtil.logError(String.format("ShardDetailUpgradUtil inertShardingDeatil error, entityNumber:%s", entityNumber), e);
                    throw ExceptionUtil.wrap((Throwable)e);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    public static void initPrivacyShardingDeatil(ShardConfigEntity configEntity, final ShardingConfig shardingConfig) {
        String entityNumber = configEntity.getEntitynumber();
        RequestContextInfo rc = RequestContextInfo.get();
        AtomicLong cnt = new AtomicLong(ShardDetailRepository.get().countDetailByTable(shardingConfig.getTable()));
        if (cnt.get() > 0L) {
            return;
        }
        try {
            String lockKey = ShardDetailUpgradUtil.getInitShardDetailLockKey(rc.getAccountId(), entityNumber);
            DLock.lock((String)lockKey, () -> {
                cnt.set(ShardDetailRepository.get().countDetailByTable(shardingConfig.getTable()));
                if (cnt.get() > 0L) {
                    return null;
                }
                ShardDetailUpgradUtil.inertShardingDeatil(configEntity, (List<ShardingConfig>)new ArrayList<ShardingConfig>(){
                    {
                        this.add(shardingConfig);
                    }
                });
                if (ShardTaskConfig.isConfigInitFromDetailEnable()) {
                    ShardingManager.get().notifyReloadShardingConfig(entityNumber);
                }
                return null;
            });
        }
        catch (Exception e) {
            XDBManagerUtil.logError(String.format("ShardDetailUpgradUtil initPrivacyShardingDeatil error, entityNumber:%s", entityNumber), e);
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    private static void inertShardingDeatil(ShardConfigEntity configEntity, List<ShardingConfig> runtimeShardingConfigs) {
        ArrayList<ShardDetailEntity> detailEntityList = new ArrayList<ShardDetailEntity>(runtimeShardingConfigs.size());
        for (ShardingConfig config : runtimeShardingConfigs) {
            ShardDetailEntity detailEntity = new ShardDetailEntity();
            detailEntityList.add(detailEntity);
            detailEntity.setEntitynumber(configEntity.getEntitynumber());
            detailEntity.setName(config.getName());
            detailEntity.setTablename(config.getTable());
            detailEntity.setLevel(config.getLevel());
            detailEntity.setDbRouteKey(config.getOptions().getDbRouteKey());
            if (config instanceof ChildrenTableConfig) {
                ChildrenTableConfig childrenTableConfig = (ChildrenTableConfig)config;
                detailEntity.setParenttable(childrenTableConfig.getParent().getTable());
                detailEntity.setParentfield(childrenTableConfig.getParentField());
                detailEntity.setJoinfield(childrenTableConfig.getJoinField());
                String attribute = childrenTableConfig.isLangTableConfig() ? AttributeEnum.is_lang_table.name() : (childrenTableConfig.isGroupTableConfig() ? AttributeEnum.is_group_table.name() : (childrenTableConfig.isLkTableConfig() ? AttributeEnum.is_lk_table.name() : (childrenTableConfig.isTcTableConfig() ? AttributeEnum.is_tc_table.name() : (childrenTableConfig.isWbTableConfig() ? AttributeEnum.is_wb_table.name() : (childrenTableConfig.isPrivacyTableConfig() ? AttributeEnum.is_privacy_table.name() : "")))));
                detailEntity.setAtrribute(attribute);
                continue;
            }
            detailEntity.setShardproperties(configEntity.getShardingfields());
            detailEntity.setIndexproperties(XDBManagerUtil.getStrategyParamsProperties(configEntity.getStrategyparams()).getProperty("indices"));
            FieldDefine[] shardDefines = config.getOptions().getShardDefines();
            StringBuilder shardStr = new StringBuilder();
            for (FieldDefine shardDefine : shardDefines) {
                shardStr.append(shardDefine.toString()).append(',');
            }
            detailEntity.setShardfield(shardStr.substring(0, shardStr.length() - 1));
            IndexDefine[] indexDefines = config.getOptions().getIndexDefines();
            if (indexDefines != null && indexDefines.length > 0) {
                StringBuilder indexStr = new StringBuilder();
                for (IndexDefine indexDefine : indexDefines) {
                    indexStr.append(indexDefine.toString()).append(',');
                }
                detailEntity.setIndexfield(indexStr.substring(0, indexStr.length() - 1));
            }
            detailEntity.setParentfield(((MainTableConfig)config).getPKField());
        }
        try (XDBExternal tx = XDBExternal.requiresNew((String)"insertDetail");){
            ShardDetailRepository.get().insertDetail(detailEntityList);
        }
    }

    private static boolean isRuntimeChange(String entityNumber, List<ShardingConfig> runtimeShardingConfigs) {
        List<ShardDetailEntity> detailEntityList = ShardDetailRepository.get().loadDetailList(entityNumber);
        Object[] curTableArray = (String[])detailEntityList.stream().map(item -> item.getTablename()).toArray(String[]::new);
        Object[] runtimeTableArray = (String[])runtimeShardingConfigs.stream().map(item -> item.getTable()).toArray(String[]::new);
        Arrays.sort(curTableArray);
        Arrays.sort(runtimeTableArray);
        return !Arrays.equals(curTableArray, runtimeTableArray);
    }

    public static String getInitShardDetailLockKey(String accountId, String entityName) {
        return "/xdbsharding/init_shard/" + accountId + "/" + entityName;
    }

    static class UpgradedCache {
        private boolean exitsTableLoad = false;
        private boolean upgraded = false;

        UpgradedCache() {
        }

        public boolean isUpgraded() {
            if (!this.exitsTableLoad) {
                this.upgraded = DB.exitsTableForManager((DBRoute)DBRoute.base, (String)"t_cbs_shard_detail");
                this.exitsTableLoad = true;
            }
            return this.upgraded;
        }
    }
}

