/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mq;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.mq.OperationLogBody;
import kd.bos.xdb.mq.ShardLogConsumer;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.util.DateUtil;

public class ShardLogPublish {
    private static final Log logger = LogFactory.getLog(ShardLogConsumer.class);
    public static final ShardLogPublish instance = new ShardLogPublish();

    public static ShardLogPublish get() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishOperationLog(long taskId, String entityName, String log, String progresstype) {
        try {
            if (null == progresstype) {
                progresstype = "";
            }
            SimpleDateFormat sdf = DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss.SSS");
            log = "[" + sdf.format(new Date()) + "] " + log;
            long id = IDUtil.id();
            int N = 1333;
            if (log.length() > 1333) {
                log = log.substring(0, 1333);
            }
            if (logger.isInfoEnabled() || ShardTaskConfig.isEnableMovingLog()) {
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler ShardLogPublish  entitynumber:{0}, taskId:{1}, progresstype:{2}, log:{3}", entityName, taskId, progresstype, log));
            }
            try (MessagePublisher pub = MQFactory.get().createSimplePublisher("bos", "kd.bos.xdb.mq.XdbTaskMovingLog");){
                OperationLogBody logBody = new OperationLogBody(id, taskId, entityName, log, progresstype, new Date());
                ObjectMapper objectMapper = new ObjectMapper();
                String message = objectMapper.writeValueAsString((Object)logBody);
                pub.publish(message);
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ShardTaskMovingHandler ShardLogPublish publishOperationLog error outter, entitynumber:{0}, taskId:{1}, errorinfo:{2}", entityName, taskId, sw.toString());
            XDBManagerUtil.logError(error, e);
        }
    }
}

