/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mservice;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.context.XDBContext;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.entity.ShardDetailUpgradUtil;
import kd.bos.xdb.entity.ShardRuntimeConfigEntity;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mservice.Condition;
import kd.bos.xdb.mservice.ShardingMetadataService;
import kd.bos.xdb.mservice.SyncEntityTableContext;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.map.MapStrategy;
import kd.bos.xdb.sharding.strategy.map.ShardingIndexMap;
import kd.bos.xdb.sharding.strategy.map.mapper.HashModMapper;
import kd.bos.xdb.sharding.strategy.map.mapper.ValueMapper;
import kd.bos.xdb.util.HashCodeUtil;

public class ShardingMetadataServiceImpl
implements ShardingMetadataService {
    public static final ShardingMetadataServiceImpl INSTANCE = new ShardingMetadataServiceImpl();
    private static final Log logger = LogFactory.getLog(ShardingMetadataServiceImpl.class);

    @Override
    public List<String> getShardingTableName(String entityNumber, Map<String, Object> params) {
        ArrayList<String> tables = new ArrayList<String>(3);
        if (!DB.isXDBEnable()) {
            return tables;
        }
        ORM orm = ORM.create();
        IDataEntityType dt = orm.getDataEntityType(entityNumber);
        String pk = dt.getPrimaryKey().getName();
        String table = dt.getAlias();
        ShardingConfig shardConfig = XDBConfig.getShardingConfigProvider().getConfig(table);
        if (shardConfig == null) {
            return tables;
        }
        List<Condition> conditions = Condition.form(params);
        Map<String, List<Condition>> cmap = this.filterValidFields(shardConfig, dt, conditions);
        if (cmap.isEmpty()) {
            return tables;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        for (Map.Entry<String, List<Condition>> entry : cmap.entrySet()) {
            List<Condition> valueList = entry.getValue();
            for (Condition condition : valueList) {
                QFilter qFilter = new QFilter(condition.property, condition.cp, condition.value);
                qFilterList.add(qFilter);
            }
        }
        try (XDBContext ctx = XDB.createContext();){
            ctx.addShardingListener(srs -> {
                List tableInfoList;
                ShardingResult sr = srs[0];
                StatementInfo statementInfo = sr.getStatementInfo();
                if (statementInfo != null && !(tableInfoList = statementInfo.getTableInfos()).isEmpty()) {
                    SQLInfo[] sis;
                    TableInfo tableInfo = (TableInfo)tableInfoList.get(0);
                    String name = tableInfo.getName();
                    for (SQLInfo si : sis = sr.getSQLInfos()) {
                        String sql = si.getSql();
                        int indexTable = sql.indexOf(name);
                        sql = sql.substring(indexTable);
                        int indexOf = sql.indexOf(32);
                        sql = sql.substring(0, indexOf);
                        sql = sql.replaceAll("`", "");
                        tables.add(sql);
                    }
                }
            });
            DataSet dataSet = ORM.create().queryDataSet("ShardingCalcIndexFormPlugin", entityNumber, pk, qFilterList.toArray(new QFilter[0]));
            Iterator<Condition> iterator = null;
            if (dataSet != null) {
                if (iterator != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        Collections.sort(tables, Comparator.comparing(s -> {
            String index = s.substring(s.indexOf("$") + 1);
            if (index.equals("_")) {
                return 0L;
            }
            return Long.parseLong(index);
        }));
        return tables;
    }

    @Override
    public Map<Integer, List<Object>> getModValuesByModField(String entityNumber, String shardingFieldName, List<Object> modFieldValues) {
        ShardingConfig shardConfig;
        HashMap<Integer, List<Object>> ret = new HashMap<Integer, List<Object>>(4);
        if (!DB.isXDBEnable()) {
            return ret;
        }
        ORM orm = ORM.create();
        IDataEntityType dt = orm.getDataEntityType(entityNumber);
        String table = dt.getAlias();
        IDataEntityProperty property = (IDataEntityProperty)dt.getProperties().get((Object)shardingFieldName);
        if (property != null) {
            shardingFieldName = property.getAlias();
        }
        if ((shardConfig = XDBConfig.getShardingConfigProvider().getConfig(table)) == null) {
            return ret;
        }
        if (shardConfig instanceof MainTableConfig) {
            ValueMapper valueMapper;
            ValueMapper[] valueMappers;
            ShardingStrategy shardingStrategy = shardConfig.getShardingStrategy();
            String[] shardingFields = shardConfig.getShardingFields();
            int pos = 0;
            for (String shardingField : shardingFields) {
                if (shardingFieldName.equalsIgnoreCase(shardingField)) break;
                ++pos;
            }
            if (shardingStrategy instanceof MapStrategy && pos < (valueMappers = ((MapStrategy)shardingStrategy).getValueMappers()).length && (valueMapper = valueMappers[pos]) instanceof HashModMapper) {
                boolean hasExtra = ((HashModMapper)valueMapper).hasExtra();
                int mod = ((HashModMapper)valueMapper).getMod();
                Map extraMap = ((HashModMapper)valueMapper).getExtraMap();
                for (Object modFieldValue : modFieldValues) {
                    Integer i;
                    if (hasExtra && (i = (Integer)extraMap.get(String.valueOf(modFieldValue))) != null) {
                        List list = ret.computeIfAbsent(i, k -> new ArrayList());
                        list.add(modFieldValue);
                        continue;
                    }
                    List list = ret.computeIfAbsent(HashCodeUtil.getHashCodeSingle((Object)modFieldValue) % mod, k -> new ArrayList());
                    list.add(modFieldValue);
                }
            }
        }
        return ret;
    }

    @Override
    public String[] getExistShardingTables(String dbRouteKey, String tableName) throws SQLException {
        if (DB.isSharded((String)tableName)) {
            try {
                return (String[])DB.__setupExtContextForUsingXdbTableManager((DBRoute)DBRoute.of((String)dbRouteKey), (boolean)true, () -> XDBConfig.getTableManager().getShardingTable(tableName));
            }
            catch (Exception e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
        }
        return new String[0];
    }

    private Map<String, List<Condition>> filterValidFields(ShardingConfig config, IDataEntityType dt, List<Condition> conditions) {
        HashMap<String, List<Condition>> cmap = new HashMap<String, List<Condition>>();
        String[] shardingFields = config.getShardingFields();
        List<String> shardingFieldList = Arrays.asList(shardingFields);
        if (conditions != null) {
            for (Condition c : conditions) {
                String field;
                IMetadata meta = (IMetadata)dt.getProperties().get((Object)c.property);
                if (meta == null || !shardingFieldList.contains((field = meta.getAlias()).toLowerCase())) continue;
                ArrayList<Condition> list = (ArrayList<Condition>)cmap.get(field);
                if (list == null) {
                    list = new ArrayList<Condition>();
                    cmap.put(field, list);
                }
                list.add(c);
            }
        }
        return cmap;
    }

    public static List<ShardRuntimeConfigEntity> getRuntimeConfigEntities(List<String> tableList) {
        return tableList.stream().map(table -> XDBConfig.getShardingConfigProvider().getConfig(table)).filter(Objects::nonNull).map(ShardingMetadataServiceImpl::convert2RuntimeConfig).collect(Collectors.toList());
    }

    private static ShardRuntimeConfigEntity convert2RuntimeConfig(ShardingConfig config) {
        ShardRuntimeConfigEntity entity = new ShardRuntimeConfigEntity();
        entity.setTable(config.getTable());
        entity.setLevel(config.getLevel());
        entity.setExists(true);
        entity.setShardFields(String.join((CharSequence)",", config.getShardingFields()));
        entity.setEnabled(config.isEnabled());
        if (config instanceof ChildrenTableConfig) {
            ChildrenTableConfig childrenTableConfig = (ChildrenTableConfig)config;
            entity.setJoinField(childrenTableConfig.getJoinField());
            entity.setParentField(childrenTableConfig.getParentField());
            entity.setParentTable(childrenTableConfig.getParent().getTable());
        }
        return entity;
    }

    public static Map<String, Long> getShardingMapTables(String table) {
        ShardingIndexMap shardingIndexMap = ShardingIndexMap.get((String)table);
        if (Objects.isNull(shardingIndexMap)) {
            XDBManagerUtil.logInfo(ResManager.loadKDString((String)"%s \u5bf9\u5e94\u7684 shardingIndexMap \u662f null", (String)"bos-xdb-manager", (String)table, (Object[])new Object[0]));
            return new ConcurrentHashMap<String, Long>(0);
        }
        return shardingIndexMap.getGlobalIndexMap();
    }

    @Override
    public boolean isXDBEnableByEntity(String entityNumber) {
        if (!DB.isXDBEnable()) {
            return false;
        }
        MainTableConfig mainTableConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(entityNumber);
        return mainTableConfig != null && mainTableConfig.isEnabled();
    }

    @Override
    public void syncEntityXDBConfig(String entityNumber) {
        if (SyncEntityTableContext.get() == null) {
            ThreadPools.executeOnceIncludeRequestContext((String)"syncEntityXDBConfig", () -> {
                if (this.isXDBEnableByEntity(entityNumber)) {
                    try (SyncEntityTableContext syncEntityTableContext = SyncEntityTableContext.create();){
                        if (ShardDetailUpgradUtil.isUpgraded()) {
                            ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(entityNumber);
                            configEntity.toShardingConfigs();
                        }
                    }
                    catch (Exception e) {
                        logger.error(String.format("ShardingMetadataService syncEntityXDBConfig error, entityNumber:%s", entityNumber), (Object)e.getMessage());
                    }
                }
            });
        }
    }

    @Override
    public void syncPrivacyXDBConfig(String tableName, String privacyTableName) {
        if (DB.isSharded((String)tableName) && !DB.isSharded((String)privacyTableName)) {
            ShardingConfig root;
            String parentField;
            ShardingConfig config;
            ShardingConfig parent = config = XDBConfig.getShardingConfigProvider().getConfig(tableName);
            if (config instanceof MainTableConfig) {
                parentField = "fid";
                root = config;
            } else {
                ShardingConfig parentConfig = ((ChildrenTableConfig)config).getParent();
                if (parentConfig instanceof MainTableConfig) {
                    root = parentConfig;
                    if (((ChildrenTableConfig)config).isGroupTableConfig()) {
                        parentField = "fid";
                        parent = parentConfig;
                    } else {
                        parentField = "fentryid";
                    }
                } else {
                    ShardingConfig grandParentConfig = ((ChildrenTableConfig)parentConfig).getParent();
                    if (grandParentConfig instanceof MainTableConfig) {
                        root = grandParentConfig;
                        if (((ChildrenTableConfig)config).isGroupTableConfig()) {
                            parentField = "fentryid";
                            parent = parentConfig;
                        } else {
                            parentField = "fdetailid";
                        }
                    } else {
                        parentField = "fdetailid";
                        parent = parentConfig;
                        root = ((ChildrenTableConfig)grandParentConfig).getParent();
                    }
                }
            }
            ShardingConfig privacyConfig = ShardingConfig.childrenTable((String)(config.getName() + ".privacy"), (String)privacyTableName, (String)"FbizId", (String)parentField, (ShardingConfig)parent, (boolean)false);
            privacyConfig.getOptions().setDbRouteKey(root.getOptions().getDbRouteKey());
            ((ChildrenTableConfig)privacyConfig).setPrivacyTableConfig();
            XDBConfig.getShardingConfigProvider().addConfig(privacyConfig);
            if (ShardDetailUpgradUtil.isUpgraded()) {
                ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(config.getEntitynumber());
                ShardDetailUpgradUtil.initPrivacyShardingDeatil(configEntity, privacyConfig);
            }
        }
    }
}

