/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.IDService;
import kd.bos.xdb.entity.ShardArchiKanbanDetailEntity;
import kd.bos.xdb.entity.ShardArchiKanbanEntity;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.repository.ShardArchiKanbanRepository;

public class ShardArchiKanbanRepositoryImpl
implements ShardArchiKanbanRepository {
    public static final ShardArchiKanbanRepositoryImpl instance = new ShardArchiKanbanRepositoryImpl();

    @Override
    public ShardArchiKanbanEntity loadShardArchiKanban(String entityNumber) {
        String condition = " fentitynumber = '" + entityNumber + "' ";
        List<ShardArchiKanbanEntity> ret = this.loadShardArchiWithCondition(condition);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public boolean insertShardArchiKanban(String entityNumber, long configid, long archiconfigId) {
        String sql = "insert into t_cbs_shard_archikanban (fid,fconfigid,fcreatetime,fmodifytime,fentitynumber,flastexectime,farchiconfig) values (?,?,?,?,?,?,?)";
        Object[] params = new Object[]{IDService.get().genLongId(), configid, new Date(), new Date(), entityNumber, new Date(), archiconfigId};
        return DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
    }

    @Override
    public int clearShardArchiKanbanRouteDetail(long archiKanbanId) {
        String deleteRouteDeail = "delete from t_cbs_shard_archikanbanrd where fid = " + archiKanbanId;
        return DB.update((DBRoute)DBRoute.base, (String)deleteRouteDeail, null);
    }

    @Override
    public void insertShardArchiKanbanRouteDetail(List<ShardArchiKanbanDetailEntity> detailEntities, long fid) {
        if (detailEntities == null || detailEntities.isEmpty()) {
            return;
        }
        Collections.sort(detailEntities, Comparator.comparing(ShardArchiKanbanDetailEntity::getRoute));
        String sql = "insert into t_cbs_shard_archikanbanrd (fid, fentryid, fseq, fshardtable, froute, ftabletype) values (?,?,?,?,?,?)";
        int i = 1;
        for (ShardArchiKanbanDetailEntity detailEntity : detailEntities) {
            Object[] params = new Object[]{fid, IDService.get().genLongId(), i++, detailEntity.getShardtable(), detailEntity.getRoute(), detailEntity.getTabletype()};
            DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
        }
    }

    @Override
    public void updateDate(long archiKanbanId) {
        String sql = "update t_cbs_shard_archikanban set fmodifytime = ?, flastexectime = ? where fid = " + archiKanbanId;
        Object[] params = new Object[]{new Date(), new Date()};
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
    }

    @Override
    public void clearArchiKanban(String entityNumber) {
        ShardArchiKanbanEntity kanbanEntity = this.loadShardArchiKanban(entityNumber);
        if (kanbanEntity != null) {
            String deleteKanbanSql = "delete from t_cbs_shard_archikanban where fid = " + kanbanEntity.getId();
            String deleteDetail = "delete from t_cbs_shard_archikanbanrd where fid = " + kanbanEntity.getId();
            DB.execute((DBRoute)DBRoute.base, (String)deleteKanbanSql, null);
            DB.execute((DBRoute)DBRoute.base, (String)deleteDetail, null);
        }
    }

    private List<ShardArchiKanbanEntity> loadShardArchiWithCondition(String condition) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select ");
            sql.append(" fid,fconfigid,fcreatetime,fmodifytime,fentitynumber,flastexectime,farchiconfig ");
            sql.append(" from t_cbs_shard_archikanban ");
            if (condition != null) {
                sql.append(" where ").append(condition);
            }
            return (List)DB.query((DBRoute)DBRoute.base, (String)NoShardingHint.genNoShardingSQL((String)sql.toString()), rs -> {
                ArrayList<ShardArchiKanbanEntity> ret = new ArrayList<ShardArchiKanbanEntity>(100);
                while (rs.next()) {
                    ShardArchiKanbanEntity shardArchiKanbanEntity = new ShardArchiKanbanEntity();
                    shardArchiKanbanEntity.setId(rs.getLong(1));
                    shardArchiKanbanEntity.setConfigId(rs.getLong(2));
                    shardArchiKanbanEntity.setEntitynumber(rs.getString(5));
                    shardArchiKanbanEntity.setArchiConfig(rs.getLong(7));
                    ret.add(shardArchiKanbanEntity);
                }
                return ret;
            });
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }
}

