/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.sharding.ShardConfigLoader;
import kd.bos.db.sharding.SkipLoadShardingConfigContext;
import kd.bos.db.sharding.tablerw.DBTableRWNotifier;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;

public class ShardConfigLoaderImpl
implements ShardConfigLoader {
    private static final Log log = LogFactory.getLog(ShardConfigLoaderImpl.class);
    private static DistributeSessionlessCache cache;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<ShardingConfig> loadAll() {
        try (SkipLoadShardingConfigContext skipCtx = SkipLoadShardingConfigContext.create();){
            Set<ShardingConfig> set2;
            List<ShardConfigEntity> configEntityList = ShardConfigRepository.get().loadConfigList();
            Set<ShardingConfig> set = set2 = this.toShardingConfig(configEntityList);
            return set;
        }
        catch (Exception e) {
            String msg = "ShardConfigLoaderImpl Load all sharding config failed: " + e.getMessage();
            XDBManagerUtil.logError(msg, e);
            if (!ShardTaskConfig.isConfigloadErrorIgnore()) throw ExceptionUtil.wrap((Throwable)e);
            return new HashSet<ShardingConfig>();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<ShardingConfig> load(String entityName) {
        try (SkipLoadShardingConfigContext skipCtx = SkipLoadShardingConfigContext.create();){
            Set<ShardingConfig> set;
            ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(entityName);
            ArrayList<ShardConfigEntity> configEntityList = new ArrayList<ShardConfigEntity>();
            if (configEntity == null) {
                ShardConfigEntity mockShardConfig = ShardConfigEntity.mockShardConfigEntity(entityName);
                configEntityList.add(mockShardConfig);
                this.toShardingConfig(configEntityList);
                HashSet<ShardingConfig> hashSet = new HashSet<ShardingConfig>();
                return hashSet;
            }
            configEntityList.add(configEntity);
            Set<ShardingConfig> set2 = set = this.toShardingConfig(configEntityList);
            return set2;
        }
        catch (Exception e) {
            String msg = "Load " + entityName + " sharding config failed: " + e.getMessage();
            XDBManagerUtil.logError(msg, e);
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    private Set<ShardingConfig> toShardingConfig(List<ShardConfigEntity> configEntityList) {
        HashSet<ShardingConfig> set = new HashSet<ShardingConfig>();
        DBShardingRuntime dbRuntime = DBShardingRuntime.get();
        RequestContextInfo rc = RequestContextInfo.get();
        for (ShardConfigEntity config : configEntityList) {
            if (StringUtils.isEmpty((String)config.getStrategy()) || StringUtils.isEmpty((String)config.getShardingfields()) || config.getConfigstatus() == ShardConfigStatusEnum.DISABLE && !DBShardingRuntime.get().getConfigLoaded().get()) continue;
            if (Instance.isStandaloneWebNode()) {
                String cacheKey = DBTableRWNotifier.getObserveCachkey((String)rc.getTenantId(), (String)rc.getAccountId(), (String)Instance.getInstanceId(), (String)config.getEntitynumber());
                cache.put(cacheKey, (Object)(StringUtils.isBlank((String)config.getRwmark()) ? "1" : config.getRwmark()), (int)TimeUnit.DAYS.toSeconds(2L));
                XDBManagerUtil.logInfo("toShardingConfig,cacheKey: " + cacheKey + ", cacheValue: " + config.getRwmark());
                continue;
            }
            List<ShardingConfig> list = config.toShardingConfigs();
            if (list.isEmpty()) continue;
            set.addAll(list);
            boolean rw = config.getConfigstatus() == ShardConfigStatusEnum.ENABLE || config.getConfigstatus() == ShardConfigStatusEnum.DISABLE;
            String cacheKey = DBTableRWNotifier.getObserveCachkey((String)rc.getTenantId(), (String)rc.getAccountId(), (String)Instance.getInstanceId(), (String)list.get(0).getTable());
            cache.put(cacheKey, (Object)(StringUtils.isBlank((String)config.getRwmark()) ? "1" : config.getRwmark()), (int)TimeUnit.DAYS.toSeconds(2L));
            XDBManagerUtil.logInfo("toShardingConfig,cacheKey: " + cacheKey + ", cacheValue: " + config.getRwmark());
            for (ShardingConfig sc : list) {
                dbRuntime.setTableRWAtCurrentNode(rw, rw, sc.getTable());
            }
        }
        return set;
    }

    public String getEntityMainTable(String entityName) {
        return ORM.create().getDataEntityType(entityName).getAlias();
    }

    public void runWithDBAccessible(Runnable r, RequestContextInfo rci) {
        try (AutoCloseable ac = rci.setupThreadRequestContext();){
            RequestContext rc = (RequestContext)RequestContextInfo.getRequestContext();
            OperationContext oc = new OperationContext();
            oc.setAppId("xdb");
            Runnable wrapRunnable = ThreadLifeCycleManager.wrapRunnable((Runnable)new RequestContextRunnable(r, rc, oc));
            ThreadPools.executeOnce((String)"runWithDBAccessible", (Runnable)wrapRunnable);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    static {
        DistributeCacheHAPolicy distributeCacheHAPolicy = new DistributeCacheHAPolicy();
        distributeCacheHAPolicy.setTenantable(false);
        distributeCacheHAPolicy.setDbBackup(true);
        cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", distributeCacheHAPolicy);
    }
}

