/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.constant.ShardingFormConst;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.repository.ShardConfigRepository;

public class ShardConfigRepositoryImpl
implements ShardConfigRepository,
ShardingFormConst {
    private static final Log log = LogFactory.getLog(ShardConfigRepositoryImpl.class);
    public static final ShardConfigRepositoryImpl instance = new ShardConfigRepositoryImpl();
    private static boolean ignoreConfigError = false;

    @Override
    public List<ShardConfigEntity> loadConfigList() {
        return this.loadConfigList(null);
    }

    public List<ShardConfigEntity> loadConfigList(String condition) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select ");
            sql.append(" fid,fentitynumber,fshardingfields,fstrategyparams,fstrategy,fconfigstatus,fversion,frwmark ");
            sql.append(" from t_cbs_shard_config ");
            if (condition != null) {
                sql.append(" where ").append(condition);
            }
            return (List)DB.query((DBRoute)DBRoute.base, (String)NoShardingHint.genNoShardingSQL((String)sql.toString()), rs -> {
                ArrayList<ShardConfigEntity> ret = new ArrayList<ShardConfigEntity>(100);
                while (rs.next()) {
                    ShardConfigEntity configEntity = new ShardConfigEntity();
                    configEntity.setId(rs.getLong(1));
                    configEntity.setEntitynumber(rs.getString(2));
                    String shardingFields = rs.getString(3);
                    configEntity.setShardingProperties(shardingFields.split(","));
                    configEntity.setShardingfields(shardingFields);
                    configEntity.setStrategyparams(rs.getString(4));
                    configEntity.setStrategy(rs.getString(5));
                    configEntity.setConfigstatus(ShardConfigStatusEnum.from(rs.getString(6)));
                    configEntity.setVersion(rs.getLong(7));
                    configEntity.setRwmark(rs.getString(8));
                    ret.add(configEntity);
                }
                return ret;
            });
        }
        catch (Exception e) {
            RequestContext rc = RequestContext.get();
            if (ignoreConfigError) {
                log.warn(BosRes.get((String)"bos-xdb-manager", (String)"ShardingServiceImpl_0", (String)"A/C set {0}#{1} is incorrectly configured to load shards, please check whether the metadata{2} and table structure are correct.", (Object[])new Object[]{rc.getTenantId(), rc.getAccountId(), "bos_cbs_shard_config"}), (Throwable)e);
                return Collections.emptyList();
            }
            log.error(BosRes.get((String)"bos-xdb-manager", (String)"ShardingServiceImpl_0", (String)"A/C set {0}#{1} is incorrectly configured to load shards, please check whether the metadata{2} and table structure are correct.", (Object[])new Object[]{rc.getTenantId(), rc.getAccountId(), "bos_cbs_shard_config"}), (Throwable)e);
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    @Override
    public ShardConfigEntity loadConfig(String entityNumber) {
        String condition = " fentitynumber = '" + entityNumber + "' ";
        List<ShardConfigEntity> ret = this.loadConfigList(condition);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public int setConfigstatus(long configId, ShardConfigStatusEnum curConfigStatus, ShardConfigStatusEnum nextConfigStatus) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_config ");
        sql.append(" set fconfigstatus = ? ");
        sql.append(" where fid = ? and fconfigstatus = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{nextConfigStatus.getKey(), configId, curConfigStatus.getKey()});
    }

    @Override
    public int setConfigRWmark(long configId, String rwmark, ShardConfigStatusEnum curConfigStatus) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_config ");
        sql.append(" set frwmark = ?, fversion = fversion + 1 ");
        sql.append(" where fid = ? and fconfigstatus = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{rwmark, configId, curConfigStatus.getKey()});
    }

    @Override
    public int setConfigParameter(long configId, String shardingParameter) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_config set fstrategyparams=? where fid = ?");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{shardingParameter, configId});
    }

    static {
        ConfigurationUtil.observeBoolean((String)"xdb.manager.ignore_config_error", (boolean)ignoreConfigError, v -> {
            ignoreConfigError = v;
        });
    }
}

