/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.entity.ShardDetailEntity;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.repository.ShardDetailRepository;
import kd.bos.xdb.service.ActionUtil;

public class ShardDetailRepositoryImpl
implements ShardDetailRepository {
    private static final Log log = LogFactory.getLog(ShardDetailRepositoryImpl.class);
    public static final ShardDetailRepositoryImpl instance = new ShardDetailRepositoryImpl();

    @Override
    public List<ShardDetailEntity> loadDetailList() {
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        return this.loadDetailList(null, paramList);
    }

    public List<ShardDetailEntity> loadDetailList(String condition, List<Object> paramList) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select ");
        sql.append(" fid,fname,fentitynumber,ftablename,fshardfield,fshardproperties,findexfield,findexproperties,fparenttable,fjoinfield,fparentfield,fatrribute,fdbroutekey,flevel,fcreatetime,fupdatetime ");
        sql.append(" from t_cbs_shard_detail ");
        if (condition != null) {
            sql.append(" where ").append(condition);
        }
        sql.append(" order by fentitynumber,flevel ");
        return (List)DB.query((DBRoute)DBRoute.base, (String)NoShardingHint.genNoShardingSQL((String)sql.toString()), (Object[])paramList.toArray(), rs -> {
            ArrayList<ShardDetailEntity> ret = new ArrayList<ShardDetailEntity>(100);
            while (rs.next()) {
                ShardDetailEntity detailEntity = new ShardDetailEntity();
                detailEntity.setId(rs.getLong("fid"));
                detailEntity.setName(rs.getString("fname"));
                detailEntity.setEntitynumber(rs.getString("fentitynumber"));
                detailEntity.setTablename(rs.getString("ftablename"));
                detailEntity.setShardfield(rs.getString("fshardfield"));
                detailEntity.setShardproperties(rs.getString("fshardproperties"));
                detailEntity.setIndexfield(rs.getString("findexfield"));
                detailEntity.setIndexproperties(rs.getString("findexproperties"));
                detailEntity.setParenttable(rs.getString("fparenttable"));
                detailEntity.setJoinfield(rs.getString("fjoinfield"));
                detailEntity.setParentfield(rs.getString("fparentfield"));
                detailEntity.setAtrribute(rs.getString("fatrribute"));
                detailEntity.setDbRouteKey(rs.getString("fdbroutekey"));
                detailEntity.setLevel(rs.getInt("flevel"));
                detailEntity.setCreatetime(rs.getTimestamp("fcreatetime"));
                detailEntity.setUpdatetime(rs.getTimestamp("fupdatetime"));
                ret.add(detailEntity);
            }
            return ret;
        });
    }

    @Override
    public List<ShardDetailEntity> loadDetailList(String entityNumber) {
        String condition = " fentitynumber = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>(1);
        paramList.add(entityNumber);
        List<ShardDetailEntity> ret = this.loadDetailList(condition, paramList);
        return ret;
    }

    @Override
    public long countDetail(String entityNumber) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_shard_detail ");
        sql.append(" where fentitynumber = ? ");
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{entityNumber}, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    @Override
    public long countDetailByTable(String ftablename) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(*) from t_cbs_shard_detail ");
        sql.append(" where ftablename = ? ");
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{ftablename}, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
    }

    @Override
    public void deleteDetail(String entityNumber) {
        StringBuilder sql = new StringBuilder();
        sql.append(" delete from t_cbs_shard_detail ");
        sql.append(" where fentitynumber = ? ");
        DB.execute((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{entityNumber});
    }

    @Override
    public void insertDetail(List<ShardDetailEntity> detailEntityList) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into t_cbs_shard_detail (");
        sql.append(" fid,fname,fentitynumber,ftablename,fshardfield,fshardproperties,findexfield,findexproperties,fparenttable,fjoinfield,fparentfield,");
        sql.append(" fatrribute,fdbroutekey,flevel,fcreatetime,fupdatetime ");
        sql.append(" )values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(detailEntityList.size());
        for (int i = 0; i < detailEntityList.size(); ++i) {
            ArrayList<Object> obj = new ArrayList<Object>(12);
            obj.add(ID.genLongId());
            ShardDetailEntity detailEntity = detailEntityList.get(i);
            obj.add(detailEntity.getName());
            obj.add(detailEntity.getEntitynumber());
            obj.add(detailEntity.getTablename());
            obj.add(detailEntity.getShardfield());
            obj.add(detailEntity.getShardproperties());
            obj.add(detailEntity.getIndexfield());
            obj.add(detailEntity.getIndexproperties());
            obj.add(detailEntity.getParenttable());
            obj.add(detailEntity.getJoinfield());
            obj.add(detailEntity.getParentfield());
            obj.add(detailEntity.getAtrribute());
            obj.add(detailEntity.getDbRouteKey());
            obj.add(detailEntity.getLevel());
            obj.add(new Date());
            obj.add(new Date());
            paramList.add(obj.toArray());
        }
        DB.executeBatch((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(sql.toString(), true, true), paramList);
    }
}

