/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.repository.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.entity.ShardFastIndexConfigEntity;
import kd.bos.xdb.enums.ShardFastIndexStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.repository.ShardFastIndexConfigRepository;

public class ShardFastIndexConfigRepositoryImpl
implements ShardFastIndexConfigRepository {
    public static final ShardFastIndexConfigRepositoryImpl instance = new ShardFastIndexConfigRepositoryImpl();

    @Override
    public List<ShardFastIndexConfigEntity> loadFastIndexConfigList() {
        return this.loadFastIndexConfigWithCondition(null);
    }

    private List<ShardFastIndexConfigEntity> loadFastIndexConfigWithCondition(String condition) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select ");
            sql.append(" fid,fentitynumber,fconfigid,ffastindex,flastfastindex,foperationlog,fstatus,frwmark ");
            sql.append(" from t_cbs_shard_fast_index ");
            if (condition != null) {
                sql.append(" where ").append(condition);
            }
            return (List)DB.query((DBRoute)DBRoute.base, (String)NoShardingHint.genNoShardingSQL((String)sql.toString()), rs -> {
                ArrayList<ShardFastIndexConfigEntity> ret = new ArrayList<ShardFastIndexConfigEntity>(100);
                while (rs.next()) {
                    ShardFastIndexConfigEntity indexConfigEntity = new ShardFastIndexConfigEntity();
                    indexConfigEntity.setId(rs.getLong(1));
                    indexConfigEntity.setEntityNumber(rs.getString(2));
                    indexConfigEntity.setConfigId(rs.getLong(3));
                    indexConfigEntity.setFastIndex(rs.getString(4));
                    indexConfigEntity.setLastFastIndex(rs.getString(5));
                    indexConfigEntity.setOperationLog(rs.getString(6));
                    indexConfigEntity.setShardFastIndexStatus(ShardFastIndexStatusEnum.from(rs.getString(7)));
                    indexConfigEntity.setRwMark(rs.getString(8));
                    ret.add(indexConfigEntity);
                }
                return ret;
            });
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    @Override
    public ShardFastIndexConfigEntity loadFastIndexConfig(String entityNumber) {
        String condition = " fentitynumber = '" + entityNumber + "' ";
        List<ShardFastIndexConfigEntity> ret = this.loadFastIndexConfigWithCondition(condition);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public ShardFastIndexConfigEntity loadFastIndexConfig(long id) {
        String condition = " fid = '" + id + "' ";
        List<ShardFastIndexConfigEntity> ret = this.loadFastIndexConfigWithCondition(condition);
        return ret.isEmpty() ? null : ret.get(0);
    }

    @Override
    public int setFastIndexConfigStatus(long fastIndexConfigId, ShardFastIndexStatusEnum curStatus, ShardFastIndexStatusEnum nextStatus) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_fast_index ");
        sql.append(" set fstatus = ? ");
        sql.append(" where fid = ? and fstatus = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{nextStatus.getKey(), fastIndexConfigId, curStatus.getKey()});
    }

    @Override
    public int setFastIndexConfigRWMark(long configId, String rwMark, ShardFastIndexStatusEnum configurable) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_fast_index ");
        sql.append(" set frwmark = ? ");
        sql.append(" where fid = ? and fstatus = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{rwMark, configId, configurable.getKey()});
    }

    @Override
    public int resetFastIndex(long id, String lastFastIndex, String fastIndex) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update t_cbs_shard_fast_index ");
        sql.append(" set ffastindex = ?, flastfastindex = ? ");
        sql.append(" where fid = ? ");
        return DB.update((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])new Object[]{lastFastIndex, fastIndex, id});
    }
}

