/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.service.action.parallel;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.xdb.service.ShardTaskConfig;

public class ShardThreadPool
implements AutoCloseable {
    private final ThreadPoolExecutor _executor;
    private final ThreadGroup _group = new ThreadGroup("XDB-ParallelThread");
    private int _minThreads;
    private String _name;
    private String _table;
    private AtomicInteger seq = new AtomicInteger();

    public ShardThreadPool() {
        this(Math.max(16, ShardTaskConfig.getMovingParallelThreads()), Math.min(8, ShardTaskConfig.getMovingParallelThreads()));
    }

    public ShardThreadPool(int maxThreads, int minThreads) {
        this(maxThreads, minThreads, new LinkedBlockingQueue<Runnable>());
    }

    public ShardThreadPool(int maxThreads, int minThreads, BlockingQueue<Runnable> queue) {
        this(new ThreadPoolExecutor(maxThreads, maxThreads, 60L, TimeUnit.SECONDS, queue), minThreads);
    }

    private final Thread newThread(Runnable job) {
        Thread thread = new Thread(this._group, job);
        thread.setDaemon(true);
        thread.setName(this._name + "-" + this._table + "-" + this.seq.incrementAndGet());
        return thread;
    }

    private ShardThreadPool(ThreadPoolExecutor executor, int minThreads) {
        int maxThreads = executor.getMaximumPoolSize();
        if (maxThreads < minThreads) {
            executor.shutdownNow();
            throw new IllegalArgumentException("max threads (" + maxThreads + ") cannot be less than min threads (" + minThreads + ")");
        }
        this._executor = executor;
        this._executor.setThreadFactory(this::newThread);
        this._minThreads = minThreads;
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this._executor.submit(task);
    }

    public Future<?> submit(Runnable task) {
        return this._executor.submit(task);
    }

    public void shutdown() {
        this._executor.shutdown();
    }

    public boolean isTerminated() {
        return this._executor.isTerminated();
    }

    public int getMaximumPoolSize() {
        return this._executor.getMaximumPoolSize();
    }

    public void start() {
        if (this._executor.isShutdown()) {
            throw new IllegalStateException("This thread pool is not restartable");
        }
        for (int i = 0; i < this._minThreads; ++i) {
            this._executor.prestartCoreThread();
        }
    }

    public void stop() {
        this._executor.shutdownNow();
    }

    public void setTable(String table) {
        this._table = table;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void close() {
        this.stop();
    }
}

