/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.db.sharding.configchanged.DBShardingConfigNotifier;
import kd.bos.db.sharding.tablerw.DBAnyRWContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.enums.ShardTaskTypeEnum;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.repository.ShardSplitTaskRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.service.ShardTaskService;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.tableversion.TableVersionUpdator;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.service.Consistency.ShardingChangeTbLock;
import kd.bos.xdb.task.service.Consistency.ShardingChangeTbUnlock;
import kd.bos.xdb.task.service.ShardingTaskServiceAbst;
import kd.bos.xdb.task.service.analysis.ShardingAnalysisService;
import kd.bos.xdb.task.service.archivemove.ShardingArchiveMoveSrvice;
import kd.bos.xdb.task.service.disablemove.ShardingDisableService;
import kd.bos.xdb.task.service.disablemove.ShardingDisableServiceAdaptive;
import kd.bos.xdb.task.service.enablemove.ShardingDataMoveService;
import kd.bos.xdb.task.service.indexmove.ShardingIndexMoveService;

public class TaskContainer {
    private final ShardTaskService dispatcher;
    private final ShardTaskEntity taskEntity;
    private final DLock lock;
    private final RequestContext rc;

    public TaskContainer(ShardTaskService dispatcher, ShardTaskEntity taskEntity, DLock lock, RequestContext rc) {
        this.dispatcher = dispatcher;
        this.taskEntity = taskEntity;
        this.lock = lock;
        this.rc = rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer begin,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        ORM.clearEntityTypeCache();
        DBShardingRuntime dbShardingRuntime = DBShardingRuntime.get();
        try {
            block44: {
                try (XDBExternal xdbe = XDBExternal.notSupportedAlways((String)"xdb.ShardTaskMovingHandler");
                     DBAnyRWContext ctx = dbShardingRuntime.setupThreadDBAnyRWContext();
                     Cache cc = CacheContext.get().createExecutorCache();){
                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer setupThreadDBAnyRWContext,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                    String entitynumber = this.taskEntity.getEntitynumber();
                    ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(entitynumber);
                    List<ShardingConfig> shardingConfigs = configEntity.toShardingConfigs();
                    IDataEntityType rootDT = ORMConfiguration.innerGetDataEntityType((String)entitynumber, null);
                    DBRoute route = DBRoute.of((String)rootDT.getDBRouteKey());
                    ActionUtil.startConfig();
                    try {
                        DB.__setupExtContextForUsingXdbTableManager((DBRoute)route, (boolean)false, () -> {
                            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer UsingXdbTableManager,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                            TableManager tm = XDBConfig.getTableManager();
                            TableVersionUpdator tableVersionUpdator = tm.getTableVersionUpdator();
                            try (TXHandle h = TX.notSupported();){
                                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer tableVersionUpdator.maskIncVersion,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                                for (ShardingConfig sc : shardingConfigs) {
                                    tableVersionUpdator.maskIncVersion(sc.getTable());
                                    tm.clearCahce(sc.getTable());
                                }
                                Configuration configuration = new Configuration(this.taskEntity);
                                ShardTaskTypeEnum taskTypeEnum = this.taskEntity.getTasktype();
                                ShardingChangeTbLock tableLock = new ShardingChangeTbLock(this.taskEntity, configuration);
                                ShardingChangeTbUnlock tableUnlock = new ShardingChangeTbUnlock(this.taskEntity, configuration);
                                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer doSharding begin,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                                ShardTaskRuntime.get().setTaskInterruptedCurrentNode(false, configuration.getMainTable());
                                if (ShardTaskTypeEnum.SHARDENABLE == taskTypeEnum) {
                                    ShardingAnalysisService enableAnalysis = new ShardingAnalysisService(this.taskEntity, configuration);
                                    ShardingDataMoveService enableDataMove = new ShardingDataMoveService(this.taskEntity, configuration);
                                    tableLock.setNext(enableAnalysis);
                                    enableAnalysis.setNext(enableDataMove);
                                    enableDataMove.setNext(tableUnlock);
                                } else if (ShardTaskTypeEnum.SHARDDISABLE == taskTypeEnum) {
                                    MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(this.taskEntity.getEntitynumber());
                                    Set archiveRoutes = mainConfig.getOptions().getIndexRoute().getAllArchiveRoutes();
                                    boolean oldMethodForce = ShardTaskConfig.isShardDisableOldMethodForce();
                                    ShardingTaskServiceAbst disableDataMove = new ShardingDisableServiceAdaptive(this.taskEntity, configuration);
                                    if (archiveRoutes.isEmpty() && oldMethodForce) {
                                        disableDataMove = new ShardingDisableService(this.taskEntity, configuration);
                                    }
                                    tableLock.setNext(disableDataMove);
                                    disableDataMove.setNext(tableUnlock);
                                } else if (ShardTaskTypeEnum.MOVEINDEX == taskTypeEnum) {
                                    ShardingIndexMoveService indexMove = new ShardingIndexMoveService(this.taskEntity, configuration);
                                    tableLock.setNext(indexMove);
                                    indexMove.setNext(tableUnlock);
                                } else if (ShardTaskTypeEnum.SHARDARCHIVE == taskTypeEnum) {
                                    ShardingArchiveMoveSrvice archiveMove = new ShardingArchiveMoveSrvice(this.taskEntity, configuration);
                                    tableLock.setNext(archiveMove);
                                    archiveMove.setNext(tableUnlock);
                                }
                                tableLock.sharding();
                                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer doSharding end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                            }
                            catch (Throwable e) {
                                try {
                                    StringWriter sw = new StringWriter();
                                    e.printStackTrace(new PrintWriter(sw));
                                    String error = MessageFormat.format("ShardTaskMovingHandler TaskContainer handler error, taskId:{0}, entitynumber:{1}, errorinfo:{2}", this.taskEntity.getId(), this.rc.getAccountId() + "#" + this.taskEntity.getEntitynumber(), sw.toString());
                                    XDBManagerUtil.logError(error, e);
                                    ShardTaskEntity curTaskEntity = ShardTaskRepository.get().loadTask(this.taskEntity.getId());
                                    if (ShardTaskStatusEnum.UNEXECUTED == curTaskEntity.getTaskstatus()) {
                                        ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.UNEXECUTED, ShardTaskStatusEnum.FAILED);
                                    } else if (ShardTaskStatusEnum.PAUSE == curTaskEntity.getTaskstatus()) {
                                        ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.FAILED);
                                    } else {
                                        ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.EXECUTING, ShardTaskStatusEnum.FAILED);
                                    }
                                    ShardSplitTaskRepository.get().setSplitTaskFailedByTaskId(this.taskEntity.getId());
                                    ShardProgressRepository.get().setProgressFailedByTaskId(this.taskEntity.getId());
                                    ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), entitynumber, error, "MOVINGHANDLER");
                                }
                                catch (Throwable throwable) {
                                    for (ShardingConfig sc : shardingConfigs) {
                                        tableVersionUpdator.unmaskIncVersion(sc.getTable());
                                        tableVersionUpdator.incVersion(sc.getTable());
                                    }
                                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer tableVersionUpdator.unmaskIncVersion,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                                    throw throwable;
                                }
                                for (ShardingConfig sc : shardingConfigs) {
                                    tableVersionUpdator.unmaskIncVersion(sc.getTable());
                                    tableVersionUpdator.incVersion(sc.getTable());
                                }
                                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer tableVersionUpdator.unmaskIncVersion,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                            }
                            for (ShardingConfig sc : shardingConfigs) {
                                tableVersionUpdator.unmaskIncVersion(sc.getTable());
                                tableVersionUpdator.incVersion(sc.getTable());
                            }
                            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer tableVersionUpdator.unmaskIncVersion,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                            return null;
                        });
                    }
                    catch (Throwable e) {
                        try {
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            String error = MessageFormat.format("ShardTaskMovingHandler TaskContainer UsingXdbTableManager error, taskId:{0}, entitynumber:{1}, errorinfo:{2}", this.taskEntity.getId(), this.rc.getAccountId() + "#" + this.taskEntity.getEntitynumber(), sw.toString());
                            XDBManagerUtil.logError(error, e);
                            ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, "MOVINGHANDLER");
                        }
                        catch (Throwable throwable) {
                            ActionUtil.endConfig();
                            DBShardingConfigNotifier.fireReloadShardingConfig((String)entitynumber);
                            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer fireReloadShardingConfig,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                            throw throwable;
                        }
                        ActionUtil.endConfig();
                        DBShardingConfigNotifier.fireReloadShardingConfig((String)entitynumber);
                        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer fireReloadShardingConfig,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                        break block44;
                    }
                    ActionUtil.endConfig();
                    DBShardingConfigNotifier.fireReloadShardingConfig((String)entitynumber);
                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer fireReloadShardingConfig,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                }
            }
            this.dispatcher.onHandOver(this.taskEntity, this.lock, this.rc, true);
        }
        catch (Throwable e) {
            try {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String error = MessageFormat.format("ShardTaskMovingHandler TaskContainer setupThreadDBAnyRWContext error, taskId:{0}, entitynumber:{1}, errorinfo:{2}", this.taskEntity.getId(), this.rc.getAccountId() + "#" + this.taskEntity.getEntitynumber(), sw.toString());
                XDBManagerUtil.logError(error, e);
                ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, "MOVINGHANDLER");
                this.dispatcher.onHandOver(this.taskEntity, this.lock, this.rc, true);
            }
            catch (Throwable throwable) {
                this.dispatcher.onHandOver(this.taskEntity, this.lock, this.rc, true);
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer onHandOver,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                throw throwable;
            }
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer onHandOver,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        }
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer onHandOver,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainer end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
    }
}

