/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.task.TaskContainer;

public class TaskContainerRunner
implements Runnable,
XDBLogable {
    private final TaskContainer taskContainer;
    private final ShardTaskEntity taskEntity;

    public TaskContainerRunner(TaskContainer taskContainer, ShardTaskEntity taskEntity) {
        this.taskContainer = taskContainer;
        this.taskEntity = taskEntity;
    }

    @Override
    public void run() {
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainerRunner begin,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
        try {
            Thread.currentThread().setName("XDBMANAGER-TaskContainerRunner-" + this.taskEntity.getEntitynumber());
            this.taskContainer.start();
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String error = MessageFormat.format("ShardTaskMovingHandler TaskContainerRunner error, taskId:{0}, entitynumber:{1}, errorinfo:{2}", this.taskEntity.getId(), this.taskEntity.getEntitynumber(), sw.toString());
            XDBManagerUtil.logError(error, e);
            ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, "MOVINGHANDLER");
        }
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler TaskContainerRunner end,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
    }
}

