/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.config;

import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DBRoute;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardArchiEntity;
import kd.bos.xdb.entity.ShardArchiRouteEntity;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.entity.ShardFastIndexConfigEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskTypeEnum;
import kd.bos.xdb.repository.ShardArchiRepository;
import kd.bos.xdb.repository.ShardArchiRouteRepository;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.repository.ShardFastIndexConfigRepository;
import kd.bos.xdb.sharding.config.FieldType;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.ShardingConfig;

public class Configuration {
    private ShardTaskEntity taskEntity;
    private String entitynumber;
    private ShardConfigEntity configEntity;
    private List<ShardingConfig> shardingConfigs;
    private Multimap<ShardingConfig, ShardingConfig> multimap;
    private ShardingConfig mainShardingConfig;
    private String mainTable;
    private IDataEntityType rootDT;
    private DBRoute route;
    private boolean isMovingFastIndex;
    private String fastIndex;
    private String lastFastIndex;
    private ShardArchiEntity archiEntity;
    private List<ShardArchiRouteEntity> shardArchiRouteEntities;
    private Set<IndexDefine> fastIndexDefineSet;

    public Configuration(ShardTaskEntity taskEntity) {
        this.entitynumber = taskEntity.getEntitynumber();
        this.taskEntity = taskEntity;
        this.configEntity = this.getConfigEntity();
        this.shardingConfigs = this.configEntity.toShardingConfigs();
        this.multimap = XDBManagerUtil.getGroupConfigs(this.shardingConfigs);
        this.mainShardingConfig = this.shardingConfigs.get(0);
        this.mainTable = this.mainShardingConfig.getTable();
        this.rootDT = ORMConfiguration.innerGetDataEntityType((String)this.entitynumber, null);
        this.route = DBRoute.of((String)this.rootDT.getDBRouteKey());
        HashSet<ShardingConfig> configs = new HashSet<ShardingConfig>();
        if (this.shardingConfigs != null) {
            configs.addAll(this.shardingConfigs);
            XDBConfig.getShardingConfigProvider().replaceConfigs(this.mainTable, configs.toArray(new ShardingConfig[configs.size()]));
        }
        if (ShardTaskTypeEnum.MOVEINDEX == taskEntity.getTasktype()) {
            this.isMovingFastIndex = true;
            this.fastIndex = taskEntity.getFastIndex();
            this.lastFastIndex = taskEntity.getLastFastIndex();
            this.fastIndexDefineSet = this.createIndexDefine(this.fastIndex.split(","));
        }
        if (ShardTaskTypeEnum.SHARDARCHIVE == taskEntity.getTasktype()) {
            this.archiEntity = this.getArchiEntity();
            this.shardArchiRouteEntities = ShardArchiRouteRepository.get().loadShardArchiRouteListByVersion(this.entitynumber, this.archiEntity.getVersion());
            Collections.sort(this.shardArchiRouteEntities);
        }
    }

    public boolean isMovingFastIndex() {
        return this.isMovingFastIndex;
    }

    public String getFastIndex() {
        return this.fastIndex;
    }

    public String getLastFastIndex() {
        return this.lastFastIndex;
    }

    public ShardFastIndexConfigEntity getShardFastIndexConfigEntity() {
        return ShardFastIndexConfigRepository.get().loadFastIndexConfig(this.entitynumber);
    }

    private Set<IndexDefine> createIndexDefine(String[] indexAttributes) {
        HashSet<IndexDefine> ret = new HashSet<IndexDefine>(indexAttributes.length);
        for (String indexAttribute : indexAttributes) {
            IDataEntityProperty dp = (IDataEntityProperty)this.rootDT.getProperties().get((Object)indexAttribute);
            if (dp == null) {
                return null;
            }
            Class propertyType = dp instanceof IComplexProperty ? ((IComplexProperty)dp).getComplexType().getPrimaryKey().getPropertyType() : dp.getPropertyType();
            FieldType fieldType = this.findFieldType(propertyType);
            String table = this.rootDT.getAlias();
            String group = dp.getTableGroup();
            if (group != null && group.length() > 0) {
                table = table + '_' + group;
            }
            IndexDefine define = new IndexDefine(table, dp.getAlias(), fieldType);
            ret.add(define);
        }
        return ret;
    }

    private FieldType findFieldType(Class<?> propertyType) {
        if (propertyType == Integer.class) {
            return FieldType.INTEGER;
        }
        if (propertyType == String.class) {
            return FieldType.STRING;
        }
        if (propertyType == Date.class) {
            return FieldType.DATE;
        }
        return FieldType.LONG;
    }

    public ShardConfigEntity getConfigEntity() {
        return ShardConfigRepository.get().loadConfig(this.entitynumber);
    }

    public ShardArchiEntity getArchiEntity() {
        return ShardArchiRepository.get().loadShardArchi(this.taskEntity.getConfigid());
    }

    public ShardTaskEntity getTaskEntity() {
        return this.taskEntity;
    }

    public String getEntitynumber() {
        return this.entitynumber;
    }

    public List<ShardingConfig> getShardingConfigs() {
        return this.shardingConfigs;
    }

    public ShardingConfig getMainShardingConfig() {
        return this.mainShardingConfig;
    }

    public String getMainTable() {
        return this.mainTable;
    }

    public IDataEntityType getRootDT() {
        return this.rootDT;
    }

    public DBRoute getRoute() {
        return this.route;
    }

    public Multimap<ShardingConfig, ShardingConfig> getMultimap() {
        return this.multimap;
    }

    public Set<IndexDefine> getFastIndexDefineSet() {
        return this.fastIndexDefineSet;
    }

    public List<ShardArchiRouteEntity> getShardArchiRouteEntities() {
        return this.shardArchiRouteEntities;
    }
}

