/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.progress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDExceptionKit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.task.progress.IProgress;
import kd.bos.xdb.util.DateUtil;

public class MainProgress
implements IProgress,
Serializable {
    private static final long serialVersionUID = -5029384120877610858L;
    private static final Log log = LogFactory.getLog(MainProgress.class);
    private long taskId;
    private String entitynumber;
    private int sourceTableCount = 0;
    private AtomicLong totalRecord = new AtomicLong(0L);
    private AtomicLong movedRecord = new AtomicLong(0L);
    private int runRound = 0;
    private long tsUsed = 0L;
    private long tsLastFrom = 0L;
    private boolean continueSharding = false;
    private boolean needDel = false;
    private boolean curStepExecuted = false;
    private Object toPk;
    private long movingShardingIndex = -1L;
    private transient long tsLastStore = 0L;
    private String progressType;
    private String execSql;
    private boolean isRenamePKTempTable = false;
    private boolean terminable = false;
    private Map<String, Object> progressDescMap = new HashMap<String, Object>();
    private transient Semaphore deletePKSemaphore = new Semaphore(1);

    public static MainProgress of(long taskId, String entitynumber, String s) {
        MainProgress sp;
        if (s == null || s.trim().length() == 0) {
            sp = new MainProgress();
        } else {
            try {
                MainProgress sp2 = MainProgress.unserialize(s);
                sp2.tsLastFrom = System.currentTimeMillis();
                sp2.continueSharding = true;
                sp2.needDel = true;
                sp2.setExecSql(null);
                sp2.deletePKSemaphore = new Semaphore(1);
                return sp2;
            }
            catch (Exception e) {
                sp = new MainProgress();
            }
        }
        sp.taskId = taskId;
        sp.entitynumber = entitynumber;
        return sp;
    }

    public MainProgress() {
        this.tsLastFrom = System.currentTimeMillis();
    }

    public Semaphore getDeletePKSemaphore() {
        return this.deletePKSemaphore;
    }

    @Override
    public Object getToPk() {
        return this.toPk;
    }

    @Override
    public void setToPk(Object toPk) {
        this.toPk = toPk;
    }

    @Override
    public void setMovingShardingIndex(long movingShardingIndex) {
        this.movingShardingIndex = movingShardingIndex;
    }

    public long getMovingShardingIndex() {
        return this.movingShardingIndex;
    }

    @Override
    public void setProgressDesc(String key, Object value) {
        if (value == null) {
            this.progressDescMap.remove(key);
        } else {
            this.progressDescMap.put(key, value);
        }
    }

    @Override
    public void setProgressDesc_1(Object value) {
        this.setProgressDesc("p1", value);
        this.setProgressDesc_2(null);
        this.setProgressDesc_3(null);
    }

    @Override
    public void setProgressDesc_2(Object value) {
        this.setProgressDesc("p2", value);
        this.setProgressDesc_3(null);
    }

    @Override
    public void setProgressDesc_3(Object value) {
        this.setProgressDesc("p3", value);
    }

    public void setTotalRecord(long totalRecord) {
        this.totalRecord = new AtomicLong(totalRecord);
    }

    public synchronized void incTotalRecord(long incTotalRecord) {
        this.totalRecord.getAndAdd(incTotalRecord);
    }

    public AtomicLong getTotalRecord() {
        return this.totalRecord;
    }

    public void setMovedRecord(long movedRecord) {
        this.movedRecord = new AtomicLong(movedRecord);
    }

    public synchronized void incMovedRecord(long incMovedRecord) {
        this.movedRecord.getAndAdd(incMovedRecord);
    }

    public AtomicLong getMovedRecord() {
        return this.movedRecord;
    }

    public void incRunRound() {
        ++this.runRound;
    }

    public int getSourceTableCount() {
        return this.sourceTableCount;
    }

    public void setSourceTableCount(int sourceTableCount) {
        this.sourceTableCount = sourceTableCount;
    }

    public String getProgressType() {
        return this.progressType;
    }

    public void setProgressType(String progressType) {
        this.progressType = progressType;
    }

    @Override
    public void setExecSql(String execSql) {
        this.execSql = execSql;
    }

    public String progress() {
        return BosRes.get((String)"bos-xdb-manager", (String)"ShardingMovingProgress_0", (String)"{0}, {1} source tables, executed {2} times, elapsed time {3}, last start time {4}", (Object[])new Object[]{this.recordPercent(), this.sourceTableCount, this.runRound, this.formatUsedTS(), DateUtil.getDateFormat((String)"yyyy-MM-dd HH:mm:ss").format(new Date(this.tsLastFrom))});
    }

    private String formatUsedTS() {
        long s = this.tsUsed / 1000L;
        if (s < 60L) {
            return BosRes.get((String)"bos-xdb-manager", (String)"ShardingMovingProgress_4", (String)"{0} Seconds", (Object[])new Object[]{s});
        }
        long m = s / 60L;
        if (m < 60L) {
            return BosRes.get((String)"bos-xdb-manager", (String)"ShardingMovingProgress_5", (String)"{0}minutes{1}seconds", (Object[])new Object[]{m, s % 60L});
        }
        long h = m / 60L;
        return BosRes.get((String)"bos-xdb-manager", (String)"ShardingMovingProgress_6", (String)"{0}hours{1}minutes{2}seconds", (Object[])new Object[]{h, m % 60L, s % 60L});
    }

    public String recordPercent() {
        if (this.totalRecord.get() == 0L) {
            return "0%, 0/0";
        }
        BigDecimal p = new BigDecimal(this.movedRecord + "").multiply(new BigDecimal("100")).divide(new BigDecimal(this.totalRecord + ""), 2, 5);
        return p + "%, " + this.movedRecord + "/" + this.totalRecord;
    }

    String progressDesc() {
        return this.progressDescMap.toString();
    }

    String progressSign() {
        return this.serialize();
    }

    private String serialize() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(this);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    private static MainProgress unserialize(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return (MainProgress)is.readObject();
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isContinueSharding() {
        return this.continueSharding;
    }

    @Override
    public boolean isNeedDel() {
        return this.needDel;
    }

    @Override
    public void setNeedDel(boolean needDel) {
        this.needDel = needDel;
    }

    public void setContinueSharding(boolean continueSharding) {
        this.continueSharding = continueSharding;
    }

    public boolean isCurStepExecuted() {
        return this.curStepExecuted;
    }

    public void setCurStepExecuted(boolean curStepExecuted) {
        this.curStepExecuted = curStepExecuted;
    }

    @Override
    public void store(boolean isLog) {
        long segUsed = this.tsLastStore == 0L ? System.currentTimeMillis() - this.tsLastFrom : System.currentTimeMillis() - this.tsLastStore;
        this.tsUsed += segUsed;
        this.tsLastStore = System.currentTimeMillis();
        String sql = "update t_cbs_shard_task set fprogress = ?, fprogressdesc = ?, fprogresssign = ? where fid = ? ";
        Object[] parmas = new Object[]{this.progress(), this.progressDesc(), this.progressSign(), this.taskId};
        sql = ActionUtil.wrapSQL(sql, true, true);
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])parmas);
        String msg = this.progress() + "\r\n" + this.progressDesc();
        if (!StringUtils.isEmpty((String)this.execSql)) {
            msg = msg + "\r\n" + this.execSql;
        }
        if (isLog) {
            ShardLogPublish.get().publishOperationLog(this.taskId, this.entitynumber, msg, this.progressType);
        }
    }

    @Override
    public void store() {
        this.store(true);
    }

    public void setRenamePkTempTable() {
        this.isRenamePKTempTable = true;
    }

    public boolean isRenamePkTempTable() {
        return this.isRenamePKTempTable;
    }

    public boolean isTerminable() {
        return this.terminable;
    }

    public void setTerminable(boolean terminable) {
        this.terminable = terminable;
    }
}

