/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.progress;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.entity.ITaskEntity;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.service.action.parallel.ShardThreadPool;
import kd.bos.xdb.tablemanager.LockCreateTableCall;
import kd.bos.xdb.task.progress.IChildProgress;
import kd.bos.xdb.task.progress.MainProgress;
import kd.bos.xdb.task.service.analysis.entity.SplitInfo;
import kd.bos.xdb.util.Threads;

public class ProgressUtil {
    public static void insertProgressTable(ITaskEntity taskEntity, String shardTable, long index, long totalRecord) {
        ProgressUtil.insertProgressTable(taskEntity, shardTable, index, totalRecord, " ", " ");
    }

    public static void insertProgressTable(ITaskEntity taskEntity, String shardTable, long index, long totalRecord, String originalRoute, String targetRoute) {
        LockCreateTableCall.lockAndCall((String)shardTable, () -> {
            if (ShardProgressRepository.get().loadProgress(taskEntity.getTaskid(), shardTable) == null) {
                String sql = "insert into t_cbs_shard_progress (fid,ftaskid,fentitynumber,fshard_table,fshard_index,fshard_total_record,fshard_moving_record,ftaskstatus,fcreatetime,foriginalroute,ftargetroute) values (?,?,?,?,?,?,?,?,?,?,?)";
                sql = ActionUtil.wrapSQL(sql, true, true);
                long id = IDUtil.id();
                DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])new Object[]{id, taskEntity.getTaskid(), taskEntity.getEntitynumber(), shardTable, index, totalRecord, 0, ShardTaskStatusEnum.UNEXECUTED.getKey(), new Date(), originalRoute, targetRoute});
            }
        });
    }

    public static synchronized void incrToTalRecordAndStore(ITaskEntity taskEntity, Map<Long, List<Object[]>> shardingIndexMap, IChildProgress progress) {
        Iterator<Map.Entry<Long, List<Object[]>>> iterator = shardingIndexMap.entrySet().iterator();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(3);
        long sum = 0L;
        while (iterator.hasNext()) {
            Map.Entry<Long, List<Object[]>> entry = iterator.next();
            long shardingIndex = entry.getKey();
            List<Object[]> pks = entry.getValue();
            Object[] obj = new Object[]{pks.size(), shardingIndex, taskEntity.getTaskid()};
            paramList.add(obj);
            sum += (long)pks.size();
        }
        String sql = "update t_cbs_shard_progress set fshard_total_record = fshard_total_record + ? where fshard_index = ? and ftaskid = ? ";
        String parentSql = "update t_cbs_shard_task set ftotal_record= ftotal_record + ? where fid =? ";
        Object[] parmas = new Object[]{sum, taskEntity.getTaskid()};
        long sumR = sum;
        ProgressUtil.newThreadAndCall(() -> {
            try (XDBExternal tx = XDBExternal.requiresNew((String)"incrToTalRecordAndStore");){
                DB.executeBatch((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(sql, true, true), (List)paramList);
                DB.execute((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(parentSql, true, true), (Object[])parmas);
                progress.getParentSp().incTotalRecord(sumR);
                progress.store();
            }
            return null;
        });
    }

    public static synchronized void incrToTalRecord(ITaskEntity taskEntity, long shardingIndex, long totalRecord, IChildProgress progress) {
        Object[] parmas = new Object[]{totalRecord, shardingIndex, taskEntity.getTaskid()};
        String sql = "update t_cbs_shard_progress set fshard_total_record = fshard_total_record + ? where fshard_index = ? and ftaskid = ? ";
        String parentSql = "update t_cbs_shard_task set ftotal_record= ftotal_record + ? where fid =? ";
        Object[] parentParmas = new Object[]{totalRecord, taskEntity.getTaskid()};
        ProgressUtil.newThreadAndCall(() -> {
            try (XDBExternal tx = XDBExternal.requiresNew((String)"incrToTalRecordAndStore");){
                DB.execute((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(sql, true, true), (Object[])parmas);
                DB.execute((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(parentSql, true, true), (Object[])parentParmas);
                progress.store();
            }
            return null;
        });
    }

    public static synchronized void incrMoveRecordAndStore(ITaskEntity taskEntity, long shardingIndex, long movingRecord, IChildProgress progress) {
        String sql = "update t_cbs_shard_progress set fshard_moving_record = fshard_moving_record + ? where fshard_index = ? and ftaskid = ? ";
        Object[] parmas = new Object[]{movingRecord, shardingIndex, taskEntity.getTaskid()};
        String parentSql = "update t_cbs_shard_task set fmoving_record = fmoving_record + ? where fid =? ";
        Object[] parentParmas = new Object[]{movingRecord, taskEntity.getTaskid()};
        ProgressUtil.newThreadAndCall(() -> {
            try (XDBExternal tx = XDBExternal.requiresNew((String)"incrMoveRecordAndStore");){
                DB.execute((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(sql, true, true), (Object[])parmas);
                DB.execute((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(parentSql, true, true), (Object[])parentParmas);
                progress.getParentSp().incMovedRecord(movingRecord);
                progress.store(false);
            }
            return null;
        });
    }

    public static synchronized void incrMoveRecordAndStore(ITaskEntity taskEntity, String shardingTable, long movingRecord, IChildProgress progress) {
        String sql = "update t_cbs_shard_progress set fshard_moving_record = fshard_moving_record + ? where fshard_table = ? and ftaskid = ? ";
        Object[] parmas = new Object[]{movingRecord, shardingTable, taskEntity.getTaskid()};
        String parentSql = "update t_cbs_shard_task set fmoving_record = fmoving_record + ? where fid =? ";
        Object[] parentParmas = new Object[]{movingRecord, taskEntity.getTaskid()};
        ProgressUtil.newThreadAndCall(() -> {
            try (XDBExternal tx = XDBExternal.requiresNew((String)"incrMoveRecordAndStore");){
                DB.execute((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(sql, true, true), (Object[])parmas);
                DB.execute((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(parentSql, true, true), (Object[])parentParmas);
                progress.getParentSp().incMovedRecord(movingRecord);
                progress.store();
            }
            return null;
        });
    }

    public static synchronized void storeTotalRecord(ITaskEntity taskEntity, long totalRecord, MainProgress progress) {
        String sql = "update t_cbs_shard_task set ftotal_record=? where fid =? ";
        Object[] parmas = new Object[]{totalRecord, taskEntity.getTaskid()};
        ProgressUtil.newThreadAndCall(() -> {
            try (XDBExternal tx = XDBExternal.requiresNew((String)"storeTotalRecord");){
                DB.execute((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(sql, true, true), (Object[])parmas);
                progress.setTotalRecord(totalRecord);
                progress.store(true);
            }
            return null;
        });
    }

    public static synchronized long insertSplitTask(ITaskEntity taskEntity, SplitInfo splitInfo, MainProgress progress) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into t_cbs_shard_splittask (");
        sql.append(" fid,ftaskid,fentitynumber,fnum,fheadpk,ftailpk,fremark,");
        sql.append(" ftotalcount,ftaskstatus,fcreatetime ");
        sql.append(" )values (?,?,?,?,?,?,?,?,?,?)");
        long id = ID.genLongId();
        ArrayList<Object> obj = new ArrayList<Object>(12);
        obj.add(id);
        obj.add(taskEntity.getTaskid());
        obj.add(taskEntity.getEntitynumber());
        obj.add(splitInfo.getNum());
        obj.add(splitInfo.getHeadPk());
        obj.add(splitInfo.getTailPk());
        obj.add(splitInfo.getRemark());
        obj.add(splitInfo.getTotalCount());
        obj.add(ShardTaskStatusEnum.UNEXECUTED.getKey());
        obj.add(new Date());
        ProgressUtil.newThreadAndCall(() -> {
            try (XDBExternal tx = XDBExternal.requiresNew((String)"incrToTalRecordAndStore");){
                DB.execute((DBRoute)DBRoute.base, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])obj.toArray());
                progress.store(false);
            }
            return null;
        });
        return id;
    }

    public static void newThreadAndCall(Callable call) {
        block21: {
            if (ShardTaskConfig.isEnableStoreInTx()) {
                try (ShardThreadPool shardThreadPool = new ShardThreadPool(1, 1);){
                    shardThreadPool.start();
                    Future future = shardThreadPool.submit(Threads.wrapCallable((Callable)call));
                    try {
                        future.get();
                        break block21;
                    }
                    catch (Throwable e) {
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        shardThreadPool.shutdown();
                        while (!shardThreadPool.isTerminated()) {
                            Thread.sleep(200L);
                        }
                        throw ExceptionUtil.wrap((String)sw.toString());
                    }
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
            try {
                call.call();
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    // empty if block
                }
                throw ExceptionUtil.wrap((Throwable)e);
            }
        }
    }
}

