/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.Consistency;

import com.google.common.base.Joiner;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.db.sharding.tablerw.DBTableRWNotifier;
import kd.bos.db.sharding.tablerw.ZKWatichConfirmNotifier;
import kd.bos.instance.Instance;
import kd.bos.orm.ORM;
import kd.bos.util.NetAddressUtils;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.task.progress.MainProgress;

public interface ClusterTableRWConfirm {
    default public ZKWatichConfirmNotifier clusterTableRWConfirm(String entitynumber, String rwmark) {
        boolean confirmAll;
        ORM orm = ORM.create();
        IDataEntityType dt = orm.getDataEntityType(entitynumber);
        int n = 5;
        ZKWatichConfirmNotifier confirmNotifier = null;
        while (n-- > 0 && !(confirmAll = (confirmNotifier = DBTableRWNotifier.confirmNotifierTableRW((String)entitynumber, (String)dt.getAlias(), (String)rwmark)).isConfirmAll())) {
            ShardingManager.get().notifyReloadShardingConfig(entitynumber);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
        }
        return confirmNotifier;
    }

    default public void setTaskWarningstatus(ShardTaskEntity taskEntity, ZKWatichConfirmNotifier confirmNotifier, MainProgress mainProgress) {
        String tbNoti = Joiner.on((char)',').join((Iterable)confirmNotifier.getTobeNotifier());
        ShardLogPublish.get().publishOperationLog(taskEntity.getId(), taskEntity.getEntitynumber(), String.format(ResManager.loadKDString((String)"%1$s , task execution node: instance= %2$s  %3$s , the following cluster node information is not synchronized: %4$s.", (String)"ClusterTableRWConfirm_0", (String)"bos-xdb-manager", (Object[])new Object[0]), ShardTaskNodeEnum.CLUSTERTBLOCK.getValue(), Instance.getInstanceId(), NetAddressUtils.getLocalIpAddress(), tbNoti), mainProgress.getProgressType());
        ShardTaskRepository.get().setTaskWarningstatus(taskEntity.getId(), taskEntity.getTasknode());
    }
}

