/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import kd.bos.bundle.BosRes;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardArchiStatusEnum;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.enums.ShardFastIndexStatusEnum;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.enums.ShardTaskTypeEnum;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardArchiRepository;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.repository.ShardFastIndexConfigRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.action.parallel.ShardThreadPool;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.MainProgress;
import kd.bos.xdb.task.service.IShardingTask;

public abstract class ShardingTaskServiceAbst
implements IShardingTask {
    protected static final ShardThreadPool calcCountPools = new ShardThreadPool();
    protected ShardTaskRuntime shardTaskRuntime = ShardTaskRuntime.get();
    protected ShardTaskEntity taskEntity;
    protected Configuration configuration;
    protected ShardTaskNodeEnum taskNodeEnum;
    public MainProgress mainProgress;
    private ShardingTaskServiceAbst next;

    public ShardingTaskServiceAbst getNext() {
        return this.next;
    }

    public void setNext(ShardingTaskServiceAbst next) {
        this.next = next;
    }

    public ShardingTaskServiceAbst(ShardTaskEntity taskEntity, Configuration configuration, ShardTaskNodeEnum taskNodeEnum) {
        this.taskNodeEnum = taskNodeEnum;
        this.taskEntity = taskEntity;
        this.configuration = configuration;
    }

    @Override
    public void sharding() throws Exception {
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler sharding,entitynumber:{0}, taskId:{1}, taskNode:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), this.taskEntity.getTasknode().getKey()));
        this.flushTaskEntity();
        if (this.taskEntity.getTasknode() == this.taskNodeEnum) {
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler doSharding begin,entitynumber:{0}, taskId:{1}, taskNode:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), this.taskEntity.getTasknode().getKey()));
            try (DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
                if (!this.doSharding()) {
                    try {
                        if (this.getNext() != null) {
                            String rwMark;
                            ShardTaskRepository.get().setNextTaskNode(this.taskEntity.getId(), this.taskEntity.getTasknode(), this.getNext().taskNodeEnum);
                            this.mainProgress.setCurStepExecuted(false);
                            this.mainProgress.setMovingShardingIndex(-1L);
                            this.mainProgress.store(false);
                            if (this.taskEntity.getTasknode() == ShardTaskNodeEnum.DATAMOVE) {
                                if (this.taskEntity.getTasktype() == ShardTaskTypeEnum.SHARDENABLE) {
                                    ShardConfigRepository.get().setConfigstatus(this.configuration.getConfigEntity().getId(), ShardConfigStatusEnum.ENABLING, ShardConfigStatusEnum.ENABLE);
                                } else {
                                    ShardConfigRepository.get().setConfigstatus(this.configuration.getConfigEntity().getId(), ShardConfigStatusEnum.DISANLING, ShardConfigStatusEnum.DISABLE);
                                }
                                rwMark = ShardingManager.get().notifyLimitTableRW(this.configuration.getRootDT().getAlias(), true);
                                if (this.taskEntity.getTasktype() == ShardTaskTypeEnum.SHARDENABLE) {
                                    ShardConfigRepository.get().setConfigRWmark(this.configuration.getConfigEntity().getId(), rwMark, ShardConfigStatusEnum.ENABLE);
                                } else {
                                    ShardConfigRepository.get().setConfigRWmark(this.configuration.getConfigEntity().getId(), rwMark, ShardConfigStatusEnum.DISABLE);
                                }
                                ShardingManager.get().notifyReloadShardingConfig(this.taskEntity.getEntitynumber());
                            } else if (this.taskEntity.getTasknode() == ShardTaskNodeEnum.INDEXMOVE) {
                                if (this.taskEntity.getTasktype() == ShardTaskTypeEnum.MOVEINDEX) {
                                    ShardFastIndexConfigRepository.get().setFastIndexConfigStatus(this.configuration.getShardFastIndexConfigEntity().getId(), ShardFastIndexStatusEnum.ENABLING, ShardFastIndexStatusEnum.CONFIGURABLE);
                                }
                                rwMark = ShardingManager.get().notifyLimitTableRW(this.configuration.getRootDT().getAlias(), true);
                                ShardConfigRepository.get().setConfigRWmark(this.configuration.getShardFastIndexConfigEntity().getConfigId(), rwMark, ShardConfigStatusEnum.MOVEINDEX);
                                ShardConfigRepository.get().setConfigstatus(this.configuration.getShardFastIndexConfigEntity().getConfigId(), ShardConfigStatusEnum.MOVEINDEX, ShardConfigStatusEnum.ENABLE);
                                ShardFastIndexConfigRepository.get().setFastIndexConfigRWMark(this.configuration.getShardFastIndexConfigEntity().getId(), rwMark, ShardFastIndexStatusEnum.CONFIGURABLE);
                                ShardingManager.get().notifyReloadShardingConfig(this.taskEntity.getEntitynumber());
                            } else if (this.taskEntity.getTasknode() == ShardTaskNodeEnum.ARCHIVEMOVE) {
                                if (this.taskEntity.getTasktype() == ShardTaskTypeEnum.SHARDARCHIVE) {
                                    ShardArchiRepository.get().setShardArchiStatus(this.configuration.getArchiEntity().getId(), ShardArchiStatusEnum.ENABLING, ShardArchiStatusEnum.CONFIGURABLE);
                                }
                                rwMark = ShardingManager.get().notifyLimitTableRW(this.configuration.getRootDT().getAlias(), true);
                                ShardConfigRepository.get().setConfigRWmark(this.configuration.getArchiEntity().getConfigId(), rwMark, ShardConfigStatusEnum.ARCHIVEMOVE);
                                ShardConfigRepository.get().setConfigstatus(this.configuration.getArchiEntity().getConfigId(), ShardConfigStatusEnum.ARCHIVEMOVE, ShardConfigStatusEnum.ENABLE);
                                ShardArchiRepository.get().setShardArchiRWMark(this.configuration.getArchiEntity().getId(), rwMark, ShardArchiStatusEnum.CONFIGURABLE);
                                ShardingManager.get().notifyReloadShardingConfig(this.taskEntity.getEntitynumber());
                            }
                        } else {
                            ShardTaskRepository.get().updateSuccess(this.taskEntity.getId());
                        }
                        ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), (Object)((Object)this.taskEntity.getTasknode()) + BosRes.get((String)"bos-xdb-manager", (String)"ShardActionClusterTbLock_0", (String)"Task Node Execution Completed", (Object[])new Object[0]), this.mainProgress.getProgressType());
                    }
                    catch (Throwable e) {
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        String error = MessageFormat.format("ShardTaskMovingHandler Setting next step to <{0}> error, taskId:{1}, entitynumber:{2}, errorinfo:{3}", new Object[]{this.getNext().taskNodeEnum, this.taskEntity.getId(), this.taskEntity.getEntitynumber(), sw.toString()});
                        XDBManagerUtil.logError(error, e);
                        ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.EXECUTING, ShardTaskStatusEnum.FAILED);
                        ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, "TASKSWITCHERROR");
                    }
                }
            }
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler doSharding end,entitynumber:{0}, taskId:{1}, taskNode:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), this.taskEntity.getTasknode().getKey()));
        }
        if (this.getNext() != null) {
            this.getNext().sharding();
        }
    }

    protected void flushTaskEntity() {
        this.taskEntity = ShardTaskRepository.get().loadTask(this.taskEntity.getId());
        this.mainProgress = MainProgress.of(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), this.taskEntity.getProgresssign());
        if (this.taskNodeEnum == ShardTaskNodeEnum.CLUSTERTBLOCK && this.taskEntity.getProgresssign() != null && this.taskEntity.getProgresssign().trim().length() > 0) {
            this.mainProgress.incRunRound();
            this.mainProgress.store(false);
        }
        this.mainProgress.setProgressType(this.getProgressType());
    }

    public abstract boolean doSharding() throws Exception;

    protected String getProgressType() {
        return (Object)((Object)this.taskEntity.getTasktype()) + "#" + (Object)((Object)this.taskEntity.getTasknode());
    }
}

