/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.analysis.writer;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.entity.ShardSplitTaskEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.IChildProgress;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.taskgroup.WriterAbst;
import kd.bos.xdb.transport.record.RowRecord;

public class AnalysisWriter
extends WriterAbst {
    private ShardSplitTaskEntity splitTaskEntity;
    private ShardingConfig mainShardingConfig;
    private long lastIndex;
    private AbstractShardingStrategy mainShardingStrategy;
    private FilterType[] fts;
    private DBRoute route;
    private TableManager tm = XDBConfig.getTableManager();
    private int loop = 0;

    public AnalysisWriter(ShardSplitTaskEntity splitTaskEntity, Configuration configuration, IChildProgress progress, long lastIndex) {
        super(configuration, progress);
        this.splitTaskEntity = splitTaskEntity;
        this.lastIndex = lastIndex;
        this.mainShardingConfig = configuration.getMainShardingConfig();
        this.mainShardingStrategy = (AbstractShardingStrategy)this.mainShardingConfig.getShardingStrategy();
        this.fts = new FilterType[this.mainShardingConfig.getShardingFields().length];
        for (int i = 0; i < this.mainShardingConfig.getShardingFields().length; ++i) {
            this.fts[i] = FilterType.eq;
        }
        this.route = configuration.getRoute();
    }

    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) throws SQLException {
        Object fromPK = writerBuffer.get(0).getPk();
        Object toPk = writerBuffer.get(writerBuffer.size() - 1).getPk();
        int bufferSize = writerBuffer.size();
        this.progress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"AnalysisWriter_0", (String)"Header shard analysis: remark={0}, fromPK={1}, toPK={2}, pks={3}", (Object[])new Object[]{this.splitTaskEntity.getRemark(), fromPK, toPk, bufferSize}));
        TreeMap<Long, List<Object[]>> shardingIndexMap = new TreeMap<Long, List<Object[]>>();
        for (RowRecord rowRecord : writerBuffer) {
            this.shardingIndexMap(rowRecord, shardingIndexMap);
        }
        this.shardingIndexMapInsert(shardingIndexMap);
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        this.lastIndex = -1L;
        this.progress.setMovingShardingIndex(this.lastIndex);
        this.progress.setToPk(toPk);
        this.progress.setExecSql(null);
        this.progress.store(false);
    }

    private void shardingIndexMap(RowRecord rowRecord, Map<Long, List<Object[]>> shardingIndexMap) {
        long index = this.mainShardingStrategy.shardingIndex(this.fts, rowRecord.getColumns())[0];
        if (index > this.lastIndex) {
            List list = shardingIndexMap.computeIfAbsent(index, k -> new ArrayList());
            list.add(new Object[]{rowRecord.getPk()});
        }
    }

    public void shardingIndexMapInsert(Map<Long, List<Object[]>> shardingIndexMap) throws SQLException {
        for (Map.Entry<Long, List<Object[]>> entry : shardingIndexMap.entrySet()) {
            long shardingIndex = entry.getKey();
            List<Object[]> pks = entry.getValue();
            Object fromPK = pks.get(0)[0];
            Object toPk = pks.get(pks.size() - 1)[0];
            this.insertProgressTbAndPks(shardingIndex, pks);
            this.progress.setMovingShardingIndex(shardingIndex);
            this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"AnalysisWriter_1", (String)"Intermediate table data generation: index={0}, fromPK={1}, toPK={2}, pks={3}", (Object[])new Object[]{shardingIndex, fromPK, toPk, pks.size()}));
            ProgressUtil.incrToTalRecord(this.splitTaskEntity, entry.getKey(), entry.getValue().size(), this.progress);
        }
    }

    public void insertProgressTbAndPks(long shardingIndex, List<Object[]> pks) throws SQLException {
        if (pks.isEmpty()) {
            return;
        }
        TableName mainTN = TableName.of((String)this.mainShardingConfig.getTable());
        String mainMvShardingTable = mainTN.getMovingTable(shardingIndex);
        String mainShardingTable = mainTN.getShardingTable(shardingIndex);
        if (!this.tm.existTable(mainMvShardingTable)) {
            this.tm.createMovingTable(mainMvShardingTable, shardingIndex, ActionUtil.getPkTypeEnum(this.splitTaskEntity.getEntitynumber()));
            ProgressUtil.insertProgressTable(this.splitTaskEntity, mainShardingTable, shardingIndex, 0L);
        }
        this.insertPKs(mainMvShardingTable, pks);
    }

    private void insertPKs(String mainMvShardingTable, List<Object[]> pks) {
        if (DBType.mysql != this.dbType && this.progress.isNeedDel()) {
            this.deleteDuplicate(this.route, mainMvShardingTable, "fid", pks.stream().map(iter -> iter[0]).collect(Collectors.toList()));
        }
        StringBuilder sql = new StringBuilder();
        sql.append(DBType.mysql == this.dbType ? "replace " : "insert ");
        sql.append(" into ").append(mainMvShardingTable).append("(fid) values(?)");
        List<List> splitList = this.splitArrayList(pks);
        for (List range : splitList) {
            DB.executeBatch((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (List)range);
        }
    }

    private List<List> splitArrayList(List<Object[]> pks) {
        ArrayList<List> ranges = new ArrayList<List>(10);
        int pageSize = XDBManagerConstant.DATA_INSERT_PAGE_SIZE;
        if (pks.size() <= pageSize) {
            ranges.add(pks);
        } else {
            int toIndex;
            int total = pks.size();
            int i = 0;
            do {
                int fromIndex = i;
                toIndex = Math.min(i += pageSize, total) - 1;
                List<Object[]> range = pks.subList(fromIndex, toIndex + 1);
                ranges.add(range);
            } while (toIndex != total - 1);
        }
        return ranges;
    }
}

