/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.disablemove;

import com.alibaba.druid.util.StringUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardArchiKanbanRepository;
import kd.bos.xdb.repository.ShardArchiRepository;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.service.action.parallel.ShardThreadPool;
import kd.bos.xdb.service.calc.CountShardingTableCall;
import kd.bos.xdb.service.calc.CountTableCall;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.ShardingTaskServiceAbst;
import kd.bos.xdb.task.service.disablemove.work.DisableMoveWorkAdaptive;
import kd.bos.xdb.task.service.disablemove.work.DisableMoveWorkRunner;
import kd.bos.xdb.util.Threads;

public final class ShardingDisableServiceAdaptive
extends ShardingTaskServiceAbst {
    public ShardingDisableServiceAdaptive(ShardTaskEntity taskEntity, Configuration configuration) {
        super(taskEntity, configuration, ShardTaskNodeEnum.DATAMOVE);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doSharding() throws Exception {
        TableManager tm;
        block51: {
            boolean isPaused;
            block50: {
                Iterator<ShardProgressEntity> threadPool2;
                block53: {
                    List<ShardProgressEntity> shardProgressEntities;
                    Serializable countTableCalls;
                    block52: {
                        tm = XDBConfig.getTableManager();
                        if (ShardTaskConfig.isShardingMovingDisableQuick()) break block51;
                        if (this.mainProgress.isCurStepExecuted()) {
                            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingDisableService_1", (String)"Continue Data Migration", (Object[])new Object[0]));
                            this.mainProgress.setTotalRecord(this.taskEntity.getTotalRecord());
                            this.mainProgress.setMovedRecord(this.taskEntity.getMovingRecord());
                            this.mainProgress.store(true);
                        } else {
                            AtomicLong totalCount = new AtomicLong(0L);
                            ArrayList results = new ArrayList(this.configuration.getShardingConfigs().size());
                            int sourceTableCount = 0;
                            for (int seq = 0; seq < this.configuration.getShardingConfigs().size(); ++seq) {
                                ShardingConfig sc = this.configuration.getShardingConfigs().get(seq);
                                String string = TableName.of((String)sc.getTable()).getOriginalName();
                                List<String> list = Arrays.asList(tm.getShardingTable(string));
                                sourceTableCount += list.size();
                                if (list.size() == 0) {
                                    results.add(calcCountPools.submit(Threads.wrapCallable((Callable)new CountShardingTableCall(this.configuration.getRoute(), TableName.of((String)string).getPrototypeTable(), string))));
                                    continue;
                                }
                                for (String shardTable : list) {
                                    DBRoute dbRoute = DBRoute.of((String)this.getRouteOfTable(shardTable));
                                    results.add(calcCountPools.submit(Threads.wrapCallable((Callable)new CountShardingTableCall(dbRoute, shardTable, string))));
                                }
                            }
                            countTableCalls = new ArrayList(results.size());
                            for (Future future : results) {
                                countTableCalls.add(future.get());
                            }
                            Map<String, List<CountTableCall>> originalNameMap = countTableCalls.stream().collect(Collectors.groupingBy(CountTableCall::getOriginalName));
                            for (Map.Entry<String, List<CountTableCall>> entry : originalNameMap.entrySet()) {
                                Object tableCall2;
                                String originalName = entry.getKey();
                                List<CountTableCall> callList = entry.getValue();
                                AtomicLong originalNameCount = new AtomicLong(0L);
                                for (Object tableCall2 : callList) {
                                    totalCount.addAndGet(((CountTableCall)tableCall2).getCount());
                                    originalNameCount.addAndGet(((CountTableCall)tableCall2).getCount());
                                }
                                String mvTable = TableName.of((String)originalName).getMovingTable(-1L);
                                if (tm.existTable(mvTable)) continue;
                                tm.createMovingTable(mvTable, -1L, ActionUtil.getPkTypeEnum(this.taskEntity.getEntitynumber()));
                                tableCall2 = entry.getValue().iterator();
                                while (tableCall2.hasNext()) {
                                    CountTableCall countTableCall = (CountTableCall)tableCall2.next();
                                    String shardTable = countTableCall.getShardTable();
                                    long count = countTableCall.getCount();
                                    ProgressUtil.insertProgressTable(this.taskEntity, shardTable, -1L, count, this.getRouteOfTable(shardTable), this.configuration.getRoute().getRouteKey());
                                }
                            }
                            HashSet<String> hashSet = new HashSet<String>();
                            DBRoute dBRoute = this.configuration.getRoute();
                            for (int seq = 0; seq < this.configuration.getShardingConfigs().size(); ++seq) {
                                String table = this.configuration.getShardingConfigs().get(seq).getTable();
                                if (!DB.exitsTableForManager((DBRoute)dBRoute, (String)table) || hashSet.contains(table)) continue;
                                if (DB.exitsTable((DBRoute)dBRoute, (String)(table + "$bak"))) {
                                    ActionUtil.dropTable(dBRoute, table + "$bak");
                                }
                                ActionUtil.backupTable(dBRoute, table);
                                tm.clearCahce(table);
                                hashSet.add(table);
                                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingDisableService_2", (String)"Bakup", (Object[])new Object[0]) + table);
                                this.mainProgress.store();
                            }
                            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingDisableService_0", (String)"Start data migration, first execution...", (Object[])new Object[0]));
                            this.mainProgress.setMovedRecord(0L);
                            this.mainProgress.setSourceTableCount(sourceTableCount);
                            this.mainProgress.setCurStepExecuted(true);
                            ProgressUtil.storeTotalRecord(this.taskEntity, totalCount.get(), this.mainProgress);
                        }
                        for (ShardingConfig shardingConfig : this.configuration.getShardingConfigs()) {
                            String tableName = shardingConfig.getTable();
                            XDBManagerUtil.checkAllShardTableColumn(tableName, this.taskEntity.getEntitynumber());
                        }
                        for (int seq = 0; seq < this.configuration.getShardingConfigs().size(); ++seq) {
                            String table = this.configuration.getShardingConfigs().get(seq).getTable();
                            if (tm.existTable(table)) continue;
                            tm.createOriginalTable(table, tm.existTable(TableName.of((String)table).getOriginalsnapTable()));
                            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardingDisableService_3", (String)"Create table", (Object[])new Object[0]) + table);
                            this.mainProgress.store();
                        }
                        shardProgressEntities = ShardProgressRepository.get().loadUnexecutedProgressList(this.taskEntity.getId(), null);
                        isPaused = false;
                        if (!shardProgressEntities.isEmpty()) break block52;
                        if (ShardProgressRepository.get().countProgressUnclosed(this.taskEntity.getId()) > 0L) {
                            throw ExceptionUtil.wrap((String)BosRes.get((String)"bos-xdb-manager", (String)"DataMove_3", (String)"There are outstanding parallel migration task", (Object[])new Object[0]));
                        }
                        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler datamove doDataMoving end,entitynumber:{0}, taskId:{1}, progressCount:{2}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), shardProgressEntities.size()));
                        break block50;
                    }
                    if (ShardTaskConfig.isEnableMovingParallel()) {
                        ShardThreadPool threadPool2 = new ShardThreadPool();
                        countTableCalls = null;
                        try {
                            boolean bl;
                            threadPool2.setTable(this.taskEntity.getEntitynumber());
                            threadPool2.setName("XDB-DisableParallelThread-");
                            threadPool2.start();
                            ArrayList futureList = new ArrayList(shardProgressEntities.size());
                            for (ShardProgressEntity shardProgressEntity : shardProgressEntities) {
                                SubProgress subProgress = SubProgress.of(shardProgressEntity.getId(), this.taskEntity.getEntitynumber(), shardProgressEntity.getProgresssign());
                                subProgress.setParentSp(this.mainProgress);
                                Future future = threadPool2.submit(Threads.wrapCallable((Callable)new DisableMoveWorkRunner(new DisableMoveWorkAdaptive(shardProgressEntity, this.taskEntity, this.configuration, subProgress), this.configuration.getRoute(), shardProgressEntity)));
                                futureList.add(future);
                            }
                            boolean bl2 = false;
                            String string = "";
                            for (Future future : futureList) {
                                try {
                                    if (bl) {
                                        future.cancel(true);
                                        continue;
                                    }
                                    if (!isPaused) {
                                        isPaused = (Boolean)future.get();
                                        continue;
                                    }
                                    future.get();
                                }
                                catch (Throwable e) {
                                    StringWriter sw = new StringWriter();
                                    e.printStackTrace(new PrintWriter(sw));
                                    String error = MessageFormat.format("ShardTaskMovingHandler ShardingDataMoveService future.get error,entitynumber:{0}, taskId:{1}, isException:{2}, errorinfo:{3}", this.taskEntity.getEntitynumber(), this.taskEntity.getId(), bl, sw.toString());
                                    XDBManagerUtil.logError(error, e);
                                    ShardTaskRuntime.get().setTaskInterruptedCurrentNode(true, this.configuration.getMainTable());
                                    ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), error, this.getProgressType());
                                    if (bl) continue;
                                    String string2 = sw.toString();
                                    bl = true;
                                }
                            }
                            if (bl) {
                                threadPool2.shutdown();
                            }
                            break block50;
                        }
                        catch (Throwable futureList) {
                            countTableCalls = futureList;
                            throw futureList;
                        }
                        finally {
                            if (threadPool2 != null) {
                                if (countTableCalls != null) {
                                    try {
                                        threadPool2.close();
                                    }
                                    catch (Throwable futureList) {
                                        ((Throwable)countTableCalls).addSuppressed(futureList);
                                    }
                                } else {
                                    threadPool2.close();
                                }
                            }
                        }
                    }
                    threadPool2 = shardProgressEntities.iterator();
                    break block53;
                    while (true) {
                        if (threadPool2.isTerminated()) {
                            void var8_40;
                            throw ExceptionUtil.wrap((String)var8_40);
                        }
                        Thread.sleep(200L);
                    }
                }
                while (threadPool2.hasNext()) {
                    ShardProgressEntity progressEntity = threadPool2.next();
                    if (this.shardTaskRuntime.isTaskPaused(this.configuration.getMainTable())) {
                        isPaused = true;
                        break;
                    }
                    SubProgress subProgress = SubProgress.of(progressEntity.getId(), this.taskEntity.getEntitynumber(), progressEntity.getProgresssign());
                    subProgress.setParentSp(this.mainProgress);
                    DisableMoveWorkAdaptive disableMoveWorkAdaptive = new DisableMoveWorkAdaptive(progressEntity, this.taskEntity, this.configuration, subProgress);
                    isPaused = disableMoveWorkAdaptive.doWork();
                    if (isPaused) break;
                    this.mainProgress.setExecSql(null);
                    this.mainProgress.store(false);
                }
            }
            long unclosed = ShardProgressRepository.get().countProgressUnclosed(this.taskEntity.getId());
            if (isPaused) {
                if (unclosed != 0L) {
                    ShardTaskRepository.get().setTaskSuspended(this.taskEntity.getId());
                    XDBManagerUtil.logInfo(MessageFormat.format("ArchiveTaskHandler ShardingDataMoveService doSharding paused,entitynumber:{0}, taskId:{1}", this.taskEntity.getEntitynumber(), this.taskEntity.getId()));
                    ShardLogPublish.get().publishOperationLog(this.taskEntity.getId(), this.taskEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"ShardActionDisableDataMove_0", (String)"Task Paused", (Object[])new Object[0]), this.getProgressType());
                    return true;
                }
                ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.EXECUTING);
                ShardingManager.get().notifyLimitTaskPaused(false, this.configuration.getMainTable());
            } else if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
                ShardTaskRepository.get().setNextTaskstatus(this.taskEntity.getId(), ShardTaskStatusEnum.PAUSE, ShardTaskStatusEnum.EXECUTING);
                ShardingManager.get().notifyLimitTaskPaused(false, this.configuration.getMainTable());
            }
            if (unclosed > 0L) {
                throw new RuntimeException(BosRes.get((String)"bos-xdb-manager", (String)"DataMove_3", (String)"There are outstanding parallel migration task", (Object[])new Object[0]));
            }
            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ShardActionDisableDataMove_3", (String)"Delete Intermediate Table", (Object[])new Object[0]));
            this.mainProgress.store(true);
            for (int seq = 0; seq < this.configuration.getShardingConfigs().size(); ++seq) {
                ShardingConfig shardingConfig = this.configuration.getShardingConfigs().get(seq);
                String string = TableName.of((String)shardingConfig.getTable()).getMovingTable(-1L);
                ActionUtil.dropTable(this.configuration.getRoute(), string);
                tm.removeCahce(string);
            }
        }
        this.mainProgress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"ShardActionDisableDataMove_4", (String)"Delete All Shard Tables", (Object[])new Object[0]));
        this.mainProgress.store(true);
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(this.taskEntity.getEntitynumber());
        Set archiveRoutes = mainConfig.getOptions().getIndexRoute().getAllArchiveRoutes();
        Iterator<ShardingConfig> iterator = this.configuration.getShardingConfigs().iterator();
        block25: while (true) {
            if (!iterator.hasNext()) {
                ShardArchiRepository.get().clearArchi(this.taskEntity.getEntitynumber());
                ShardArchiKanbanRepository.get().clearArchiKanban(this.taskEntity.getEntitynumber());
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DataMove_4", (String)"Data Migration Complete", (Object[])new Object[0]));
                this.mainProgress.store(true);
                return false;
            }
            ShardingConfig shardingConfig = iterator.next();
            String tableName = shardingConfig.getTable();
            TableName tableName2 = TableName.of((String)tableName);
            ActionUtil.dropTable(this.configuration.getRoute(), tableName2.getPrototypeTable());
            ActionUtil.dropTable(this.configuration.getRoute(), tableName2.getOriginalsnapTable());
            this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_0", (String)"Delete Prototype Table: {0}", (Object[])new Object[]{tableName2.getPrototypeTable()}));
            this.mainProgress.store(true);
            if (shardingConfig instanceof MainTableConfig) {
                ActionUtil.dropTable(this.configuration.getRoute(), tableName2.getMapTable());
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_1", (String)"Delete Map Table: {0}", (Object[])new Object[]{tableName2.getMapTable()}));
                this.mainProgress.store(true);
                ActionUtil.dropTable(this.configuration.getRoute(), tableName2.getPKTable());
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_2", (String)"Delete Pk Table: {0}", (Object[])new Object[]{tableName2.getPKTable()}));
                this.mainProgress.store(true);
                ActionUtil.dropTable(this.configuration.getRoute(), tableName2.getRTTable());
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_6", (String)"Delete RT Table: {0}", (Object[])new Object[]{tableName2.getRTTable()}));
                this.mainProgress.store(true);
            }
            for (String archiveRoute : archiveRoutes) {
                if (!DB.exitsTable((DBRoute)DBRoute.of((String)archiveRoute), (String)tableName2.getPrototypeTable())) continue;
                ActionUtil.dropTable(DBRoute.of((String)archiveRoute), tableName2.getPrototypeTable());
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_5", (String)"Delete shard prototype table: {0}, archive route: {1}", (Object[])new Object[]{tableName2.getPrototypeTable(), archiveRoute}));
                this.mainProgress.store(true);
            }
            for (String archiveRoute : archiveRoutes) {
                if (!DB.exitsTable((DBRoute)DBRoute.of((String)archiveRoute), (String)tableName2.getPKTable())) continue;
                ActionUtil.dropTable(DBRoute.of((String)archiveRoute), tableName2.getPKTable());
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_5", (String)"Delete shard prototype table: {0}, archive route: {1}", (Object[])new Object[]{tableName2.getPKTable(), archiveRoute}));
                this.mainProgress.store(true);
            }
            tm.clearCahce(tableName);
            String[] stringArray = tm.getShardingTable(tableName);
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block25;
                String sharingTable = stringArray[n2];
                DBRoute dbRoute = DBRoute.of((String)this.getRouteOfTable(sharingTable));
                ActionUtil.dropTable(dbRoute, sharingTable);
                this.mainProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"ActionUtil_3", (String)"Delete Shard Table: {0}", (Object[])new Object[]{sharingTable}));
                this.mainProgress.store(true);
                ++n2;
            }
            break;
        }
    }

    private String getRouteOfTable(String tableName) {
        String originalName = TableName.of((String)tableName).getOriginalName();
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getMainConfig(originalName);
        String curRoute = mainConfig.getOptions().getIndexRoute().getRoute(tableName);
        return StringUtils.isEmpty((String)curRoute) ? mainConfig.getOptions().getDbRouteKey() : curRoute;
    }
}

