/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.disablemove.reader;

import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.taskgroup.Reader;
import kd.bos.xdb.transport.exchanger.RecordSender;
import kd.bos.xdb.transport.record.RowRecord;

public class AdaptiveDisableReader
implements Reader {
    private final Configuration configuration;
    private final ShardProgressEntity progressEntity;
    private final String pkField;
    private final String columnFields;
    private final int columnLength;
    private final Object lastPk;
    private final boolean isSameRouteMove;

    public AdaptiveDisableReader(ShardProgressEntity progressEntity, Configuration configuration, String pkField, String columnFields, Object lastPk) {
        this.progressEntity = progressEntity;
        this.configuration = configuration;
        this.pkField = pkField;
        this.columnFields = columnFields;
        String[] fields = this.columnFields.split(",");
        this.columnLength = fields.length;
        this.lastPk = lastPk;
        this.isSameRouteMove = progressEntity.getTargetRoute().equalsIgnoreCase(progressEntity.getOriginalRoute());
    }

    @Override
    public boolean startRead(RecordSender recordSender) {
        AtomicInteger finalSize;
        Object fromPK = this.lastPk;
        do {
            if (ShardTaskRuntime.get().isTaskInterrupted(this.configuration.getMainTable())) {
                return false;
            }
            if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
                return true;
            }
            StringBuilder sql = new StringBuilder(128);
            if (this.isSameRouteMove) {
                sql.append("select top ").append(XDBManagerConstant.PAGE_SIZE).append(" ");
                sql.append(this.pkField);
            } else {
                sql.append("select top ").append(XDBManagerConstant.CROSS_PAGE_SIZE).append(" ");
                sql.append(this.columnFields);
            }
            sql.append(" from ").append(this.progressEntity.getShardTable());
            Object[] params = null;
            if (fromPK != null) {
                params = new Object[]{fromPK};
                sql.append(" where ").append(this.pkField).append(" > ?");
            }
            sql.append(" order by ").append(this.pkField).append(" asc ");
            String s = ActionUtil.wrapSQL(sql.toString(), false, true);
            finalSize = new AtomicInteger();
            try (DataSet dataSet = DB.queryDataSet((String)"CrossDisableReader", (DBRoute)DBRoute.of((String)this.progressEntity.getOriginalRoute()), (String)s, (Object[])params);){
                for (Row row : dataSet) {
                    Object pkValue;
                    RowRecord rowRecord = new RowRecord(this.columnLength);
                    fromPK = pkValue = row.get(0);
                    rowRecord.setPk(pkValue);
                    if (!this.isSameRouteMove) {
                        rowRecord.setColumn(0, pkValue);
                        for (int i = 1; i < this.columnLength; ++i) {
                            rowRecord.setColumn(i, row.get(i));
                        }
                    }
                    recordSender.sendToWriter(rowRecord);
                    finalSize.getAndIncrement();
                }
            }
        } while (finalSize.get() >= (this.isSameRouteMove ? XDBManagerConstant.PAGE_SIZE : XDBManagerConstant.CROSS_PAGE_SIZE));
        return false;
    }
}

