/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.disablemove.reader;

import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.taskgroup.Reader;
import kd.bos.xdb.transport.exchanger.RecordSender;
import kd.bos.xdb.transport.record.RowRecord;

public class DisableReader
implements Reader {
    private Configuration configuration;
    private String shardingTable;
    private String pkField;
    private Object lastPk;

    public DisableReader(Configuration configuration, String shardingTable, String pkField, Object lastPk) {
        this.configuration = configuration;
        this.shardingTable = shardingTable;
        this.pkField = pkField;
        this.lastPk = lastPk;
    }

    @Override
    public boolean startRead(RecordSender recordSender) {
        AtomicInteger finalSize;
        DBRoute route = this.configuration.getRoute();
        Object fromPK = this.lastPk;
        do {
            if (ShardTaskRuntime.get().isTaskInterrupted(this.configuration.getMainTable())) {
                return false;
            }
            if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
                return true;
            }
            StringBuilder sql = new StringBuilder(128);
            sql.append("select top ").append(XDBManagerConstant.PAGE_SIZE).append(" ").append(this.pkField);
            sql.append(" from ").append(this.shardingTable);
            Object[] params = null;
            if (fromPK != null) {
                params = new Object[]{fromPK};
                sql.append(" where ").append(this.pkField).append(" > ?");
            }
            sql.append(" order by ").append(this.pkField).append(" asc ");
            String s = ActionUtil.wrapSQL(sql.toString(), false, true);
            finalSize = new AtomicInteger();
            try (DataSet dataSet = DB.queryDataSet((String)"DisableReader", (DBRoute)route, (String)s, (Object[])params);){
                for (Row row : dataSet) {
                    Object pkValue;
                    RowRecord rowRecord = new RowRecord(1);
                    fromPK = pkValue = row.get(0);
                    rowRecord.setPk(pkValue);
                    recordSender.sendToWriter(rowRecord);
                    finalSize.getAndIncrement();
                }
            }
        } while (finalSize.get() >= XDBManagerConstant.PAGE_SIZE);
        return false;
    }
}

