/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.disablemove.work;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.ORM;
import kd.bos.orm.datasync.DtsExcludeSyncContext;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mq.ShardLogPublish;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.MetaFactory;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.SubProgress;
import kd.bos.xdb.task.service.IWork;
import kd.bos.xdb.task.service.disablemove.reader.AdaptiveDisableReader;
import kd.bos.xdb.task.service.disablemove.writer.AdaptiveDisableWriter;
import kd.bos.xdb.taskgroup.TaskGroupExecutor;
import kd.bos.xdb.taskgroup.communication.Communication;
import kd.bos.xdb.taskgroup.enums.State;

public class DisableMoveWorkAdaptive
implements IWork {
    protected ShardProgressEntity progressEntity;
    protected ShardTaskEntity taskEntity;
    protected Configuration configuration;
    protected SubProgress subProgress;

    public DisableMoveWorkAdaptive(ShardProgressEntity progressEntity, ShardTaskEntity taskEntity, Configuration configuration, SubProgress subProgress) {
        this.progressEntity = progressEntity;
        this.taskEntity = taskEntity;
        this.configuration = configuration;
        this.subProgress = subProgress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doWork() throws Exception {
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler DisableMoveWork begin,entitynumber:{0}, tableName:{1}, taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
        if (Thread.currentThread().isInterrupted()) {
            XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler DisableMoveWork interrupted,entitynumber:{0}, tableName:{1}, taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
            return false;
        }
        TableManager tm = XDBConfig.getTableManager();
        try (TXHandle tx = TX.notSupported((String)"DisableMoveWork.doWork");
             DtsExcludeSyncContext context = DtsExcludeSyncContext.create();){
            int c = ShardProgressRepository.get().updateExecuting(this.progressEntity.getId());
            if (c <= 0) {
                XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler DisableMoveWork updateExecuting error,entitynumber:{0}, tableName:{1},taskId:{2}, progressId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                boolean bl = false;
                return bl;
            }
            String tableName = TableName.of((String)this.progressEntity.getShardTable()).getOriginalName();
            List<String> shardingTables = Arrays.asList(tm.getShardingTable(tableName));
            shardingTables.sort((key1, key2) -> {
                long tableName1 = TableName.of((String)key1).getShardingIndex();
                long tableName2 = TableName.of((String)key2).getShardingIndex();
                return (int)(tableName1 - tableName2);
            });
            Object lastPk = null;
            if (this.subProgress.getToPk() != null) {
                lastPk = this.subProgress.getToPk();
                this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DisableDataMoveCallable_2", (String)"Continue to migrate table data {0}, number of shards={1}, shardingTable:{2},fromPK={3}", (Object[])new Object[]{tableName, shardingTables.size(), this.progressEntity.getShardTable(), lastPk}));
            } else {
                this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DisableDataMoveCallable_3", (String)"Migration table data {0}, number of shards={1}", (Object[])new Object[]{tableName, shardingTables.size()}));
            }
            this.subProgress.store();
            ShardingConfig shardingConfig = null;
            for (ShardingConfig sc : this.configuration.getShardingConfigs()) {
                String originalName = TableName.of((String)sc.getTable()).getOriginalName();
                if (!originalName.equals(tableName)) continue;
                shardingConfig = sc;
                break;
            }
            if (shardingConfig != null) {
                String pkField = ShardConfigEntity.isTcTableShardingDBConfig(shardingConfig) ? "FID" : (ShardConfigEntity.isWbTableShardingDBConfig(shardingConfig) ? "FEntryId" : (ShardConfigEntity.isLangTableShardingDBConfig(shardingConfig) ? "fpkid" : (ShardConfigEntity.isPrivacyTableShardingDBConfig(shardingConfig) ? "fpkid" : ORM.create().getDataEntityType(shardingConfig.getName()).getPrimaryKey().getAlias())));
                String shardingTable = this.progressEntity.getShardTable();
                this.subProgress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"DisableDataMoveCallable_4", (String)"Migrate Shard Table Data {0}", (Object[])new Object[]{shardingTable}));
                this.subProgress.setMovingTable(shardingTable);
                this.subProgress.store();
                String columnFields = this.getColumns(pkField);
                AdaptiveDisableReader pkReader = new AdaptiveDisableReader(this.progressEntity, this.configuration, pkField, columnFields, lastPk);
                AdaptiveDisableWriter pkWriter = new AdaptiveDisableWriter(this.progressEntity, this.configuration, pkField, columnFields, this.subProgress);
                boolean isCross = false;
                if (!this.progressEntity.getTargetRoute().equalsIgnoreCase(this.progressEntity.getOriginalRoute())) {
                    pkWriter.setBufferSize(XDBManagerConstant.CROSS_INSERT_PAGE_SIZE);
                    isCross = true;
                }
                Communication runnerCommunication = new Communication();
                TaskGroupExecutor pkGroupExecutor = TaskGroupExecutor.taskGroup(pkWriter, pkReader, this.configuration, runnerCommunication, "MOVE#" + isCross + "#" + this.progressEntity.getShardTable(), isCross);
                pkGroupExecutor.doStart();
                if (runnerCommunication.getState() == State.FAILED) {
                    StringWriter sw = new StringWriter();
                    runnerCommunication.getThrowable().printStackTrace(new PrintWriter(sw));
                    String error = MessageFormat.format("ShardTaskMovingHandler DisableMoveWork stateReturnFailed,entitynumber:{0}, tableName:{1}, taskId:{2}, splitTaskId:{3}, errorinfo:{4}", this.progressEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId(), sw.toString());
                    XDBManagerUtil.logError(error, runnerCommunication.getThrowable());
                    ShardLogPublish.get().publishOperationLog(this.progressEntity.getId(), this.progressEntity.getEntitynumber(), error, "MOVE#" + this.progressEntity.getShardTable());
                    throw ExceptionUtil.asRuntimeException((String)sw.toString(), (Throwable)runnerCommunication.getThrowable());
                }
                if (runnerCommunication.getState() == State.PAUSED) {
                    ShardProgressRepository.get().setProgressSuspended(this.progressEntity.getId());
                    ShardLogPublish.get().publishOperationLog(this.progressEntity.getId(), this.progressEntity.getEntitynumber(), BosRes.get((String)"bos-xdb-manager", (String)"DisableMoveWork_2", (String)"Task paused, tableName: {0}", (Object[])new Object[]{this.progressEntity.getShardTable()}), "MOVE#" + this.progressEntity.getShardTable());
                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler DisableMoveWork paused,entitynumber:{0}, tableName:{1}, taskId:{1}, splitTaskId:{2}", this.progressEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                    boolean bl = true;
                    return bl;
                }
                if (Thread.currentThread().isInterrupted()) {
                    XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler DisableMoveWork interrupted,entitynumber:{0}, tableName:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
                    boolean bl = false;
                    return bl;
                }
                this.subProgress.setProgressDesc_1(BosRes.get((String)"bos-xdb-manager", (String)"DisableDataMoveCallable_5", (String)"Data migration, tableName: {0}, shardingTable: {1}, data migration completed", (Object[])new Object[]{tableName, shardingTable}));
                this.subProgress.setExecSql(null);
                this.subProgress.store();
            }
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String runtimeException = sw.toString();
            XDBManagerUtil.logError(MessageFormat.format("ShardTaskMovingHandler DisableMoveWork error, entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}, errorinfo:{4}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId(), runtimeException), e);
            ShardProgressRepository.get().setProgressFailedByTaskId(this.progressEntity.getId());
            throw ExceptionUtil.asRuntimeException((String)runtimeException, (Throwable)e);
        }
        ShardProgressRepository.get().updateProgressSuccess(this.progressEntity.getId());
        XDBManagerUtil.logInfo(MessageFormat.format("ShardTaskMovingHandler DisableMoveWork end,entitynumber:{0}, shardTable:{1}, taskId:{2}, splitTaskId:{3}", this.taskEntity.getEntitynumber(), this.progressEntity.getShardTable(), this.taskEntity.getId(), this.progressEntity.getId()));
        return false;
    }

    private String getColumns(String pkField) {
        List columnList = MetaFactory.getMeta().queryColumns(this.progressEntity.getOriginalRoute(), this.progressEntity.getShardTable());
        if (columnList.size() == 1 && pkField.equalsIgnoreCase(((Column)columnList.get(0)).getColumnName())) {
            return pkField;
        }
        StringBuilder columnStr = new StringBuilder();
        int n = columnList.size();
        for (int i = 0; i < n; ++i) {
            String columnName = ((Column)columnList.get(i)).getColumnName();
            if (columnName.equalsIgnoreCase(pkField)) {
                if (i != n - 1) continue;
                columnStr.substring(0, columnStr.length() - 1);
                continue;
            }
            columnStr.append(((Column)columnList.get(i)).getColumnName());
            if (i == n - 1) continue;
            columnStr.append(',');
        }
        columnStr.insert(0, pkField + ',');
        return columnStr.toString();
    }
}

