/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.disablemove.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.entity.ITaskEntity;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.IChildProgress;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.taskgroup.WriterAbst;
import kd.bos.xdb.transport.record.RowRecord;

public class AdaptiveDisableWriter
extends WriterAbst {
    private final ShardProgressEntity progressEntity;
    private final DBRoute targetRoute;
    private final boolean isReplace;
    private final String pkField;
    private final String columnFields;
    private final String crossInsertSql;
    private final String originalTableName;
    private final boolean isSameRouteMove;
    private int loop = 0;

    public AdaptiveDisableWriter(ShardProgressEntity progressEntity, Configuration configuration, String pkField, String columnFields, IChildProgress progress) {
        super(configuration, progress);
        this.progressEntity = progressEntity;
        this.targetRoute = DBRoute.of((String)progressEntity.getTargetRoute());
        this.isReplace = DBType.mysql == this.dbType;
        this.pkField = pkField;
        this.originalTableName = TableName.of((String)progressEntity.getShardTable()).getOriginalName();
        this.columnFields = columnFields;
        this.isSameRouteMove = progressEntity.getTargetRoute().equalsIgnoreCase(progressEntity.getOriginalRoute());
        this.crossInsertSql = ActionUtil.wrapSQL(this.getCrossInsertSql(columnFields), true, true);
    }

    @Override
    public void doBatchInsert(List<RowRecord> writerBuffer) {
        Object fromPK = writerBuffer.get(0).getPk();
        Object toPK = writerBuffer.get(writerBuffer.size() - 1).getPk();
        int bufferSize = writerBuffer.size();
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        if (!this.isReplace && this.progress.isNeedDel()) {
            sql.setLength(0);
            sql.append("select ").append(this.pkField).append(" from ").append(this.originalTableName).append(" where ").append(this.pkField).append(" >=? and ").append(this.pkField).append(" <=?");
            List existsList = (List)DB.query((DBRoute)this.targetRoute, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{fromPK, toPK}, rs -> {
                ArrayList<Object> dataList = new ArrayList<Object>(10);
                while (rs.next()) {
                    dataList.add(rs.getObject(1));
                }
                return dataList;
            });
            if (existsList.size() > 0) {
                sql.setLength(0);
                sql.append("delete from ").append(this.originalTableName).append(" where ").append(this.pkField).append(" >= ? and ").append(this.pkField).append("<=?");
                DB.execute((DBRoute)this.targetRoute, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{fromPK, toPK});
                this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"ArchiveMoveWriter_3", (String)"Sharding unenable(archive migration) exception recovery and clearing of exception data, targetRoute: {0}, shardingTable: {1}, fromPK={2}, toPK={3}, size={4}", (Object[])new Object[]{this.progressEntity.getTargetRoute(), this.progressEntity.getShardTable(), fromPK, toPK, bufferSize}));
                this.progress.setExecSql(sql.toString());
                this.progress.store();
            }
        }
        this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"ArchiveMoveWriter_4", (String)"Sharding unenable(archive migration),targetRoute:{0},shardingTable:{1},fromPK={2},toPK={3},size={4}", (Object[])new Object[]{this.progressEntity.getTargetRoute(), this.progressEntity.getShardTable(), fromPK, toPK, bufferSize}));
        this.progress.store();
        if (this.isSameRouteMove) {
            sql.setLength(0);
            if (DBType.mysql == this.dbType) {
                sql.append("replace ");
            } else {
                sql.append("insert ");
            }
            sql.append(" into ").append(this.originalTableName);
            sql.append(" (").append(this.columnFields).append(") ");
            sql.append(" select ").append(this.columnFields).append(" from ").append(this.progressEntity.getShardTable()).append(" where ").append(this.pkField).append(">=? and ").append(this.pkField).append("<=?");
            DB.execute((DBRoute)this.targetRoute, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{fromPK, toPK});
        } else {
            List fieldValuesList = writerBuffer.stream().map(RowRecord::getColumns).collect(Collectors.toList());
            DB.executeBatch((DBRoute)this.targetRoute, (String)this.crossInsertSql, fieldValuesList);
        }
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        this.progress.setToPk(toPK);
        ProgressUtil.incrMoveRecordAndStore((ITaskEntity)this.progressEntity, this.progressEntity.getShardTable(), (long)bufferSize, this.progress);
    }

    private String getCrossInsertSql(String fieldsString) {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        if (this.isReplace) {
            sql.append("replace into ").append(this.originalTableName);
        } else {
            sql.append("insert into ").append(this.originalTableName);
        }
        sql.append(" (").append(fieldsString).append(") values (");
        int n = fieldsString.split(",").length;
        for (int i = 0; i < n; ++i) {
            sql.append("?");
            if (i == n - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return sql.toString();
    }
}

