/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.enablemove.reader;

import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.ShardTaskRuntime;
import kd.bos.orm.ORM;
import kd.bos.xdb.XDBManagerConstant;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.taskgroup.Reader;
import kd.bos.xdb.transport.exchanger.RecordSender;
import kd.bos.xdb.transport.record.RowRecord;

public class DataMoveReader
implements Reader {
    private Configuration configuration;
    private ShardProgressEntity progressEntity;
    private Object lastPk;

    public DataMoveReader(ShardProgressEntity progressEntity, Configuration configuration, Object lastPk) {
        this.progressEntity = progressEntity;
        this.configuration = configuration;
        this.lastPk = lastPk;
    }

    @Override
    public boolean startRead(RecordSender recordSender) {
        AtomicInteger finalSize;
        String mainTable = this.configuration.getMainTable();
        TableName mainTN = TableName.of((String)mainTable);
        DBRoute route = this.configuration.getRoute();
        IDataEntityType mainDT = ORM.create().getDataEntityType(this.configuration.getMainShardingConfig().getName());
        String pkField = "fid";
        long shardingIndex = this.progressEntity.getShardIndex();
        String movingTable = mainTN.getMovingTable(shardingIndex);
        Object fromPK = this.lastPk;
        do {
            if (ShardTaskRuntime.get().isTaskInterrupted(this.configuration.getMainTable())) {
                return false;
            }
            if (ShardTaskRuntime.get().isTaskPaused(this.configuration.getMainTable())) {
                return true;
            }
            StringBuilder sql = new StringBuilder(128);
            sql.append("select top ").append(XDBManagerConstant.PAGE_SIZE).append(" ").append(pkField);
            sql.append(" from ").append(movingTable);
            Object[] params = null;
            if (fromPK != null) {
                params = new Object[]{fromPK};
                sql.append(" where ").append(pkField).append(" > ?");
            }
            sql.append(" order by ").append(pkField).append(" asc ");
            String s = ActionUtil.wrapSQL(sql.toString(), false, true);
            finalSize = new AtomicInteger();
            try (DataSet dataSet = DB.queryDataSet((String)"DataMoveReader", (DBRoute)route, (String)s, (Object[])params);){
                for (Row row : dataSet) {
                    Object pkValue;
                    RowRecord rowRecord = new RowRecord(1);
                    fromPK = pkValue = row.get(0);
                    rowRecord.setPk(pkValue);
                    recordSender.sendToWriter(rowRecord);
                    finalSize.getAndIncrement();
                }
            }
        } while (finalSize.get() >= XDBManagerConstant.PAGE_SIZE);
        return false;
    }
}

