/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.task.service.indexmove.writer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import kd.bos.bundle.BosRes;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.entity.ITaskEntity;
import kd.bos.xdb.entity.ShardProgressEntity;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.sharding.config.IndexDefine;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.task.progress.IChildProgress;
import kd.bos.xdb.task.progress.ProgressUtil;
import kd.bos.xdb.taskgroup.WriterAbst;
import kd.bos.xdb.transport.record.RowRecord;

public class IndexMoveWriter
extends WriterAbst {
    private ShardProgressEntity progressEntity;
    private ShardingConfig mainShardingConfig;
    private DBRoute route;
    private boolean useIndexPK;
    private TableName mainTN;
    private long shardingIndex;
    private String shardTable;
    private Object fromPK;
    private Object toPK;
    private int bufferSize;
    private int loop = 0;

    public IndexMoveWriter(ShardProgressEntity progressEntity, Configuration configuration, IChildProgress progress) {
        super(configuration, progress);
        this.progressEntity = progressEntity;
        this.mainShardingConfig = configuration.getMainShardingConfig();
        this.useIndexPK = this.mainShardingConfig.isIndexPK();
        this.mainTN = TableName.of((String)configuration.getMainTable());
        this.route = configuration.getRoute();
        this.shardTable = progressEntity.getShardTable();
        this.shardingIndex = progressEntity.getShardIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBatchInsert(List<RowRecord> writerBuffer) throws Exception {
        String pkField = this.configuration.getRootDT().getPrimaryKey().getAlias().toLowerCase();
        this.fromPK = writerBuffer.get(0).getPk();
        this.toPK = writerBuffer.get(writerBuffer.size() - 1).getPk();
        this.bufferSize = writerBuffer.size();
        StringBuilder sql = new StringBuilder();
        if (this.useIndexPK) {
            String pkTempTable = this.mainTN.getPKTempTable();
            if (DBType.mysql != this.dbType && this.progress.isNeedDel()) {
                sql.setLength(0);
                sql.append("delete from ").append(pkTempTable).append(" where findex=? and fpk>=? and fpk<=?");
                Semaphore sp = this.progress.getParentSp().getDeletePKSemaphore();
                sp.acquire();
                try {
                    DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.shardingIndex, this.fromPK, this.toPK});
                }
                finally {
                    sp.release();
                }
                this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"IndexMoveWriter_0", (String)"subtable index data migration is abnormally restored and the abnormal data is cleared, shardTable:{0},fromPK={1},toPK={2},size={3}", (Object[])new Object[]{this.progressEntity.getShardTable(), this.fromPK, this.toPK, this.bufferSize}));
                this.progress.setExecSql(sql.toString());
                this.progress.store();
            }
            sql.setLength(0);
            Set<IndexDefine> fastIndexDefineSet = this.configuration.getFastIndexDefineSet();
            IndexDefine[] defs = fastIndexDefineSet.toArray(new IndexDefine[fastIndexDefineSet.size()]);
            if (defs == null || defs.length == 0) {
                sql.append(DBType.mysql == this.dbType ? "replace " : "insert ");
                sql.append(" into ").append(pkTempTable).append("(fpk,findex) select FID,").append(this.shardingIndex).append(" from ").append(this.shardTable).append(" where FID >=? and FID<=? ");
            } else {
                Character alias;
                HashMap<String, Character> joinTableAliasMap = new HashMap<String, Character>();
                for (IndexDefine def : defs) {
                    alias = (Character)joinTableAliasMap.get(def.getTable());
                    if (alias != null) continue;
                    alias = Character.valueOf((char)(66 + joinTableAliasMap.size()));
                    joinTableAliasMap.put(def.getTable(), alias);
                }
                joinTableAliasMap.remove(this.mainShardingConfig.getTable());
                sql.append(DBType.mysql == this.dbType ? "replace " : "insert ");
                sql.append(" into ").append(pkTempTable).append("(fpk,findex");
                for (IndexDefine def : defs) {
                    sql.append(',').append(def.getField());
                }
                sql.append(") select A.FID,").append(this.shardingIndex);
                for (IndexDefine def : defs) {
                    alias = (Character)joinTableAliasMap.get(def.getTable());
                    sql.append(',').append(alias != null ? (char)alias.charValue() : (char)'A').append('.').append(def.getField());
                }
                sql.append(" from ").append(this.shardTable).append(" A");
                for (Map.Entry entry : joinTableAliasMap.entrySet()) {
                    sql.append(" inner join ").append(TableName.of((String)((String)entry.getKey())).getShardingTable(this.shardingIndex)).append(' ').append(entry.getValue()).append(" on A.FID=").append(entry.getValue()).append('.').append(pkField);
                }
                sql.append(" where A.FID >=? and A.FID<=? ");
            }
            this.progress.setProgressDesc_2(BosRes.get((String)"bos-xdb-manager", (String)"IndexMoveWriter_1", (String)"Sharded subtable index data migration, shardTable:{0},fromPK={1},toPK={2},size={3}", (Object[])new Object[]{this.progressEntity.getShardTable(), this.fromPK, this.toPK, this.bufferSize}));
            this.progress.setExecSql(sql.toString());
            DB.execute((DBRoute)this.route, (String)ActionUtil.wrapSQL(sql.toString(), true, true), (Object[])new Object[]{this.fromPK, this.toPK});
            this.progress.store();
        }
        if (this.progress.isNeedDel()) {
            ++this.loop;
            if (this.loop > 3) {
                this.progress.setNeedDel(false);
            }
        }
        this.progress.setToPk(this.toPK);
        this.progress.setExecSql(null);
        ProgressUtil.incrMoveRecordAndStore((ITaskEntity)this.progressEntity, this.shardingIndex, (long)this.bufferSize, this.progress);
    }
}

