/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.taskgroup;

import kd.bos.xdb.task.config.Configuration;
import kd.bos.xdb.taskgroup.Reader;
import kd.bos.xdb.taskgroup.Writer;
import kd.bos.xdb.taskgroup.communication.Communication;
import kd.bos.xdb.taskgroup.enums.State;
import kd.bos.xdb.taskgroup.runner.ReaderRunner;
import kd.bos.xdb.taskgroup.runner.WriterRunner;
import kd.bos.xdb.transport.channel.Channel;
import kd.bos.xdb.transport.channel.memory.MemoryChannel;
import kd.bos.xdb.transport.exchanger.BufferdRecordExchanger;
import kd.bos.xdb.util.Threads;

public class TaskGroupExecutor {
    private Configuration taskConfig;
    private String taskGroupMark;
    private Channel channel;
    private Thread threadWriter;
    private Thread threadReader;
    private WriterRunner writerRunner;
    private ReaderRunner readerRunner;
    private Communication taskCommunication;

    public static TaskGroupExecutor taskGroup(Writer writer, Reader reader, Configuration configuration, Communication communication, String taskGroupMark) {
        return new TaskGroupExecutor(writer, reader, configuration, communication, taskGroupMark, false);
    }

    public static TaskGroupExecutor taskGroup(Writer writer, Reader reader, Configuration configuration, Communication communication, String taskGroupMark, boolean isCross) {
        return new TaskGroupExecutor(writer, reader, configuration, communication, taskGroupMark, isCross);
    }

    public TaskGroupExecutor(Writer writer, Reader reader, Configuration configuration, Communication communication, String taskGroupMark, boolean isCross) {
        this.writerRunner = new WriterRunner(writer, configuration.getRoute());
        this.readerRunner = new ReaderRunner(reader, configuration.getRoute());
        this.taskConfig = configuration;
        this.taskCommunication = communication;
        this.taskGroupMark = taskGroupMark;
        this.channel = new MemoryChannel(isCross);
        BufferdRecordExchanger recordSender = new BufferdRecordExchanger(this.channel, isCross);
        this.readerRunner.setRecordSender(recordSender);
        this.readerRunner.setRunnerCommunication(this.taskCommunication);
        this.readerRunner.setTaskId(this.taskConfig.getTaskEntity().getId());
        BufferdRecordExchanger recordReceiver = new BufferdRecordExchanger(this.channel, isCross);
        this.writerRunner.setRecordReceiver(recordReceiver);
        this.writerRunner.setRunnerCommunication(this.taskCommunication);
        this.writerRunner.setTaskId(this.taskConfig.getTaskEntity().getId());
        this.threadWriter = new Thread(Threads.wrapRunnable((Runnable)this.writerRunner), String.format("xdb-writer-%s-%d", this.taskGroupMark, this.writerRunner.getTaskId()));
        this.threadReader = new Thread(Threads.wrapRunnable((Runnable)this.readerRunner), String.format("xdb-reader-%s-%d", this.taskGroupMark, this.readerRunner.getTaskId()));
    }

    public void doStart() throws InterruptedException {
        this.threadWriter.start();
        if (!this.threadWriter.isAlive() || this.taskCommunication.getState() == State.FAILED) {
            throw new RuntimeException(this.taskCommunication.getThrowable());
        }
        this.threadReader.start();
        if (!this.threadReader.isAlive() || this.taskCommunication.getState() == State.FAILED) {
            throw new RuntimeException(this.taskCommunication.getThrowable());
        }
        while (!this.taskCommunication.isFinished()) {
            Thread.sleep(2000L);
        }
        if (this.taskCommunication.isFailed()) {
            if (this.threadReader.isAlive()) {
                this.threadReader.interrupt();
            }
            if (this.threadWriter.isAlive()) {
                this.threadWriter.interrupt();
            }
        }
    }
}

