/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.taskgroup.runner;

import kd.bos.xdb.taskgroup.communication.Communication;
import kd.bos.xdb.taskgroup.enums.State;

public abstract class AbstractRunner {
    private long taskId;
    private Communication runnerCommunication;

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    public Communication getRunnerCommunication() {
        return this.runnerCommunication;
    }

    public void setRunnerCommunication(Communication runnerCommunication) {
        this.runnerCommunication = runnerCommunication;
    }

    public void mark(State state) {
        this.runnerCommunication.setState(state);
    }

    public void markSuccsess() {
        this.mark(State.SUCCEEDED);
    }

    public void markPaused() {
        this.mark(State.PAUSED);
    }

    public void markFailed(Throwable throwable) {
        if (State.FAILED != this.runnerCommunication.getState()) {
            this.mark(State.FAILED);
            this.runnerCommunication.setThrowable(throwable);
            this.runnerCommunication.setTimestamp(System.currentTimeMillis());
        }
    }

    protected abstract void shutDown();
}

