/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.taskgroup.runner;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.sharding.tablerw.DBAnyRWContext;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.taskgroup.Reader;
import kd.bos.xdb.taskgroup.runner.AbstractRunner;
import kd.bos.xdb.transport.exchanger.RecordSender;

public class ReaderRunner
extends AbstractRunner
implements Runnable {
    private DBRoute route;
    private Reader taskReader;
    private RecordSender recordSender;

    public ReaderRunner(Reader reader, DBRoute route) {
        this.taskReader = reader;
        this.route = route;
    }

    public void setRecordSender(RecordSender recordSender) {
        this.recordSender = recordSender;
    }

    @Override
    public void run() {
        try (XDBExternal xdbe = XDBExternal.notSupportedAlways((String)"xdb.ReaderRunner");
             Cache cc = CacheContext.get().createExecutorCache();
             DBAnyRWContext dbAnyRWContextctx = DBShardingRuntime.get().setupThreadDBAnyRWContext();
             ShardingContext ctx = ShardingContext.create();){
            ctx.setStatementType(StatementType.insert);
            boolean isPaused = (Boolean)DB.__call((boolean)true, () -> (Boolean)DB.__setupExtContextForUsingXdbTableManager((DBRoute)this.route, (boolean)false, () -> this.taskReader.startRead(this.recordSender)));
            if (isPaused) {
                this.recordSender.pause();
            } else {
                this.recordSender.terminate();
            }
        }
        catch (Throwable e) {
            super.markFailed(e);
        }
    }

    @Override
    protected void shutDown() {
        this.recordSender.shutDown();
    }
}

