/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.xpm.clean.CleanExecutor;
import kd.bos.xdb.xpm.config.XpmConfig;

public final class MetricCleanService
implements Runnable,
XDBLogable {
    private List<RequestContext> requestContextList;
    private static ExecutorService es = ThreadPools.newCachedExecutorService((String)"XDB-XPM-MetricClean-ES", (int)4, (int)4);

    public MetricCleanService(List<RequestContext> rcList) {
        this.requestContextList = new ArrayList<RequestContext>(rcList);
    }

    public static void start(List<RequestContext> rcList) {
        Thread thread = new Thread((Runnable)new MetricCleanService(rcList), "XDB-XPM-MetricCleanService");
        thread.setDaemon(true);
        thread.start();
    }

    public static void stop() {
        if (es != null) {
            es.shutdown();
        }
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                this.minutesSleep(XpmConfig.getCleanInterval());
                if (!XpmConfig.isEnableMetricClean()) continue;
                for (RequestContext requestContext : this.requestContextList) {
                    RequestContext.copyAndSet((RequestContext)requestContext);
                    es.submit(ThreadLifeCycleManager.wrapRunnable(() -> {
                        Thread.currentThread().setName("XDB-XPM-MetricClean-" + requestContext.getAccountId());
                        CleanExecutor.clean();
                        ThreadLocals.release();
                    }));
                }
            }
            catch (Exception e) {
                log.error("MetricClean thread clean error" + e.getMessage(), (Throwable)e);
                break;
            }
        }
    }

    private void minutesSleep(int cleanInterval) {
        try {
            TimeUnit.MINUTES.sleep(cleanInterval);
        }
        catch (InterruptedException e) {
            log.error("MetricClean thread sleep interval error" + e.getMessage(), (Throwable)e);
        }
    }
}

