/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.xpm.clean;

import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.xpm.config.XpmConfig;

public class OpLogClean
implements XDBLogable {
    private static final String countSql = "select count(1) from t_cbs_shard_log";
    private static final String topRemainIdSql = "select top 1,%s fid from t_cbs_shard_log order by fid desc";
    private static final String cleanSql = "delete from t_cbs_shard_log where fid <= ?";

    public static long count() {
        try {
            Long ret = (Long)DB.__setupExtContextForUsingXdbTableManager((DBRoute)DBRoute.basedata, (boolean)false, () -> {
                Long count = (Long)DB.query((DBRoute)DBRoute.basedata, (String)countSql, rs -> {
                    if (rs.next()) {
                        return rs.getLong(1);
                    }
                    return 0L;
                });
                return count;
            });
            return ret;
        }
        catch (Exception e) {
            log.error("OpLogClean count error:" + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public static void clean() {
        try {
            DB.__setupExtContextForUsingXdbTableManager((DBRoute)DBRoute.basedata, (boolean)false, () -> {
                Long fid = (Long)DB.query((DBRoute)DBRoute.basedata, (String)String.format(topRemainIdSql, XpmConfig.getTopRemain()), rs -> {
                    if (rs.next()) {
                        return rs.getLong(1);
                    }
                    return null;
                });
                if (fid != null) {
                    DB.execute((DBRoute)DBRoute.basedata, (String)cleanSql, (Object[])new Object[]{fid});
                }
                return null;
            });
        }
        catch (Exception e) {
            log.error("OpLogClean clean error:" + e.getMessage(), (Throwable)e);
        }
    }
}

