/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.common.exception;

import kd.bos.mservice.common.exception.RpcErrorCode;

public class RpcException
extends RuntimeException {
    private String errorMessage;

    public RpcException(String errorMessage) {
        super(errorMessage);
        this.errorMessage = errorMessage;
    }

    public RpcException(Throwable cause) {
        super(cause);
    }

    public RpcException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static class RpcTimeoutException
    extends RpcClientException {
        private int errorCode = RpcErrorCode.providerTimeOut.getCode();
        private String timeout;
        private String costTime;
        private String remoteIp;
        private String errorMessage;

        public RpcTimeoutException(String errorMessage) {
            super(errorMessage);
            this.errorMessage = errorMessage;
        }

        public RpcTimeoutException(String remoteIp, Throwable cause) {
            super(cause);
            this.remoteIp = remoteIp;
        }

        public RpcTimeoutException(String remoteIp, String timeout, Throwable cause) {
            super(cause);
            this.timeout = timeout;
            this.remoteIp = remoteIp;
        }

        public RpcTimeoutException(int errorCode, String remoteIp, String costTime, String timeout, Throwable cause) {
            super(cause);
            this.errorCode = errorCode;
            this.timeout = timeout;
            this.costTime = costTime;
            this.remoteIp = remoteIp;
        }

        public RpcTimeoutException(String remoteIp, String timeout, String errorMessage, Throwable cause) {
            super(errorMessage, cause);
            this.timeout = timeout;
            this.remoteIp = remoteIp;
            this.errorMessage = errorMessage;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public String getTimeout() {
            return this.timeout;
        }

        public void setTimeout(String timeout) {
            this.timeout = timeout;
        }

        public String getCostTime() {
            return this.costTime;
        }

        public void setCostTime(String costTime) {
            this.costTime = costTime;
        }

        public String getRemoteIp() {
            return this.remoteIp;
        }

        public void setRemoteIp(String remoteIp) {
            this.remoteIp = remoteIp;
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public void setErrorMessage(String errorMessage) {
            super.setErrorMessage(errorMessage);
            this.errorMessage = errorMessage;
        }
    }

    public static class RpcServiceUnavailableException
    extends RpcClientException {
        private int errorCode = RpcErrorCode.consumerInvokerNotFound.getCode();
        private String errorMessage;

        public RpcServiceUnavailableException(String errorMessage) {
            super(errorMessage);
            this.errorMessage = errorMessage;
        }

        public RpcServiceUnavailableException(Throwable cause) {
            super(cause);
        }

        public RpcServiceUnavailableException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public void setErrorMessage(String errorMessage) {
            super.setErrorMessage(errorMessage);
            this.errorMessage = errorMessage;
        }
    }

    public static class RpcServerException
    extends RpcException {
        public RpcServerException(String errorMessage) {
            super(errorMessage);
        }

        public RpcServerException(Throwable cause) {
            super(cause);
        }

        public RpcServerException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }

    public static class RpcClientException
    extends RpcException {
        public RpcClientException(String errorMessage) {
            super(errorMessage);
        }

        public RpcClientException(Throwable cause) {
            super(cause);
        }

        public RpcClientException(String errorMessage, Throwable cause) {
            super(errorMessage, cause);
        }
    }
}

