/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.common.rpc;

import kd.bos.mservice.common.AppIdNameMapping;
import kd.bos.mservice.common.rpc.FeignRequsetParam;
import kd.bos.mservice.common.rpc.appgroup.AppGroupStrategy;
import kd.bos.mservice.sdk.extension.SdkExtensionFactory;
import kd.bos.mservice.sdk.instance.KdInstance;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;

public class RegisterAppNameUtils {
    public static final String APP_PREFIX = "KDMSERVICE";
    public static final String REQUESTAPPID = "feign.request.appid";
    public static final String REQUESTAPPID_ORIGINAL = "feign.request.appid.original";
    public static final String REQUESTAPPID_FEIGNREQUSETPARAM = "feign.request.feignparams";
    public static final String REQUEST_HOST = "feign.request.host";
    public static final String REQUEST_CODECTYPE = "mservice.request.codectype";
    private static final String LOOKUPAPPIDNAMEMAPPINGEXTEND = System.getProperty("lookupAppIdNameMappingExtend", "tianshu");
    private static final boolean isRegisterWithAppName = Boolean.getBoolean("mservice.feign.register.withappname");
    private static final SdkExtensionFactory<AppGroupStrategy> lookupFactory = SdkExtensionFactory.getExtensionFacotry(AppGroupStrategy.class);
    private static final SdkExtensionFactory<AppIdNameMapping> lookupAppNameFactory = SdkExtensionFactory.getExtensionFacotry(AppIdNameMapping.class);

    public static boolean isRegisterWithAppName() {
        return isRegisterWithAppName;
    }

    public static String getRegisterAppName(String appId, String interfaceName) {
        if (isRegisterWithAppName) {
            return KdInstance.getAppName();
        }
        String groupName = "defaultGroup";
        if (lookupFactory.existsExtension("gray")) {
            groupName = ((AppGroupStrategy)lookupFactory.getExtension("gray")).getRegisterAppName(appId);
        }
        groupName = "defaultGroup".equals(groupName) ? "" : "-" + groupName;
        return RegisterAppNameUtils.getRegisterInterfaceName(appId == null ? interfaceName : appId.replaceAll("_", "") + "." + interfaceName) + groupName;
    }

    public static String getGroupName(String appId) {
        String groupName = "defaultGroup";
        if (lookupFactory.existsExtension("gray")) {
            groupName = ((AppGroupStrategy)lookupFactory.getExtension("gray")).getAppGroup(appId);
        }
        return groupName;
    }

    public static String getLookupAppName(String appId) {
        String interfaceName = RegisterAppNameUtils.getRequestFeignParam().getInterfaceName();
        return RegisterAppNameUtils.getLookupAppName(appId, interfaceName);
    }

    public static String getLookupAppName(String appId, String interfaceName) {
        if (isRegisterWithAppName) {
            String rappName = null;
            if (lookupAppNameFactory.existsExtension(LOOKUPAPPIDNAMEMAPPINGEXTEND)) {
                rappName = ((AppIdNameMapping)lookupAppNameFactory.getExtension(LOOKUPAPPIDNAMEMAPPINGEXTEND)).getAppNameById(appId);
            }
            return rappName == null ? appId : rappName;
        }
        String groupName = RegisterAppNameUtils.getGroupName(appId);
        groupName = "defaultGroup".equals(groupName) ? "" : "-" + groupName;
        return RegisterAppNameUtils.getRegisterInterfaceName(appId.replaceAll("_", "") + "." + interfaceName) + groupName;
    }

    public static String getRegisterInterfaceName(String interfaceName) {
        if (isRegisterWithAppName) {
            String rappName = null;
            if (lookupAppNameFactory.existsExtension(LOOKUPAPPIDNAMEMAPPINGEXTEND)) {
                rappName = ((AppIdNameMapping)lookupAppNameFactory.getExtension(LOOKUPAPPIDNAMEMAPPINGEXTEND)).getAnyAppName();
            }
            return rappName == null ? KdInstance.getAppName() : rappName;
        }
        return KdInstance.getClusterName().replaceAll("_", "") + "-" + interfaceName;
    }

    public static String getRequestAppID() {
        return (String)InnerThreadTruck.get((Object)REQUESTAPPID);
    }

    public static void setRequestAppID(String appid) {
        if (appid != null) {
            InnerThreadTruck.put((Object)REQUESTAPPID, (Object)appid.toUpperCase());
            InnerThreadTruck.put((Object)REQUESTAPPID_ORIGINAL, (Object)appid);
        }
    }

    public static String getOriginaRequestAppID() {
        return (String)InnerThreadTruck.get((Object)REQUESTAPPID_ORIGINAL);
    }

    public static String getRequestHost() {
        return (String)InnerThreadTruck.get((Object)REQUEST_HOST);
    }

    public static void setRequestHost(String host) {
        if (host != null) {
            InnerThreadTruck.put((Object)REQUEST_HOST, (Object)host);
        }
    }

    public static void removeRequestAppID() {
        InnerThreadTruck.remove((Object)REQUESTAPPID);
        InnerThreadTruck.remove((Object)REQUESTAPPID_ORIGINAL);
    }

    public static void removeRequestHost() {
        InnerThreadTruck.remove((Object)REQUEST_HOST);
    }

    public static FeignRequsetParam getRequestFeignParam() {
        return (FeignRequsetParam)InnerThreadTruck.get((Object)REQUESTAPPID_FEIGNREQUSETPARAM);
    }

    public static void setRequestFeignParam(FeignRequsetParam fparam) {
        InnerThreadTruck.put((Object)REQUESTAPPID_FEIGNREQUSETPARAM, (Object)fparam);
    }

    public static void removeRequestFeignParam() {
        InnerThreadTruck.remove((Object)REQUESTAPPID_FEIGNREQUSETPARAM);
    }

    public static String getRequestCodecType() {
        return (String)InnerThreadTruck.get((Object)REQUEST_CODECTYPE);
    }

    public static void setRequestCodecType(String fparam) {
        InnerThreadTruck.put((Object)REQUEST_CODECTYPE, (Object)fparam);
    }

    public static void removeRequestCodecType() {
        InnerThreadTruck.remove((Object)REQUEST_CODECTYPE);
    }

    public static void clearAll() {
        RegisterAppNameUtils.removeRequestAppID();
        RegisterAppNameUtils.removeRequestHost();
        RegisterAppNameUtils.removeRequestFeignParam();
        RegisterAppNameUtils.removeRequestCodecType();
    }
}

