/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.sdk.extension;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.mservice.sdk.extension.Activate;
import kd.bos.mservice.sdk.extension.ConcurrentHashSet;
import kd.bos.mservice.sdk.extension.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkExtensionFactory<T> {
    private static final Logger log = LoggerFactory.getLogger(SdkExtensionFactory.class);
    private static final String EXTENSION_DIRECTORY = "META-INF/kd/bos/extension/";
    private static final ConcurrentMap<Class<?>, SdkExtensionFactory<?>> EXTENSION_FACTORYS = new ConcurrentHashMap();
    private Class<?> type;
    private final Holder<Map<String, Class<?>>> cachedClasses = new Holder();
    private final ConcurrentMap<String, Holder<Object>> cachedInstances = new ConcurrentHashMap<String, Holder<Object>>();
    private static final ConcurrentMap<Class<?>, Object> EXTENSION_INSTANCES = new ConcurrentHashMap();
    private Set<Class<?>> cachedWrapperClasses;
    private final Map<String, Activate> cachedActivates = new ConcurrentHashMap<String, Activate>();
    private static final Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");

    private SdkExtensionFactory() {
    }

    private SdkExtensionFactory(Class<?> type) {
        this.type = type;
    }

    public static <T> SdkExtensionFactory<T> getExtensionFacotry(Class<T> type) {
        SdkExtensionFactory factory = (SdkExtensionFactory)EXTENSION_FACTORYS.get(type);
        if (factory == null) {
            EXTENSION_FACTORYS.putIfAbsent(type, new SdkExtensionFactory<T>(type));
            factory = (SdkExtensionFactory)EXTENSION_FACTORYS.get(type);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getExtension(String name) {
        Object instance;
        Holder holder = (Holder)this.cachedInstances.get(name);
        if (holder == null) {
            this.cachedInstances.putIfAbsent(name, new Holder());
            holder = (Holder)this.cachedInstances.get(name);
        }
        if ((instance = holder.get()) == null) {
            Holder holder2 = holder;
            synchronized (holder2) {
                instance = holder.get();
                if (instance == null) {
                    instance = this.createExtension(name);
                    holder.set(instance);
                }
            }
        }
        if (holder != null) {
            return holder.get();
        }
        return null;
    }

    public T getExtension(String name, boolean fromCache) {
        if (fromCache) {
            return this.getExtension(name);
        }
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new RuntimeException("can't find class for name " + name);
        }
        try {
            return (T)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    public boolean existsExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        return clazz != null;
    }

    private T createExtension(String name) {
        Class<?> clazz = this.getExtensionClasses().get(name);
        if (clazz == null) {
            throw new RuntimeException("can't find class for extention " + this.type.getName() + "/" + name);
        }
        try {
            Set<Class<?>> wrapperClasses;
            Object instance = EXTENSION_INSTANCES.get(clazz);
            if (instance == null) {
                EXTENSION_INSTANCES.putIfAbsent(clazz, clazz.newInstance());
                instance = EXTENSION_INSTANCES.get(clazz);
            }
            if ((wrapperClasses = this.cachedWrapperClasses) != null && wrapperClasses.size() > 0) {
                for (Class<?> wrapperClass : wrapperClasses) {
                    instance = wrapperClass.getConstructor(this.type).newInstance(instance);
                }
            }
            return (T)instance;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Extension instance(name: " + name + ", class: " + this.type + ")  could not be instantiated: " + t.getMessage(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> getExtensionClasses() {
        Map<String, Class<?>> classes = this.cachedClasses.get();
        if (classes == null) {
            Holder<Map<String, Class<?>>> holder = this.cachedClasses;
            synchronized (holder) {
                classes = this.cachedClasses.get();
                if (classes == null) {
                    classes = this.loadExtensionClasses();
                    this.cachedClasses.set(classes);
                }
            }
        }
        return classes;
    }

    private Map<String, Class<?>> loadExtensionClasses() {
        HashMap extensionClasses = new HashMap();
        this.loadFile(extensionClasses, EXTENSION_DIRECTORY);
        return extensionClasses;
    }

    private static ClassLoader findClassLoader() {
        return SdkExtensionFactory.class.getClassLoader();
    }

    private void loadFile(Map<String, Class<?>> extensionClasses, String dir) {
        block23: {
            String fileName = dir + this.type.getName();
            try {
                ClassLoader classLoader = SdkExtensionFactory.findClassLoader();
                Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
                if (urls == null) break block23;
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    log.info("load extension class from " + url);
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                        Throwable throwable = null;
                        try {
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                int ci = line.indexOf(35);
                                if (ci >= 0 || (line = line.trim()).length() <= 0) continue;
                                String name = null;
                                int i = line.indexOf(61);
                                if (i > 0) {
                                    name = line.substring(0, i).trim();
                                    line = line.substring(i + 1).trim();
                                }
                                if (line.length() <= 0) continue;
                                Class<?> clazz = Class.forName(line, true, classLoader);
                                if (name == null || "".equals(name)) {
                                    name = line.substring(line.lastIndexOf(".") + 1);
                                }
                                try {
                                    clazz.getConstructor(this.type);
                                    Set<Class<?>> wrappers = this.cachedWrapperClasses;
                                    if (wrappers == null) {
                                        this.cachedWrapperClasses = new ConcurrentHashSet();
                                        wrappers = this.cachedWrapperClasses;
                                    }
                                    wrappers.add(clazz);
                                }
                                catch (NoSuchMethodException e) {
                                    Class<?> c;
                                    Activate activate = clazz.getAnnotation(Activate.class);
                                    if (activate != null) {
                                        this.cachedActivates.put(name, activate);
                                    }
                                    if ((c = extensionClasses.get(name)) == null) {
                                        extensionClasses.put(name, clazz);
                                        continue;
                                    }
                                    if (c == clazz) continue;
                                    throw new IllegalStateException("Duplicate extension " + this.type.getName() + " name " + name + " on " + c.getName() + " and " + clazz.getName(), e);
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable t) {
                        log.error("Exception when load extension class(interface: " + this.type + ", class file: " + url + ") in " + url + ", message:" + t.getMessage(), t);
                    }
                }
            }
            catch (Throwable t) {
                log.error("Exception when load extension class(interface: " + this.type + ", description file: " + fileName + ").", t);
            }
        }
    }

    public List<T> getActivateExtension() {
        return this.getActivateExtension(null, null);
    }

    public List<T> getActivateExtension(Map<String, String> parameter, String group) {
        ArrayList activateExtensions = new ArrayList(4);
        this.getExtensionClasses();
        this.cachedActivates.forEach((k, v) -> {
            if (this.isMatchGroup(group, v.group()) && this.isActive((Activate)v, parameter)) {
                T ext = this.getExtension((String)k);
                activateExtensions.add(ext);
            }
        });
        activateExtensions.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            Activate a1 = o1.getClass().getAnnotation(Activate.class);
            Activate a2 = o2.getClass().getAnnotation(Activate.class);
            int n1 = a1 == null ? 0 : a1.order();
            int n2 = a2 == null ? 0 : a2.order();
            return n1 > n2 ? 1 : -1;
        });
        return activateExtensions;
    }

    private boolean isMatchGroup(String group, String[] groups) {
        if (group != null && !"".equals(group)) {
            for (String g : groups) {
                if (!group.equals(g)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isActive(Activate activate, Map<String, String> parameter) {
        String[] props = activate.value();
        if (props.length != 0) {
            boolean matched = false;
            for (String prop : props) {
                Matcher matcher = pattern.matcher(prop);
                if (matcher.find()) {
                    String env = matcher.group(1);
                    matched = Boolean.parseBoolean(System.getProperty(env, "true"));
                } else {
                    boolean bl = matched = parameter == null || parameter.containsKey(prop);
                }
                if (!matched) break;
            }
            return matched;
        }
        return true;
    }
}

