/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTFilterExp;
import kd.bos.fulltext.FTValue;

public class FTFilter {
    private String property;
    private FTCompare cp;
    private FTValue value;
    private List<FTFilterNest> nests = new ArrayList<FTFilterNest>();

    public FTFilter(String property, FTCompare cp, FTValue value) {
        this.property = property;
        this.cp = cp;
        this.value = value;
    }

    public FTFilter and(FTFilter f) {
        return this.add("and", f);
    }

    public FTFilter or(FTFilter f) {
        return this.add("or", f);
    }

    private FTFilter add(String nestRw, FTFilter f) {
        this.nests.add(new FTFilterNest(nestRw, f));
        return this;
    }

    public FTFilterExp toExp() {
        ArrayList<FTValue> list = new ArrayList<FTValue>();
        StringBuilder sb = new StringBuilder();
        sb.append(this.property).append(' ').append((Object)this.cp).append(' ').append('?');
        list.add(this.value);
        if (!this.nests.isEmpty()) {
            for (FTFilterNest nest : this.nests) {
                sb.insert(0, '(');
                FTFilterExp exp = nest.filter.toExp();
                sb.append(' ').append(nest.nestRw).append(' ').append(exp.getExp());
                list.addAll(Arrays.asList(exp.getValues()));
                sb.append(')');
            }
        }
        return new FTFilterExp(sb.toString(), list.toArray(new FTValue[list.size()]));
    }

    public String getProperty() {
        return this.property;
    }

    public FTCompare getCp() {
        return this.cp;
    }

    public FTValue getValue() {
        return this.value;
    }

    public List<FTFilterNest> getNests() {
        return this.nests;
    }

    public String toString() {
        return this.toExp().toString();
    }

    private static class FTFilterNest {
        private String nestRw;
        private FTFilter filter;

        FTFilterNest(String nestRw, FTFilter filter) {
            this.nestRw = nestRw;
            this.filter = filter;
        }

        public String toString() {
            return this.nestRw + this.filter;
        }
    }
}

