/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext;

import kd.bos.fulltext.FullTextCustSyncQuery;
import kd.bos.fulltext.FullTextMonitor;
import kd.bos.fulltext.FullTextQuery;
import kd.bos.fulltext.FullTextUpdater;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.custsync.FullTextCustSyncQueryImpl;
import kd.bos.fulltext.impl.DummyFullTextImpl;
import kd.bos.fulltext.impl.FullTextMonitorImpl;
import kd.bos.fulltext.impl.FullTextQueryImpl;
import kd.bos.fulltext.impl.FullTextUpdaterImpl;

public class FullTextFactory {
    public static final String BASE_SERVER_REGION = "quicksearch";

    public static FullTextQuery getFullTextQuery() {
        return FullTextFactory.getFullTextQuery(BASE_SERVER_REGION);
    }

    public static FullTextQuery getFullTextQuery(String region) {
        if (FullTextFactory.isFullTextEanble(region)) {
            return new FullTextQueryImpl(region);
        }
        return new DummyFullTextImpl();
    }

    public static FullTextUpdater getFullTextUpdater() {
        return FullTextFactory.getFullTextUpdater(BASE_SERVER_REGION);
    }

    public static FullTextUpdater getFullTextUpdater(String region) {
        if (FullTextFactory.isFullTextEanble(region)) {
            return new FullTextUpdaterImpl(region);
        }
        return new DummyFullTextImpl();
    }

    public static FullTextMonitor getFullTextMonitor() {
        return FullTextFactory.getFullTextMonitor(BASE_SERVER_REGION);
    }

    public static FullTextMonitor getFullTextMonitor(String region) {
        if (FullTextFactory.isFullTextEanble(region)) {
            return new FullTextMonitorImpl(region);
        }
        return new DummyFullTextImpl();
    }

    public static boolean isFullTextEanble() {
        return FullTextFactory.isFullTextEanble(BASE_SERVER_REGION);
    }

    public static boolean isFullTextEanble(String region) {
        return CommonUtil.isFullTextEanble(region);
    }

    public static FullTextCustSyncQuery getFullTextCustSyncQuery() {
        return FullTextFactory.getFullTextCustSyncQuery(BASE_SERVER_REGION);
    }

    public static FullTextCustSyncQuery getFullTextCustSyncQuery(String region) {
        return new FullTextCustSyncQueryImpl(region);
    }
}

