/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext;

import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTTokenizerType;
import kd.bos.lang.Lang;

public class MatchProperty {
    private String propertyName;
    private FTDataType dataType;
    private FTTokenizerType tokenizerType = FTTokenizerType.STANDARD;
    private Lang lang;
    private boolean withPinyin;
    private long propertySize = 1024L;

    public MatchProperty(String propertyName, Lang lang, boolean withPinyin) {
        this.propertyName = propertyName;
        this.dataType = FTDataType.STRING;
        this.lang = lang;
        this.withPinyin = withPinyin;
    }

    public MatchProperty(String propertyName, boolean withPinyin) {
        this.propertyName = propertyName;
        this.dataType = FTDataType.STRING;
        this.lang = null;
        this.withPinyin = withPinyin;
    }

    public MatchProperty(String propertyName, FTDataType dataType) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.lang = null;
        this.withPinyin = false;
    }

    public MatchProperty(String propertyName, FTDataType dataType, FTTokenizerType tokenizerType) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.lang = null;
        this.withPinyin = false;
        this.tokenizerType = tokenizerType;
    }

    public MatchProperty setTokenizerType(FTTokenizerType tokenizerType) {
        this.tokenizerType = tokenizerType;
        return this;
    }

    public MatchProperty setSize(long propertySize) {
        this.propertySize = propertySize > 32766L ? 32766L : propertySize;
        return this;
    }

    public long getPropertySize() {
        return this.propertySize;
    }

    public FTDataType getDataType() {
        return this.dataType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Lang getLang() {
        return this.lang;
    }

    public boolean isWithPinyin() {
        return this.withPinyin;
    }

    public FTTokenizerType getTokenizerType() {
        return this.tokenizerType;
    }

    public String toString() {
        return "MatchProperty [propertyName=" + this.propertyName + ", dataType=" + (Object)((Object)this.dataType) + ", tokenizerType=" + (Object)((Object)this.tokenizerType) + ", lang=" + this.lang + ", withPinyin=" + this.withPinyin + ", propertySize=" + this.propertySize + "]";
    }
}

