/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.custsync;

import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.FTCompare;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTFilter;
import kd.bos.fulltext.FTFilterExp;
import kd.bos.fulltext.FTRowData;
import kd.bos.fulltext.FTValue;
import kd.bos.fulltext.FullTextCustSyncQuery;
import kd.bos.fulltext.RelatedWord;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.custsync.FullTextCustSyncDetlInfo;
import kd.bos.fulltext.custsync.FullTextCustSyncInfo;
import kd.bos.fulltext.storage.BatchFieldValue;
import kd.bos.fulltext.storage.FieldValue;
import kd.bos.fulltext.storage.FilterField;
import kd.bos.fulltext.storage.HighLightTag;
import kd.bos.fulltext.storage.SortField;
import kd.bos.fulltext.storage.Storage;
import kd.bos.fulltext.storage.StorageFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class FullTextCustSyncQueryImpl
implements FullTextCustSyncQuery {
    private static final String LOG_PREFIX = "FullText error:";
    private static final String INDEX_CONFIG_CACHE_PREFIX = "FTCustSyncIndexConfig-";
    private static final String CONFIG_ENABLE_KEY = "fulltext-custsync.enable";
    private static final int CACHE_TIMEOUT = 1800;
    private static Log log = LogFactory.getLog(FullTextCustSyncQueryImpl.class);
    private static boolean enableOptLogOut = false;
    private static boolean enableFT = false;
    private Storage storage = null;
    private String ftRegion = "quicksearch";

    public FullTextCustSyncQueryImpl(String fullTextRegion) {
        enableOptLogOut = FullTextCustSyncQueryImpl.isLogOut();
        this.ftRegion = fullTextRegion;
    }

    private static boolean isCofigFullTextEnable(String property) {
        return "true".equals(property);
    }

    @Override
    public boolean isEnable() {
        return enableFT;
    }

    @Override
    public boolean isConfigFullText(String entityName) {
        if (!this.isEnable()) {
            return false;
        }
        FullTextCustSyncInfo info = this.getIndexConfigFromCacheOrDb(entityName);
        return info != null && info.getEntityName() != null;
    }

    @Override
    public String[] query(String entityName, FTFilter filter) {
        String pkFieldName;
        FTFilterExp filterExp = null;
        if (filter == null) {
            String errorStr = "fulltext query error: filter cannot be empty.";
            throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
        }
        filterExp = filter.toExp();
        FullTextCustSyncInfo configInfo = this.getIndexConfigFromCacheOrDb(entityName);
        String selectFields = pkFieldName = this.getPKFieldName(configInfo);
        List<FTRowData> rowDatas = this.searchStorage(configInfo, pkFieldName, new String[]{entityName}, selectFields, filterExp, null, false, 1, CommonUtil.getMaxMatchSize());
        ArrayList<String> resultList = new ArrayList<String>(16);
        for (FTRowData rowData : rowDatas) {
            resultList.add(rowData.getPkId());
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    private static boolean isLogOut() {
        return "true".equals(System.getProperty("fulltext.withoptlogout", "false"));
    }

    private long optLogOut(String opt, Object[] params) {
        long ts = System.currentTimeMillis();
        StringBuilder msg = new StringBuilder("----@fulltextCustSync-->");
        msg.append(opt);
        msg.append(":");
        if (params != null && params.length > 0) {
            msg.append("\r\n");
            msg.append(this.toParameterString(params));
        }
        log.info(msg.toString());
        return ts;
    }

    private String toParameterString(Object[] params) {
        if (params == null || params.length == 0) {
            return "";
        }
        int len = Math.min(200, params.length);
        StringBuilder s = new StringBuilder(len * 8);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(params[i]);
        }
        s.append("...(");
        s.append(params.length);
        s.append(")");
        return s.toString();
    }

    private void optEndLog(String opt, long ts) {
        long ms = System.currentTimeMillis() - ts;
        String msg = "----@fulltextCustSync_End----" + opt + "------" + ms + "ms----\r\n";
        log.info(msg);
    }

    public static void removeCache(String entityName) {
        String cacheKey = INDEX_CONFIG_CACHE_PREFIX + entityName;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        cache.remove(cacheKey);
    }

    private FullTextCustSyncInfo getIndexConfigFromCacheOrDb(String entityName) {
        String cacheKey = INDEX_CONFIG_CACHE_PREFIX + entityName;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        FullTextCustSyncInfo dbInfo = null;
        String json = (String)cache.get(cacheKey);
        if (json == null) {
            dbInfo = this.getFromDB(entityName);
            if (dbInfo == null) {
                dbInfo = new FullTextCustSyncInfo();
            }
            json = SerializationUtils.toJsonString((Object)dbInfo);
            cache.put(cacheKey, (Object)json, 1800);
        } else {
            dbInfo = (FullTextCustSyncInfo)SerializationUtils.fromJsonString((String)json, FullTextCustSyncInfo.class);
        }
        return dbInfo;
    }

    private String getPKFieldName(FullTextCustSyncInfo info) {
        if (info == null || info.getFullTextCustSyncDetlDTOList() == null) {
            return "";
        }
        for (FullTextCustSyncDetlInfo item : info.getFullTextCustSyncDetlDTOList()) {
            if (!item.isPK()) continue;
            return item.getEsFieldName();
        }
        return "";
    }

    private List<FullTextCustSyncDetlInfo> getFullTextCustSyncDetlInfoFromDB(long fid) {
        String algoKey = this.getClass().getName() + ".detl.query";
        String sql = "select fid, FPropertyName,FFieldType,FESFieldName,FIsPK from t_fulltext_custsync_detl where FID=? ";
        Object[] params = new Object[]{fid};
        ArrayList<FullTextCustSyncDetlInfo> result = new ArrayList<FullTextCustSyncDetlInfo>();
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql, (Object[])params);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String propertyName = row.getString("FPropertyName");
                String fieldType = row.getString("FFieldType");
                String esFieldName = row.getString("FESFieldName");
                boolean isPK = "1".equals(row.getString("FIsPK"));
                FullTextCustSyncDetlInfo detlInfo = new FullTextCustSyncDetlInfo(propertyName, fieldType, esFieldName, isPK);
                result.add(detlInfo);
            }
        }
        return result;
    }

    private FullTextCustSyncInfo getFromDB(String entityName) {
        String algoKey = this.getClass().getName() + ".query";
        String sql = "select fid, FEntityName,FIndexName,FFilterName,FFilterValue,FIndexType,FIsEnable from t_fulltext_custsync where FEntityName=? and FIsEnable=1 ";
        Object[] params = new Object[]{entityName};
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql, (Object[])params);){
            if (ds.hasNext()) {
                Row row = ds.next();
                long id = (Long)row.get("fid");
                String indexName = row.getString("FIndexName");
                String indexType = row.getString("FIndexType");
                String filterName = row.getString("FFilterName");
                String filterValue = row.getString("FFilterValue");
                FullTextCustSyncInfo info = new FullTextCustSyncInfo(entityName, indexName, indexType, filterName, filterValue);
                List<FullTextCustSyncDetlInfo> lstDetlInfo = this.getFullTextCustSyncDetlInfoFromDB(id);
                info.setFullTextCustSyncDetlDTOList(lstDetlInfo);
                FullTextCustSyncInfo fullTextCustSyncInfo = info;
                return fullTextCustSyncInfo;
            }
        }
        return null;
    }

    private List<FTRowData> searchStorage(FullTextCustSyncInfo configInfo, String pkFieldName, String[] entityNames, String selectFields, FTFilterExp expFilter, String[] sortFields, boolean score, int pageNo, int pageSize) {
        long ts = 0L;
        String opt = "query:" + CommonUtil.joinStr(entityNames, ",") + "->" + selectFields;
        if (enableOptLogOut) {
            ts = this.optLogOut(opt, new Object[]{expFilter});
        }
        try {
            if (this.storage == null) {
                this.storage = StorageFactory.getStorage(this.ftRegion);
            }
            this.checkParam(selectFields, pageNo, pageSize);
            ArrayList sortList = new ArrayList(8);
            ArrayList<String> selectFieldList = new ArrayList<String>(8);
            selectFieldList.add(pkFieldName);
            HashMap<String, String> pnDataTypeMap = new HashMap<String, String>();
            FilterField filter = null;
            if (StringUtils.isNotEmpty((String)configInfo.getFilterName()) && StringUtil.isNotEmpty((String)configInfo.getFilterValue())) {
                filter = new FilterField(configInfo.getFilterName(), FTCompare.EQ.toString(), configInfo.getFilterValue());
                filter.setKeywordsOr();
            }
            if (expFilter != null) {
                FilterField filter2 = this.anlyzeExp(configInfo, expFilter);
                filter = filter == null ? filter2 : filter.and(filter2);
            }
            String dataIndexName = configInfo.getIndexName();
            HighLightTag highLightTag = null;
            List<BatchFieldValue> resultBfv = this.storage.query(dataIndexName, configInfo.getIndexType(), selectFieldList.toArray(new String[selectFieldList.size()]), filter, highLightTag, sortList.toArray(new SortField[0]), score, (pageNo - 1) * pageSize, pageSize);
            List<FTRowData> list = this.packageFTRowData(configInfo, pkFieldName, resultBfv, pnDataTypeMap);
            return list;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext search error:" + e.getMessage()});
        }
        finally {
            if (enableOptLogOut) {
                this.optEndLog(opt, ts);
            }
        }
    }

    private List<FTRowData> packageFTRowData(FullTextCustSyncInfo configInfo, String pkFieldName, List<BatchFieldValue> bfvs, Map<String, String> pnDataTypeMap) {
        String enKey = "";
        if (!StringUtils.isNotEmpty((String)configInfo.getFilterName())) {
            enKey = configInfo.getFilterName();
        }
        String pkIdKey = pkFieldName;
        ArrayList<FTRowData> rowList = new ArrayList<FTRowData>(16);
        for (BatchFieldValue bfv : bfvs) {
            FieldValue[] fvs;
            FTRowData rowData = new FTRowData();
            HashMap<String, Object> pvMap = new HashMap<String, Object>();
            for (FieldValue fv : fvs = bfv.getValues()) {
                String name = fv.getName();
                Object value = fv.getValue();
                if (name.equals(pkIdKey)) {
                    rowData.setPkId(String.valueOf(value));
                    if (null != value) continue;
                    throw new KDException(BosErrorCode.fulltextException, new Object[]{"wrong fulltext rule definition,make sure pkid mapping correctly"});
                }
                if (name.equals(enKey)) {
                    rowData.setEntityName(value.toString());
                    continue;
                }
                pvMap.put(name, value);
            }
            rowData.setDataMap(pvMap);
            rowList.add(rowData);
        }
        return rowList;
    }

    private String charItBreakSpace(Iterator<Character> charIt) {
        char chTemp;
        StringBuilder sb = new StringBuilder();
        while (charIt.hasNext() && (chTemp = charIt.next().charValue()) != ' ') {
            sb.append(chTemp);
        }
        return sb.toString();
    }

    private void checkExpFilter(FTFilterExp expFilter) {
        String exp = expFilter.getExp();
        FTValue[] values = expFilter.getValues();
        String expFilterStr = expFilter.toString();
        if (StringUtils.isEmpty((String)exp)) {
            String errorStr = "fulltext query error:exp cannot be empty." + expFilterStr;
            throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
        }
        char[] chs = exp.toCharArray();
        int count = 0;
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] != '?') continue;
            ++count;
        }
        if (count == 0 || count != values.length) {
            String errorStr = "fulltext query error:params number are not equals ? number." + expFilterStr;
            throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
        }
        if (!CommonUtil.bracketMatch(exp)) {
            String errorStr = "fulltext query error:exp left and right brackets do not match." + expFilterStr;
            throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
        }
    }

    private FilterField anlyzeExp(FullTextCustSyncInfo configInfo, FTFilterExp expFilter) {
        String exp = expFilter.getExp();
        FTValue[] values = expFilter.getValues();
        this.checkExpFilter(expFilter);
        HashMap<String, FTCompare> cpMap = new HashMap<String, FTCompare>(8);
        for (FTCompare cp : FTCompare.values()) {
            cpMap.put(cp.toString(), cp);
        }
        HashMap<String, RelatedWord> rwMap = new HashMap<String, RelatedWord>(8);
        for (RelatedWord rw : RelatedWord.values()) {
            rwMap.put(rw.toString(), rw);
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        ArrayList<Character> expCharList = new ArrayList<Character>(16);
        for (int i = 0; i < exp.length(); ++i) {
            expCharList.add(Character.valueOf(exp.charAt(i)));
        }
        Iterator<Character> expCharIt = expCharList.iterator();
        int paramIndex = 0;
        while (expCharIt.hasNext()) {
            char ch = ((Character)expCharIt.next()).charValue();
            StringBuilder sb = new StringBuilder();
            if (ch == '(' || ch == ')') {
                queue.offer(String.valueOf(ch));
                continue;
            }
            sb.append(ch);
            sb.append(this.charItBreakSpace(expCharIt));
            String sbStr = sb.toString();
            if (rwMap.containsKey(sbStr)) {
                queue.offer(sbStr);
                continue;
            }
            String cpStr = this.charItBreakSpace(expCharIt).toLowerCase(Locale.ENGLISH);
            if (!cpMap.containsKey(cpStr)) {
                String errorStr = "fulltext query error:field must be followed by an operator(like/match/gt/lt/eq)." + expFilter.getExp();
                throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
            }
            String secondNextStr = this.charItBreakSpace(expCharIt).toLowerCase(Locale.ENGLISH);
            if (!secondNextStr.contains("?")) {
                String errorStr = "fulltext queryerror:operator must be followed by ?." + expFilter.getExp();
                throw new KDException(BosErrorCode.fulltextException, new Object[]{errorStr});
            }
            String propertyName = sbStr.toLowerCase(Locale.ENGLISH);
            FTValue value = values[paramIndex];
            Object[] propertyValues = value.getValues();
            FTDataType dataType = value.getDataType();
            if (dataType == FTDataType.STRING && !FTCompare.IN.toString().equals(cpStr)) {
                ArrayList<String> lowcasePropertyValueList = new ArrayList<String>(16);
                for (Object propertyValue : propertyValues) {
                    String tempString = String.valueOf(propertyValue);
                    lowcasePropertyValueList.add(tempString.toLowerCase(Locale.ENGLISH));
                }
                propertyValues = lowcasePropertyValueList.toArray(new String[lowcasePropertyValueList.size()]);
            }
            float boost = value.getBoost();
            String esFieldName = this.getESFieldName(configInfo, propertyName);
            if (StringUtils.isEmpty((String)esFieldName)) {
                throw new KDException(BosErrorCode.fulltextException, new Object[]{"Property-" + propertyName + " has not configured fulltext."});
            }
            FilterField filterField = new FilterField(esFieldName, cpStr, propertyValues).setBoost(boost);
            if (value.isOr()) {
                filterField.setKeywordsOr();
            }
            queue.offer(filterField);
            if (secondNextStr.contains("(") || secondNextStr.contains(")")) {
                for (int i = 0; i < secondNextStr.length(); ++i) {
                    char c = secondNextStr.charAt(i);
                    if (c == '(') {
                        queue.offer("(");
                        continue;
                    }
                    if (c != ')') continue;
                    queue.offer(")");
                }
            }
            ++paramIndex;
        }
        Iterator iterator = queue.iterator();
        Stack<Object> stack = new Stack<Object>();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof String) {
                if (")".equals(obj)) {
                    String backStr = "(";
                    boolean flag = true;
                    while (flag && !stack.isEmpty()) {
                        FilterField firstFF = (FilterField)stack.pop();
                        String rw = (String)stack.pop();
                        FilterField secondFF = (FilterField)stack.pop();
                        Object peekOb = stack.peek();
                        if (backStr.equals(String.valueOf(peekOb))) {
                            stack.pop();
                            flag = false;
                        }
                        if ("and".endsWith(rw)) {
                            stack.push(firstFF.and(secondFF));
                            continue;
                        }
                        stack.push(firstFF.or(secondFF));
                    }
                    continue;
                }
                stack.push(obj.toString());
                continue;
            }
            if (obj instanceof FilterField) {
                stack.push(obj);
                continue;
            }
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"exp parsing error." + exp});
        }
        int stackSize = stack.size();
        if (stackSize % 2 == 0) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"Illegal exp." + exp});
        }
        ArrayList<FilterField> ffList = new ArrayList<FilterField>();
        String rw = "";
        for (int i = 0; i < stackSize; ++i) {
            if (i % 2 != 0) {
                rw = (String)stack.pop();
                continue;
            }
            ffList.add((FilterField)stack.pop());
        }
        FilterField filterField = null;
        for (FilterField ff : ffList) {
            if (filterField == null) {
                filterField = ff;
                continue;
            }
            if ("and".equals(rw)) {
                filterField.and(ff);
                continue;
            }
            filterField.or(ff);
        }
        return filterField;
    }

    private String getESFieldName(FullTextCustSyncInfo configInfo, String propertyName) {
        for (FullTextCustSyncDetlInfo item : configInfo.getFullTextCustSyncDetlDTOList()) {
            if (!propertyName.equals(item.getPropertyName())) continue;
            return item.getEsFieldName();
        }
        return null;
    }

    private void checkParam(String selectFields, int pageNo, int pageSize) {
        int esMaxQuerySize = CommonUtil.getMaxMatchSize();
        if (pageSize > esMaxQuerySize) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"fulltext query error:pageSize(" + pageSize + ") greater than the max number(" + esMaxQuerySize + ") of query."});
        }
        if (pageNo < 1) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"fulltext query error:pageNo(" + pageNo + ") must be greater than 0."});
        }
        if (selectFields == null || selectFields.length() <= 0) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"fulltext query error:selectFields can not be null."});
        }
    }

    static {
        String configValue = System.getProperty(CONFIG_ENABLE_KEY);
        enableFT = FullTextCustSyncQueryImpl.isCofigFullTextEnable(configValue);
        ConfigurationUtil.observeChange((String)CONFIG_ENABLE_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                String configValue = System.getProperty(FullTextCustSyncQueryImpl.CONFIG_ENABLE_KEY);
                enableFT = FullTextCustSyncQueryImpl.isCofigFullTextEnable(configValue);
            }
        });
    }
}

