/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.monitor.FtMonitorDao;
import kd.bos.fulltext.storage.Storage;
import kd.bos.fulltext.storage.StorageFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class FullTextImplBase {
    public static final String MONITOR = "_monitor";
    public static final String DATA = "_data";
    private static Log log = LogFactory.getLog((String)"FullText");
    protected static final String DATA_TYPE_NAME = "t_data";
    protected static final String LOG_PREFIX = "FullText error:";
    protected static boolean enableOptLogOut = false;
    private static Map<String, String> indexNamePrefixInit = new ConcurrentHashMap<String, String>();
    protected String dataIndexName = "";
    protected Storage storage = null;
    protected FtMonitorDao monitorDao = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(String region) {
        try {
            String indexNamePrefix = CommonUtil.getIndexNamePrefix(region);
            Map<String, Integer> settingsMap = CommonUtil.getIndexSettings(region);
            this.dataIndexName = indexNamePrefix + DATA;
            this.storage = StorageFactory.getStorage(region);
            String monitorIndexName = indexNamePrefix + MONITOR;
            if (!indexNamePrefixInit.containsKey(indexNamePrefix)) {
                FullTextImplBase fullTextImplBase = this;
                synchronized (fullTextImplBase) {
                    if (!indexNamePrefixInit.containsKey(indexNamePrefix)) {
                        this.storage.createIndex(this.dataIndexName, settingsMap);
                        this.storage.createIndex(monitorIndexName, settingsMap);
                        indexNamePrefixInit.put(indexNamePrefix, region);
                    }
                }
            }
            this.monitorDao = new FtMonitorDao(this.storage, monitorIndexName);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[]{"fulltext init error:" + e.getMessage()});
        }
    }

    protected long optLogOut(String opt, Object[] params) {
        long ts = System.currentTimeMillis();
        StringBuilder msg = new StringBuilder("----@fulltext-->");
        msg.append(opt);
        msg.append(":");
        if (params != null && params.length > 0) {
            msg.append("\r\n");
            msg.append(this.toParameterString(params));
        }
        log.info(msg.toString());
        return ts;
    }

    protected void optEndLog(String opt, long ts) {
        long ms = System.currentTimeMillis() - ts;
        String msg = "----@fulltext_End----" + opt + "------" + ms + "ms----\r\n";
        log.info(msg);
    }

    private static boolean isLogOut() {
        return "true".equals(System.getProperty("fulltext.withoptlogout", "false"));
    }

    private String toParameterString(Object[] params) {
        if (params == null || params.length == 0) {
            return "";
        }
        int len = Math.min(200, params.length);
        StringBuilder s = new StringBuilder(len * 8);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(params[i]);
        }
        s.append("...(");
        s.append(params.length);
        s.append(")");
        return s.toString();
    }

    private static void addRegionsListener(final RequestContext rc) {
        String[] regionArr;
        for (final String region : regionArr = ConfigurationUtil.getString((String)"fulltext.serverlist", (String)"quicksearch").split(",")) {
            ConfigurationUtil.observeChange((String)("elasticsearch.server." + region), (ConfigurationChangeListener)new ConfigurationChangeListener(){

                public void onChange(Object key, Object newValue) {
                    try {
                        RequestContext.copyAndSet((RequestContext)rc);
                        if (CommonUtil.isFullTextEanble(region)) {
                            Storage st = StorageFactory.getStorage(region);
                            String indexNamePrefix = CommonUtil.getIndexNamePrefix(region);
                            Map<String, Integer> settingsMap = CommonUtil.getIndexSettings(region);
                            st.createIndex(indexNamePrefix + FullTextImplBase.MONITOR, settingsMap);
                            st.createIndex(indexNamePrefix + FullTextImplBase.DATA, settingsMap);
                        }
                    }
                    catch (Exception e) {
                        log.error(FullTextImplBase.LOG_PREFIX + CommonUtil.getStackTrace(e));
                    }
                }
            });
        }
    }

    private static void addMaxMatchSizeListener(final RequestContext rc) {
        ConfigurationUtil.observeChange((String)"fulltext.maxmatchsize", (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    RequestContext.copyAndSet((RequestContext)rc);
                    for (Map.Entry entry : indexNamePrefixInit.entrySet()) {
                        String region = (String)entry.getValue();
                        if (!CommonUtil.isFullTextEanble(region)) continue;
                        Storage st = StorageFactory.getStorage(region);
                        String indexNamePrefix = (String)entry.getKey();
                        Map<String, Integer> settingsMap = CommonUtil.getIndexSettings(region);
                        st.updateIndexSetting(indexNamePrefix + FullTextImplBase.DATA, settingsMap);
                        st.updateIndexSetting(indexNamePrefix + FullTextImplBase.MONITOR, settingsMap);
                    }
                }
                catch (Exception e) {
                    log.error(FullTextImplBase.LOG_PREFIX + CommonUtil.getStackTrace(e));
                }
            }
        });
    }

    static {
        enableOptLogOut = FullTextImplBase.isLogOut();
        ConfigurationUtil.observeChange((String)"fulltext.withoptlogout", (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                enableOptLogOut = FullTextImplBase.isLogOut();
            }
        });
        FullTextImplBase.addMaxMatchSizeListener(RequestContext.get());
        FullTextImplBase.addRegionsListener(RequestContext.get());
    }
}

