/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.storage.highlevel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.elasticsearch.factory.ElasticSearchFactory;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.storage.highlevel.request.NewIndexRequest;
import kd.bos.fulltext.storage.highlevel.request.NewPutMappingRequest;
import kd.bos.fulltext.storage.highlevel.request.NewUpdateRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import org.apache.http.HttpHost;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;

public class HighLevelAccess {
    private static final int defaultSocketTimeOut = 600;
    private static final String RETRY_ON_CONFLICT_KEY = "fulltext.retryonconflict";
    private static Log logger = LogFactory.getLog(HighLevelAccess.class);
    private static boolean logOpen = false;
    private static Map<String, Integer> versionMap = new ConcurrentHashMap<String, Integer>();

    private HighLevelAccess() {
    }

    public static RestHighLevelClient createRestHighLevelClient(String region) {
        RestHighLevelClient esClient = ElasticSearchFactory.getEsClient((String)region);
        try {
            Integer version = HighLevelAccess.getVersion(esClient);
            if (version == null) {
                MainResponse info = esClient.info(RequestOptions.DEFAULT);
                version = info.getVersion().major;
                logger.info("createRestHighLevelClient:region [" + region + "]' version [" + info.getVersion().toString() + "].");
                HighLevelAccess.cacheVersion(esClient, version);
            }
        }
        catch (IOException e) {
            logger.error("get version error", (Throwable)e);
            HighLevelAccess.cacheVersion(esClient, 6);
        }
        return esClient;
    }

    public static boolean isIndexExist(RestHighLevelClient client, String index) {
        GetIndexRequest req = new GetIndexRequest(new String[]{index});
        req.setTimeout(TimeValue.timeValueSeconds((long)600L));
        try {
            return client.indices().exists(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
    }

    public static void createIndex(RestHighLevelClient client, String index, Map<String, Integer> settings) {
        CreateIndexRequest req = new CreateIndexRequest(index);
        req.setTimeout(TimeValue.timeValueSeconds((long)600L));
        try {
            client.indices().create(req.settings(settings), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
    }

    public static void createIndexMapping(RestHighLevelClient client, String index, String type, String fieldsMapping) {
        Integer version = HighLevelAccess.getVersion(client, true);
        NewPutMappingRequest req = new NewPutMappingRequest(index, version);
        if (version <= 6) {
            req.type(type);
        }
        req.timeout(TimeValue.timeValueSeconds((long)600L));
        req.source(fieldsMapping, XContentType.JSON);
        AcknowledgedResponse res = null;
        try {
            res = client.indices().putMapping((PutMappingRequest)req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
        if (!res.isAcknowledged()) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"Failed to create index:" + index + res.toString()});
        }
    }

    public static void updateIndexSettings(RestHighLevelClient client, String[] indexs, Map<String, Integer> indexSettings) {
        String shardsNum = "number_of_shards";
        if (indexSettings.containsKey(shardsNum)) {
            indexSettings.remove(shardsNum);
        }
        UpdateSettingsRequest req = new UpdateSettingsRequest(indexs);
        req.timeout(TimeValue.timeValueSeconds((long)600L));
        req.settings(indexSettings);
        AcknowledgedResponse res = null;
        try {
            res = client.indices().putSettings(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
        if (!res.isAcknowledged()) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"failed to update indexs settings:" + res.toString()});
        }
    }

    public static List<BulkItemResponse> batchSave(RestHighLevelClient client, String index, String type, List<Map<String, Object>> listMap) {
        Integer version = HighLevelAccess.getVersion(client, true);
        BulkRequest req = new BulkRequest();
        req.timeout(TimeValue.timeValueSeconds((long)600L));
        req.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (Map<String, Object> map : listMap) {
            Object id = map.get("_id");
            map.remove("_id", id);
            IndexRequest indexRequest = new NewIndexRequest(index, type, String.valueOf(id), version).source(map);
            UpdateRequest updateRequest = new NewUpdateRequest(index, type, String.valueOf(id), version).upsert(indexRequest);
            updateRequest.doc(indexRequest);
            updateRequest.retryOnConflict(Integer.parseInt(System.getProperty(RETRY_ON_CONFLICT_KEY, "5")));
            req.add(updateRequest);
        }
        BulkResponse res = null;
        try {
            res = client.bulk(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
        ArrayList<BulkItemResponse> failureRes = new ArrayList<BulkItemResponse>();
        if (res.hasFailures()) {
            for (BulkItemResponse resp : res.getItems()) {
                if (!resp.isFailed()) continue;
                failureRes.add(resp);
            }
        }
        return failureRes;
    }

    public static long updateByQuery(RestHighLevelClient client, String index, String type, QueryBuilder filterQb, Map<String, Object> updateData) {
        BulkByScrollResponse res;
        UpdateByQueryRequest req = new UpdateByQueryRequest(new String[]{index});
        req.setTimeout(TimeValue.timeValueSeconds((long)600L));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.typeQuery((String)type));
        queryBuilder.must(filterQb);
        req.setQuery((QueryBuilder)queryBuilder);
        int upFlag = 0;
        int upSize = updateData.size();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : updateData.entrySet()) {
            String key = entry.getKey();
            sb.append("ctx._source.").append(key).append(" = params.").append(key);
            if (++upFlag >= upSize) continue;
            sb.append(";");
        }
        ((UpdateByQueryRequest)((UpdateByQueryRequest)req.setScript(new Script(ScriptType.INLINE, "painless", sb.toString(), updateData))).setRefresh(true)).indices(new String[]{index});
        try {
            res = client.updateByQuery(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
        return res.getUpdated();
    }

    public static long deleteByQuery(RestHighLevelClient client, String index, String type, QueryBuilder filterQb) {
        DeleteByQueryRequest req = new DeleteByQueryRequest(new String[]{index});
        req.setTimeout(TimeValue.timeValueSeconds((long)600L));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        Integer version = HighLevelAccess.getVersion(client, true);
        if (version <= 6) {
            queryBuilder.must((QueryBuilder)QueryBuilders.typeQuery((String)type));
        }
        queryBuilder.must(filterQb);
        ((DeleteByQueryRequest)req.setQuery((QueryBuilder)queryBuilder).setRefresh(true)).indices(new String[]{index});
        BulkByScrollResponse res = null;
        try {
            res = client.deleteByQuery(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
        return res.getDeleted();
    }

    public static void refreshIndex(RestHighLevelClient client, String index) {
        RefreshRequest req = new RefreshRequest(new String[]{index});
        try {
            RefreshResponse refreshResponse = client.indices().refresh(req, RequestOptions.DEFAULT);
            if (refreshResponse.getFailedShards() > 0) {
                throw new KDException(BosErrorCode.fulltextException, new Object[]{"refresh failed:" + refreshResponse.toString()});
            }
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{e});
        }
    }

    public static List<Map<String, Object>> queryAll(RestHighLevelClient client, String indexName, String typeName) {
        SearchRequest req = new SearchRequest(new String[]{indexName});
        SearchSourceBuilder builder = new SearchSourceBuilder();
        req.types(new String[]{typeName});
        builder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        req.source(builder);
        SearchResponse res = null;
        try {
            res = client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{e});
        }
        SearchHit[] hits = res.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
        }
        return result;
    }

    public static List<Map<String, Object>> query(RestHighLevelClient client, String index, String type, String[] selectFields, QueryBuilder filterQb, Map<String, SortOrder> sortFieldMap, boolean score, int start, int size) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        HighLevelAccess.isNeedScore(score, queryBuilder, filterQb);
        SearchRequest req = new SearchRequest(new String[]{index});
        Integer version = HighLevelAccess.getVersion(client, true);
        if (version <= 6) {
            req.types(new String[]{type});
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)queryBuilder).from(start).size(size).fetchSource(selectFields, null);
        HighLevelAccess.sort(sortFieldMap, sourceBuilder);
        req.source(sourceBuilder);
        SearchResponse searchResponse = null;
        try {
            if (logOpen) {
                try {
                    logger.info("ES request info : " + req.toString());
                }
                catch (Throwable e) {
                    logger.error("record log error", e);
                }
            }
            searchResponse = client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{e});
        }
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
        }
        return result;
    }

    public static Map<String, Object> queryAfter(RestHighLevelClient client, String index, String type, String[] selectFields, QueryBuilder filterQb, Map<String, SortOrder> sortFieldMap, boolean score, int size, Object[] sortValues) {
        SearchResponse searchResponse;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        HighLevelAccess.isNeedScore(score, queryBuilder, filterQb);
        SearchRequest req = new SearchRequest(new String[]{index});
        Integer version = HighLevelAccess.getVersion(client, true);
        if (version <= 6) {
            req.types(new String[]{type});
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)queryBuilder).size(size).fetchSource(selectFields, null);
        HighLevelAccess.sort(sortFieldMap, sourceBuilder);
        req.source(sourceBuilder);
        if (sortValues != null) {
            sourceBuilder.searchAfter(sortValues);
        }
        try {
            if (logOpen) {
                logger.info("ES request info : " + req);
            }
            searchResponse = client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{e});
        }
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<Map> result = new ArrayList<Map>(16);
        ArrayList<Object[]> sortValuesList = new ArrayList<Object[]>(16);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
            sortValuesList.add(hit.getSortValues());
        }
        ret.put("sortValuesList", sortValuesList);
        ret.put("result", result);
        return ret;
    }

    private static void sort(Map<String, SortOrder> sortFieldMap, SearchSourceBuilder builder) {
        if (sortFieldMap != null && !sortFieldMap.isEmpty()) {
            for (Map.Entry<String, SortOrder> entry : sortFieldMap.entrySet()) {
                builder.sort(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void isNeedScore(boolean score, BoolQueryBuilder queryBuilder, QueryBuilder filterQb) {
        if (score) {
            queryBuilder.must(filterQb);
        } else {
            queryBuilder.filter(filterQb);
        }
    }

    public static List<Map<String, Object>> queryHighLight(RestHighLevelClient client, String index, String type, String[] selectFields, QueryBuilder filterQB, Map<String, SortOrder> sortFieldMap, boolean score, String preTag, String postTag, int start, int size) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        HighLevelAccess.isNeedScore(score, queryBuilder, filterQB);
        SearchRequest req = new SearchRequest(new String[]{index});
        req.types(new String[]{type});
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        ssb.query((QueryBuilder)queryBuilder).from(start).size(size).fetchSource(selectFields, null);
        HighLevelAccess.sort(sortFieldMap, ssb);
        List<String> highLightFields = HighLevelAccess.highLighMatch(selectFields, preTag, postTag, ssb);
        req.source(ssb);
        SearchResponse searchResponse = null;
        try {
            if (logOpen) {
                try {
                    logger.info("ES request info : " + req.toString());
                }
                catch (Throwable e) {
                    logger.error("record log error", e);
                }
            }
            searchResponse = client.search(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{e});
        }
        return HighLevelAccess.queryResult(type, highLightFields, searchResponse);
    }

    private static List<Map<String, Object>> queryResult(String type, List<String> highLightFields, SearchResponse searchResponse) {
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : hits) {
            Map source = hit.getSourceAsMap();
            Map highlightFields = hit.getHighlightFields();
            for (String field : highLightFields) {
                HighlightField nameField = (HighlightField)highlightFields.get(field);
                if (nameField == null) continue;
                Text[] fragments = nameField.fragments();
                StringBuilder nameTmp = new StringBuilder();
                for (Text text : fragments) {
                    nameTmp.append(text.toString());
                }
                source.put(field, nameTmp.toString());
            }
            result.add(source);
        }
        return result;
    }

    private static List<String> highLighMatch(String[] selectFields, String preTag, String postTag, SearchSourceBuilder ssb) {
        ArrayList<String> highLightFields = new ArrayList<String>();
        for (String field : selectFields) {
            if (field.equalsIgnoreCase("entityname") && field.equalsIgnoreCase("pkid")) continue;
            highLightFields.add(field);
        }
        HighlightBuilder hb = new HighlightBuilder();
        ((HighlightBuilder)hb.preTags(new String[]{preTag})).postTags(new String[]{postTag});
        for (String field : highLightFields) {
            hb.field(field);
        }
        ssb.highlighter(hb);
        return highLightFields;
    }

    public static long getCount(RestHighLevelClient client, String index, String type, QueryBuilder filterQb) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.filter(filterQb);
        SearchRequest req = new SearchRequest(new String[]{index});
        req.types(new String[]{type});
        SearchSourceBuilder builder = new SearchSourceBuilder();
        builder.query((QueryBuilder)queryBuilder).size(0);
        req.source(builder);
        try {
            SearchResponse searchResponse = client.search(req, RequestOptions.DEFAULT);
            return searchResponse.getHits().getTotalHits();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
    }

    private static Integer getVersion(RestHighLevelClient esClient) {
        try {
            List<String> ipPorts = HighLevelAccess.getIpPort(esClient);
            for (String ipPort : ipPorts) {
                Integer version = versionMap.get(ipPort);
                if (version == null) continue;
                return version;
            }
        }
        catch (Exception e) {
            logger.error("get version error", (Throwable)e);
        }
        return null;
    }

    private static Integer getVersion(RestHighLevelClient esClient, boolean ifNullReturnDefault) {
        Integer version = HighLevelAccess.getVersion(esClient);
        if (version == null && ifNullReturnDefault) {
            return 6;
        }
        return version;
    }

    private static List<String> getIpPort(RestHighLevelClient esClient) {
        List nodes = esClient.getLowLevelClient().getNodes();
        ArrayList<String> ipPorts = new ArrayList<String>(2);
        for (Node node : nodes) {
            HttpHost host = node.getHost();
            String hostName = host.getHostName();
            int port = host.getPort();
            ipPorts.add(hostName + ":" + port);
        }
        return ipPorts;
    }

    private static void cacheVersion(RestHighLevelClient esClient, int version) {
        List<String> ipPorts = HighLevelAccess.getIpPort(esClient);
        for (String ipPort : ipPorts) {
            versionMap.put(ipPort, version);
        }
    }

    static {
        try {
            ConfigurationUtil.observeBoolean((String)"fulltext.logopen", (boolean)false, b -> {
                logOpen = b;
            });
        }
        catch (Throwable e) {
            logger.error("observe fulltext.logopen error", e);
        }
    }
}

