/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.storage.highlevel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.api.Probe;
import kd.bos.elasticsearch.api.ESStorage;
import kd.bos.elasticsearch.client.BosRestHighLevelClient;
import kd.bos.elasticsearch.request.Analyzer;
import kd.bos.elasticsearch.request.DataType;
import kd.bos.elasticsearch.request.ESColumn;
import kd.bos.elasticsearch.request.ESProperty;
import kd.bos.elasticsearch.request.ESRow;
import kd.bos.elasticsearch.request.Fields;
import kd.bos.elasticsearch.request.IkMaxWordAnalyzer;
import kd.bos.elasticsearch.request.IkSmartAnalyzer;
import kd.bos.elasticsearch.request.Mapping;
import kd.bos.elasticsearch.request.Settings;
import kd.bos.elasticsearch.util.ESUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.FTDataType;
import kd.bos.fulltext.FTTokenizerType;
import kd.bos.fulltext.storage.BaseStorage;
import kd.bos.fulltext.storage.BatchFieldValue;
import kd.bos.fulltext.storage.FieldIndex;
import kd.bos.fulltext.storage.FieldValue;
import kd.bos.fulltext.storage.FilterField;
import kd.bos.fulltext.storage.HighLightTag;
import kd.bos.fulltext.storage.SortField;
import kd.bos.fulltext.storage.Storage;
import kd.bos.fulltext.storage.highlevel.HighLevelAccess;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class HighLevelStorage
extends BaseStorage
implements Storage {
    private RestHighLevelClient client = null;
    private ESStorage esStorage;
    private int version;

    public HighLevelStorage(String region) {
        this.client = this.getClient(region);
        try {
            MainResponse info = this.client.info(RequestOptions.DEFAULT);
            this.version = info.getVersion().major;
        }
        catch (IOException e) {
            this.version = 6;
        }
        if (this.version > 6) {
            if (this.client instanceof BosRestHighLevelClient) {
                RestClient restClient = ((BosRestHighLevelClient)this.client).getRestClient();
                this.esStorage = ESStorage.create((RestClient)restClient);
            } else {
                this.esStorage = ESStorage.create((String)region);
            }
        }
    }

    private RestHighLevelClient getClient(String region) {
        return HighLevelAccess.createRestHighLevelClient(region);
    }

    @Override
    public void createIndex(String indexName, Map<String, Integer> settingsMap) {
        Probe.touch((String)"http");
        if (this.version > 6) {
            Settings settings = null;
            if (settingsMap != null && settingsMap.size() > 0) {
                Iterator<Map.Entry<String, Integer>> iterator = settingsMap.entrySet().iterator();
                HashMap<String, String> configMap = new HashMap<String, String>(settingsMap.size());
                while (iterator.hasNext()) {
                    Map.Entry<String, Integer> next = iterator.next();
                    configMap.put(next.getKey(), String.valueOf(next.getValue()));
                }
                settings = ESUtil.getIndexSettings(configMap);
            }
            if (!this.esStorage.indexExist(indexName)) {
                this.esStorage.createIndex(indexName, null, settings);
            } else {
                this.esStorage.updateSetting(indexName, settings);
            }
        } else if (!HighLevelAccess.isIndexExist(this.client, indexName)) {
            HighLevelAccess.createIndex(this.client, indexName, settingsMap);
        } else {
            HighLevelAccess.updateIndexSettings(this.client, new String[]{indexName}, settingsMap);
        }
    }

    @Override
    public void updateIndexSetting(String indexName, Map<String, Integer> settingsMap) {
        Probe.touch((String)"http");
        if (this.version > 6) {
            Settings settings = null;
            if (settingsMap != null && settingsMap.size() > 0) {
                Iterator<Map.Entry<String, Integer>> iterator = settingsMap.entrySet().iterator();
                HashMap<String, String> configMap = new HashMap<String, String>(settingsMap.size());
                while (iterator.hasNext()) {
                    Map.Entry<String, Integer> next = iterator.next();
                    configMap.put(next.getKey(), String.valueOf(next.getValue()));
                }
                settings = ESUtil.getIndexSettings(configMap);
            }
            this.esStorage.updateSetting(indexName, settings);
        } else if (HighLevelAccess.isIndexExist(this.client, indexName)) {
            HighLevelAccess.updateIndexSettings(this.client, new String[]{indexName}, settingsMap);
        }
    }

    @Override
    public void addFieldIndex(String indexName, String typeName, FieldIndex ... fieldIndexs) {
        Probe.touch((String)"http");
        if (this.version > 6) {
            Mapping mapping = new Mapping(this.createMappingProperties(fieldIndexs));
            this.esStorage.addOrUpdateField(indexName, mapping);
        } else {
            HighLevelAccess.createIndexMapping(this.client, indexName, typeName, this.getFieldsMapping(typeName, fieldIndexs));
        }
    }

    private List<ESProperty> createMappingProperties(FieldIndex ... fieldIndexs) {
        ArrayList<ESProperty> properties = new ArrayList<ESProperty>(fieldIndexs == null ? 0 : fieldIndexs.length);
        if (fieldIndexs != null && fieldIndexs.length > 0) {
            for (FieldIndex fieldIndexInfo : fieldIndexs) {
                String filedType = fieldIndexInfo.getDataType();
                String filedName = fieldIndexInfo.getName();
                String fieldTokenizer = fieldIndexInfo.getTokenizerType();
                ESProperty property = new ESProperty(filedName, DataType.parseDataType((String)filedType));
                long fieldSize = fieldIndexInfo.getFieldSize();
                if (FTDataType.STRING.toString().equals(filedType)) {
                    Fields fields = new Fields("keyword", DataType.KEYWORD);
                    fields.setIgnoreAbove(Long.valueOf(fieldSize));
                    if (FTTokenizerType.IKMAXWORD.toString().endsWith(fieldTokenizer)) {
                        property.setAnalyzer((Analyzer)new IkMaxWordAnalyzer());
                        property.setSearchAnalyzer((Analyzer)new IkSmartAnalyzer());
                    } else if (FTTokenizerType.IKSMART.toString().endsWith(fieldTokenizer)) {
                        property.setAnalyzer((Analyzer)new IkSmartAnalyzer());
                    }
                    property.setFields(fields);
                }
                properties.add(property);
            }
        }
        return properties;
    }

    @Override
    public void delFieldIndex(String indexName, String typeName, FieldIndex ... fieldIndexs) {
        Probe.touch((String)"http");
        HashMap<String, Object> upMap = new HashMap<String, Object>(8);
        for (FieldIndex index : fieldIndexs) {
            upMap.put(index.getName(), null);
        }
        HighLevelAccess.updateByQuery(this.client, indexName, typeName, null, upMap);
    }

    @Override
    public void refreshDataBase(String indexName) {
        Probe.touch((String)"http");
        HighLevelAccess.refreshIndex(this.client, indexName);
    }

    @Override
    public void batchSave(String indexName, String typeName, BatchFieldValue ... values) {
        if (this.version <= 6) {
            ArrayList<BulkItemResponse> failureRespList = new ArrayList<BulkItemResponse>(16);
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(16);
            int batchFlag = 0;
            int saveSize = 0;
            for (BatchFieldValue bv : values) {
                if (++batchFlag > 5000) {
                    failureRespList.addAll(HighLevelAccess.batchSave(this.client, indexName, typeName, mapList));
                    batchFlag = 1;
                    mapList.clear();
                }
                FieldValue[] upFields = bv.getValues();
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                for (FieldValue fv : upFields) {
                    String name = fv.getName();
                    Object value = fv.getValue();
                    map.put(name, value);
                }
                map.put("_id", bv.getId());
                ++saveSize;
                mapList.add(map);
            }
            Probe.touch((String)"http");
            failureRespList.addAll(HighLevelAccess.batchSave(this.client, indexName, typeName, mapList));
            if (!failureRespList.isEmpty()) {
                throw new KDException(BosErrorCode.fulltextException, new Object[]{this.buildBulkFailureMessage(saveSize, failureRespList)});
            }
        } else {
            int batchFlag = 0;
            ArrayList<ESRow> rows = new ArrayList<ESRow>(5001);
            for (BatchFieldValue bv : values) {
                if (++batchFlag > 5000) {
                    this.esStorage.save(indexName, typeName, rows);
                    batchFlag = 1;
                    rows.clear();
                }
                FieldValue[] upFields = bv.getValues();
                ESColumn pkColumn = new ESColumn("_id", (Object)bv.getId());
                ArrayList<ESColumn> columns = new ArrayList<ESColumn>(8);
                for (FieldValue fv : upFields) {
                    ESColumn column = new ESColumn(fv.getName(), fv.getValue());
                    columns.add(column);
                }
                ESRow row = new ESRow(pkColumn, columns);
                rows.add(row);
            }
            if (rows.size() > 0) {
                Probe.touch((String)"http");
                this.esStorage.save(indexName, typeName, rows);
            }
        }
    }

    @Override
    public List<BatchFieldValue> query(String indexName, String typeName, String[] selectFileds, FilterField filter, HighLightTag highLightTag, SortField[] sortFields, boolean score, int start, int size) {
        this.likeHighLightMap = new HashMap();
        HashMap<String, SortOrder> sortMap = null;
        if (sortFields != null && sortFields.length > 0) {
            sortMap = new HashMap<String, SortOrder>();
            for (SortField info : sortFields) {
                if (info.isAsc()) {
                    sortMap.put(info.getName(), SortOrder.ASC);
                    continue;
                }
                sortMap.put(info.getName(), SortOrder.DESC);
            }
        }
        Probe.touch((String)"http");
        QueryBuilder queryBuilder = this.getQueryBuilder(filter);
        List<Map<String, Object>> result = highLightTag == null ? HighLevelAccess.query(this.client, indexName, typeName, selectFileds, queryBuilder, sortMap, score, start, size) : HighLevelAccess.queryHighLight(this.client, indexName, typeName, selectFileds, queryBuilder, sortMap, score, highLightTag.getPreTags(), highLightTag.getPostTags(), start, size);
        return this.queryMapListToResult(result, selectFileds, highLightTag);
    }

    @Override
    public List<BatchFieldValue> searchAfter(String indexName, String typeName, String[] selectFields, FilterField filter, HighLightTag highLightTag, SortField[] sortFields, boolean score, int size, Object[] sortValues) {
        this.likeHighLightMap = new HashMap();
        HashMap<String, SortOrder> sortMap = null;
        if (sortFields != null && sortFields.length > 0) {
            sortMap = new HashMap<String, SortOrder>();
            for (SortField info : sortFields) {
                if (info.isAsc()) {
                    sortMap.put(info.getName(), SortOrder.ASC);
                    continue;
                }
                sortMap.put(info.getName(), SortOrder.DESC);
            }
        }
        Probe.touch((String)"http");
        QueryBuilder queryBuilder = this.getQueryBuilder(filter);
        Map<String, Object> retMap = HighLevelAccess.queryAfter(this.client, indexName, typeName, selectFields, queryBuilder, sortMap, score, size, sortValues);
        List result = (List)retMap.get("result");
        List sortValuesList = (List)retMap.get("sortValuesList");
        return this.queryMapListToResult(result, sortValuesList, selectFields, highLightTag);
    }

    @Override
    public int getCount(String indexName, String typeName, FilterField filter) {
        Probe.touch((String)"http");
        long count = HighLevelAccess.getCount(this.client, indexName, typeName, this.getQueryBuilder(filter));
        return (int)count;
    }

    @Override
    public boolean exist(String indexName, String typeName, FilterField filter) {
        Probe.touch((String)"http");
        long count = HighLevelAccess.getCount(this.client, indexName, typeName, this.getQueryBuilder(filter));
        return count > 0L;
    }

    @Override
    public void delete(String indexName, String typeName, String _id) {
        Probe.touch((String)"http");
        HighLevelAccess.deleteByQuery(this.client, indexName, typeName, (QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)_id));
    }

    @Override
    public void deleteByQuery(String indexName, String typeName, FilterField filter) {
        Probe.touch((String)"http");
        HighLevelAccess.deleteByQuery(this.client, indexName, typeName, this.getQueryBuilder(filter));
    }

    @Override
    public void updateByQuery(String indexName, String typeName, FilterField filter, FieldValue[] upFields) {
        Probe.touch((String)"http");
        HashMap<String, Object> upMap = new HashMap<String, Object>(8);
        for (FieldValue fv : upFields) {
            upMap.put(fv.getName(), fv.getValue());
        }
        HighLevelAccess.updateByQuery(this.client, indexName, typeName, this.getQueryBuilder(filter), upMap);
    }
}

