/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.storage.highlevel.request;

import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.VersionType;

public class NewUpdateRequest
extends UpdateRequest {
    private int esVersion;

    public NewUpdateRequest(String index, String type, String id, int esVersion) {
        super(index, esVersion <= 6 ? type : null, id);
        this.esVersion = esVersion;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError((String)"index is missing", validationException);
        }
        if (this.version() != -3L && this.upsertRequest() != null) {
            validationException = ValidateActions.addValidationError((String)"can't provide both upsert request and a version", (ActionRequestValidationException)validationException);
        }
        if (this.upsertRequest() != null && this.upsertRequest().version() != -3L) {
            validationException = ValidateActions.addValidationError((String)"can't provide version in upsert request", (ActionRequestValidationException)validationException);
        }
        if (this.esVersion <= 6 && Strings.isEmpty((CharSequence)this.type())) {
            validationException = ValidateActions.addValidationError((String)"type is missing", (ActionRequestValidationException)validationException);
        }
        if (Strings.isEmpty((CharSequence)this.id())) {
            validationException = ValidateActions.addValidationError((String)"id is missing", (ActionRequestValidationException)validationException);
        }
        if (this.versionType() != VersionType.INTERNAL) {
            validationException = ValidateActions.addValidationError((String)("version type [" + this.versionType() + "] is not supported by the update API"), (ActionRequestValidationException)validationException);
        } else {
            if (this.version() != -3L && this.retryOnConflict() > 0) {
                validationException = ValidateActions.addValidationError((String)"can't provide both retry_on_conflict and a specific version", (ActionRequestValidationException)validationException);
            }
            if (!this.versionType().validateVersionForWrites(this.version())) {
                validationException = ValidateActions.addValidationError((String)("illegal version value [" + this.version() + "] for version type [" + this.versionType().name() + "]"), (ActionRequestValidationException)validationException);
            }
        }
        validationException = DocWriteRequest.validateSeqNoBasedCASParams((DocWriteRequest)this, (ActionRequestValidationException)validationException);
        if (this.ifSeqNo() != -2L && this.retryOnConflict() > 0) {
            validationException = ValidateActions.addValidationError((String)"compare and write operations can not be retried", (ActionRequestValidationException)validationException);
        }
        if (this.ifSeqNo() != -2L && this.docAsUpsert()) {
            validationException = ValidateActions.addValidationError((String)"compare and write operations can not be used with upsert", (ActionRequestValidationException)validationException);
        }
        if (this.script() == null && this.doc() == null) {
            validationException = ValidateActions.addValidationError((String)"script or doc is missing", (ActionRequestValidationException)validationException);
        }
        if (this.script() != null && this.doc() != null) {
            validationException = ValidateActions.addValidationError((String)"can't provide both script and doc", (ActionRequestValidationException)validationException);
        }
        if (this.doc() == null && this.docAsUpsert()) {
            validationException = ValidateActions.addValidationError((String)"doc must be specified if doc_as_upsert is enabled", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

