/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.storage.transport;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequestBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

public class TransportAccess {
    private static final String WORKCOUNT = "transport.netty.worker_count";
    private static final String RETRYONCONFLICT = "fulltext.retryonconflict";
    private static Log logger = LogFactory.getLog(TransportAccess.class);
    private static boolean logOpen = false;

    public static Client getTransPortClient(String ip, int port, String clusterName) {
        try {
            System.setProperty("es.set.netty.runtime.available.processors", "false");
            int workCount = Integer.parseInt(System.getProperty(WORKCOUNT, "16"));
            Settings esSettings = Settings.builder().put("cluster.name", clusterName).put("client.transport.sniff", true).put(WORKCOUNT, workCount).build();
            PreBuiltTransportClient client = new PreBuiltTransportClient(esSettings, new Class[0]);
            TransportAddress address = new TransportAddress(InetAddress.getByName(ip), port);
            client.addTransportAddress(address);
            return client;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"failed to get connection:" + CommonUtil.getStackTrace(e)});
        }
    }

    public static boolean existIndex(Client client, String index) {
        IndicesExistsRequest request = new IndicesExistsRequest(new String[]{index});
        IndicesExistsResponse response = (IndicesExistsResponse)client.admin().indices().exists(request).actionGet();
        return response.isExists();
    }

    public static void createIndex(Client client, String index, Map<String, Integer> settingMap) {
        Settings.Builder settingsBuilder = Settings.builder();
        for (Map.Entry<String, Integer> entry : settingMap.entrySet()) {
            settingsBuilder.put(entry.getKey(), entry.getValue().intValue());
        }
        Settings esSettings = settingsBuilder.build();
        CreateIndexResponse indexResponse = (CreateIndexResponse)client.admin().indices().prepareCreate(index).setSettings(esSettings).get();
        if (!indexResponse.isAcknowledged()) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"Failed to create index:" + index + indexResponse.toString()});
        }
    }

    public static void updateIndexSettings(Client client, String[] indexs, Map<String, Integer> settingMap) {
        if (settingMap.containsKey("number_of_shards")) {
            settingMap.remove("number_of_shards");
        }
        Settings.Builder settingsBuilder = Settings.builder();
        for (Map.Entry<String, Integer> entry : settingMap.entrySet()) {
            settingsBuilder.put(entry.getKey(), entry.getValue().intValue());
        }
        Settings esSettings = settingsBuilder.build();
        UpdateSettingsRequest upSettingRequest = new UpdateSettingsRequest(esSettings, indexs);
        try {
            AcknowledgedResponse response = (AcknowledgedResponse)client.admin().indices().updateSettings(upSettingRequest).get();
            if (!response.isAcknowledged()) {
                throw new KDException(BosErrorCode.fulltextException, new Object[]{"failed to update indexs settings:" + response.toString()});
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
    }

    public static void addFieldIndex(Client client, String index, String type, String fieldsMapping) {
        AcknowledgedResponse response = (AcknowledgedResponse)client.admin().indices().preparePutMapping(new String[]{index}).setType(type).setSource(fieldsMapping, XContentType.JSON).get();
        if (!response.isAcknowledged()) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"add field index failed:" + response.toString()});
        }
    }

    public static void save(Client client, String index, String typeName, Map<String, Object> map) {
        ArrayList<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        listMap.add(map);
        TransportAccess.batchSave(client, index, typeName, listMap);
    }

    public static List<BulkItemResponse> batchSave(Client client, String index, String typeName, List<Map<String, Object>> listMap) {
        BulkRequestBuilder bulkRequest = client.prepareBulk();
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        int retryOnConflict = Integer.parseInt(System.getProperty(RETRYONCONFLICT, "5"));
        for (Map<String, Object> map : listMap) {
            Object esIdObj = map.get("_id");
            map.remove("_id", esIdObj);
            IndexRequest indexRequest = new IndexRequest(index, typeName, String.valueOf(esIdObj)).source(map);
            UpdateRequest updateRequest = new UpdateRequest(index, typeName, String.valueOf(esIdObj)).upsert(indexRequest);
            updateRequest.doc(indexRequest);
            updateRequest.retryOnConflict(retryOnConflict);
            bulkRequest.add(updateRequest);
        }
        BulkResponse bulkResponse = (BulkResponse)bulkRequest.get();
        ArrayList<BulkItemResponse> failureRespList = new ArrayList<BulkItemResponse>();
        if (bulkResponse.hasFailures()) {
            for (BulkItemResponse resp : bulkResponse.getItems()) {
                if (!resp.isFailed()) continue;
                failureRespList.add(resp);
            }
        }
        return failureRespList;
    }

    public static long updateByQuery(Client client, String index, String typeName, QueryBuilder filterQb, Map<String, Object> upMap) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.typeQuery((String)typeName));
        queryBuilder.must(filterQb);
        int upFlag = 0;
        int upSize = upMap.size();
        StringBuilder codeSb = new StringBuilder();
        for (Map.Entry<String, Object> entry : upMap.entrySet()) {
            String key = entry.getKey();
            codeSb.append("ctx._source.").append(key).append(" = params.").append(key);
            if (++upFlag >= upSize) continue;
            codeSb.append(";");
        }
        BulkByScrollResponse response = (BulkByScrollResponse)((UpdateByQueryRequestBuilder)((UpdateByQueryRequestBuilder)((UpdateByQueryRequestBuilder)((UpdateByQueryRequestBuilder)UpdateByQueryAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client).filter((QueryBuilder)queryBuilder)).script(new Script(ScriptType.INLINE, "painless", codeSb.toString(), upMap))).refresh(true)).source(new String[]{index})).get();
        return response.getUpdated();
    }

    public static long deleteByQuery(Client client, String index, String typeName, QueryBuilder filterQb) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.typeQuery((String)typeName));
        queryBuilder.must(filterQb);
        BulkByScrollResponse response = (BulkByScrollResponse)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)DeleteByQueryAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client).refresh(true)).filter((QueryBuilder)queryBuilder)).source(new String[]{index})).get();
        return response.getDeleted();
    }

    public static void refreshIndex(Client client, String index) {
        RefreshResponse response = (RefreshResponse)client.admin().indices().refresh(new RefreshRequest(new String[]{index})).actionGet();
        if (response.getShardFailures().length > 0) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"refresh failed:" + response.toString()});
        }
        FlushResponse flushResponse = (FlushResponse)client.admin().indices().flush(new FlushRequest(new String[]{index})).actionGet();
        if (flushResponse.getShardFailures().length > 0) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{"refresh failed:" + flushResponse.toString()});
        }
    }

    public static List<Map<String, Object>> queryAll(Client client, String indexName, String typeName) {
        MatchAllQueryBuilder qb = QueryBuilders.matchAllQuery();
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{indexName});
        searchRequestBuilder.setTypes(new String[]{typeName});
        searchRequestBuilder.setQuery((QueryBuilder)qb);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
        }
        return result;
    }

    public static List<Map<String, Object>> query(Client client, String index, String typeName, String[] selectFields, QueryBuilder filterQb, Map<String, SortOrder> sortFieldMap, boolean score, int start, int size) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (score) {
            queryBuilder.must(filterQb);
        } else {
            queryBuilder.filter(filterQb);
        }
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{index});
        searchRequestBuilder.setTypes(new String[]{typeName}).setQuery((QueryBuilder)queryBuilder).setFrom(start).setSize(size).setFetchSource(selectFields, null);
        if (sortFieldMap != null && !sortFieldMap.isEmpty()) {
            for (Map.Entry<String, SortOrder> entry : sortFieldMap.entrySet()) {
                searchRequestBuilder.addSort(entry.getKey(), entry.getValue());
            }
        }
        if (logOpen) {
            try {
                logger.info("ES request info : " + searchRequestBuilder.toString());
            }
            catch (Throwable e) {
                logger.error("record log error", e);
            }
        }
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        SearchHit[] hits = searchResponse.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : hits) {
            result.add(hit.getSourceAsMap());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Map<String, Object>> queryHighLight(Client client, String index, String typeName, String[] selectFields, QueryBuilder filterQB, Map<String, SortOrder> sortFieldMap, boolean score, String preTags, String postTags, int start, int size) {
        void var16_21;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (score) {
            queryBuilder.must(filterQB);
        } else {
            queryBuilder.filter(filterQB);
        }
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{index});
        searchRequestBuilder.setTypes(new String[]{typeName}).setQuery((QueryBuilder)queryBuilder).setFrom(start).setSize(size).setFetchSource(selectFields, null);
        if (sortFieldMap != null && !sortFieldMap.isEmpty()) {
            for (Map.Entry<String, SortOrder> entry : sortFieldMap.entrySet()) {
                searchRequestBuilder.addSort(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<String> highLightFields = new ArrayList<String>();
        String[] stringArray = selectFields;
        int n = stringArray.length;
        boolean bl = false;
        while (var16_21 < n) {
            String field = stringArray[var16_21];
            if (!field.equalsIgnoreCase("entityname") || !field.equalsIgnoreCase("pkid")) {
                highLightFields.add(field);
            }
            ++var16_21;
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        ((HighlightBuilder)highlightBuilder.preTags(new String[]{preTags})).postTags(new String[]{postTags});
        for (String string : highLightFields) {
            highlightBuilder.field(string);
        }
        if (logOpen) {
            try {
                logger.info("ES request info : " + searchRequestBuilder.toString());
            }
            catch (Throwable e) {
                logger.error("record log error", e);
            }
        }
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.highlighter(highlightBuilder).execute().actionGet();
        SearchHit[] searchHitArray = searchResponse.getHits().getHits();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        for (SearchHit hit : searchHitArray) {
            Map source = hit.getSourceAsMap();
            Map highlightFields = hit.getHighlightFields();
            for (String string : highLightFields) {
                HighlightField nameField = (HighlightField)highlightFields.get(string);
                if (nameField == null) continue;
                Text[] fragments = nameField.fragments();
                StringBuilder nameTmp = new StringBuilder();
                for (Text text : fragments) {
                    nameTmp.append(text);
                }
                source.put(string, nameTmp.toString());
            }
            result.add(source);
        }
        return result;
    }

    public static long getCount(Client client, String index, String typeName, QueryBuilder filterQb) {
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{index});
        searchRequestBuilder.setTypes(new String[]{typeName}).setQuery(filterQb).setSize(0);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.execute().actionGet();
        return searchResponse.getHits().getTotalHits();
    }

    static {
        try {
            ConfigurationUtil.observeBoolean((String)"fulltext.logopen", (boolean)false, b -> {
                logOpen = b;
            });
        }
        catch (Throwable e) {
            logger.error("observe fulltext.logopen error", e);
        }
    }
}

