/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fulltext.storage.transport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.api.Probe;
import kd.bos.elasticsearch.util.ESUtil;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.storage.BaseStorage;
import kd.bos.fulltext.storage.BatchFieldValue;
import kd.bos.fulltext.storage.FieldIndex;
import kd.bos.fulltext.storage.FieldValue;
import kd.bos.fulltext.storage.FilterField;
import kd.bos.fulltext.storage.HighLightTag;
import kd.bos.fulltext.storage.SortField;
import kd.bos.fulltext.storage.Storage;
import kd.bos.fulltext.storage.transport.TransportAccess;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class TransportStorage
extends BaseStorage
implements Storage {
    private Client client = null;
    private static Map<String, Client> clientCacheMap = new ConcurrentHashMap<String, Client>(8);

    public TransportStorage(String region) {
        this.client = this.getClient(region);
    }

    private Client getClient(String region) {
        Map configMap = ESUtil.getServerConfig((String)region);
        String port = (String)configMap.get("port");
        String clusterName = (String)configMap.get("clustername");
        String ip = (String)configMap.get("ip");
        return clientCacheMap.computeIfAbsent(ip, i -> TransportAccess.getTransPortClient(ip, Integer.parseInt(port), clusterName));
    }

    @Override
    public void createIndex(String indexName, Map<String, Integer> settingsMap) {
        Probe.touch((String)"http");
        if (!TransportAccess.existIndex(this.client, indexName)) {
            TransportAccess.createIndex(this.client, indexName, settingsMap);
        } else {
            TransportAccess.updateIndexSettings(this.client, new String[]{indexName}, settingsMap);
        }
    }

    @Override
    public void updateIndexSetting(String indexName, Map<String, Integer> settingsMap) {
        Probe.touch((String)"http");
        if (TransportAccess.existIndex(this.client, indexName)) {
            TransportAccess.updateIndexSettings(this.client, new String[]{indexName}, settingsMap);
        }
    }

    @Override
    public void addFieldIndex(String indexName, String typeName, FieldIndex ... fieldIndexs) {
        Probe.touch((String)"http");
        TransportAccess.addFieldIndex(this.client, indexName, typeName, this.getFieldsMapping(typeName, fieldIndexs));
    }

    @Override
    public void delFieldIndex(String indexName, String typeName, FieldIndex ... fieldIndexs) {
        Probe.touch((String)"http");
        HashMap<String, Object> upMap = new HashMap<String, Object>(8);
        for (FieldIndex index : fieldIndexs) {
            upMap.put(index.getName(), null);
        }
        TransportAccess.updateByQuery(this.client, indexName, typeName, null, upMap);
    }

    @Override
    public void refreshDataBase(String indexName) {
        Probe.touch((String)"http");
        TransportAccess.refreshIndex(this.client, indexName);
    }

    @Override
    public void batchSave(String indexName, String typeName, BatchFieldValue ... values) {
        ArrayList<BulkItemResponse> failureRespList = new ArrayList<BulkItemResponse>(8);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(8);
        int batchFlag = 0;
        int saveSize = 0;
        for (BatchFieldValue bv : values) {
            if (++batchFlag > 5000) {
                failureRespList.addAll(TransportAccess.batchSave(this.client, indexName, typeName, mapList));
                batchFlag = 1;
                mapList.clear();
            }
            FieldValue[] upFields = bv.getValues();
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            for (FieldValue fv : upFields) {
                String name = fv.getName();
                Object value = fv.getValue();
                map.put(name, value);
            }
            map.put("_id", bv.getId());
            ++saveSize;
            mapList.add(map);
        }
        Probe.touch((String)"http");
        failureRespList.addAll(TransportAccess.batchSave(this.client, indexName, typeName, mapList));
        if (!failureRespList.isEmpty()) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{this.buildBulkFailureMessage(saveSize, failureRespList)});
        }
    }

    @Override
    public List<BatchFieldValue> query(String indexName, String typeName, String[] selectFileds, FilterField filter, HighLightTag highLightTag, SortField[] sortFields, boolean score, int start, int size) {
        this.likeHighLightMap = new HashMap();
        HashMap<String, SortOrder> sortMap = null;
        if (sortFields != null && sortFields.length > 0) {
            sortMap = new HashMap<String, SortOrder>();
            for (SortField info : sortFields) {
                if (info.isAsc()) {
                    sortMap.put(info.getName(), SortOrder.ASC);
                    continue;
                }
                sortMap.put(info.getName(), SortOrder.DESC);
            }
        }
        Probe.touch((String)"http");
        QueryBuilder queryBuilder = this.getQueryBuilder(filter);
        List<Map<String, Object>> result = highLightTag == null ? TransportAccess.query(this.client, indexName, typeName, selectFileds, queryBuilder, sortMap, score, start, size) : TransportAccess.queryHighLight(this.client, indexName, typeName, selectFileds, queryBuilder, sortMap, score, highLightTag.getPreTags(), highLightTag.getPostTags(), start, size);
        return this.queryMapListToResult(result, selectFileds, highLightTag);
    }

    @Override
    public List<BatchFieldValue> searchAfter(String indexName, String typeName, String[] selectFileds, FilterField filter, HighLightTag highLightTag, SortField[] sortFields, boolean score, int size, Object[] sortValues) {
        throw new UnsupportedOperationException("Unsupported searchAfter method");
    }

    @Override
    public int getCount(String indexName, String typeName, FilterField filter) {
        Probe.touch((String)"http");
        long count = TransportAccess.getCount(this.client, indexName, typeName, this.getQueryBuilder(filter));
        return (int)count;
    }

    @Override
    public boolean exist(String indexName, String typeName, FilterField filter) {
        Probe.touch((String)"http");
        long count = TransportAccess.getCount(this.client, indexName, typeName, this.getQueryBuilder(filter));
        return count > 0L;
    }

    @Override
    public void delete(String indexName, String typeName, String _id) {
        Probe.touch((String)"http");
        TransportAccess.deleteByQuery(this.client, indexName, typeName, (QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)_id));
    }

    @Override
    public void deleteByQuery(String indexName, String typeName, FilterField filter) {
        Probe.touch((String)"http");
        TransportAccess.deleteByQuery(this.client, indexName, typeName, this.getQueryBuilder(filter));
    }

    @Override
    public void updateByQuery(String indexName, String typeName, FilterField filter, FieldValue[] upFields) {
        HashMap<String, Object> upMap = new HashMap<String, Object>(8);
        for (FieldValue fv : upFields) {
            upMap.put(fv.getName(), fv.getValue());
        }
        Probe.touch((String)"http");
        TransportAccess.updateByQuery(this.client, indexName, typeName, this.getQueryBuilder(filter), upMap);
    }
}

