/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.MetadataAPI;
import kd.bos.algo.olap.OlapConfig;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.Schema;
import kd.bos.algo.olap.cubedata.CubeDataReader;
import kd.bos.algo.olap.cubedata.ICubeData;
import kd.bos.algo.olap.def.CubeDef;
import kd.bos.algo.olap.impl.BBFilterIndexes;
import kd.bos.algo.olap.impl.BuildContext;
import kd.bos.algo.olap.impl.CellReaderImpl;
import kd.bos.algo.olap.impl.ConnectionImpl;
import kd.bos.algo.olap.impl.CubeBuilder;
import kd.bos.algo.olap.impl.CubeEvaluateContext;
import kd.bos.algo.olap.impl.CubeImpl;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.MetadataAPIImpl;
import kd.bos.algo.olap.impl.SchemaImpl;
import kd.bos.algo.olap.impl.SchemaReaderImpl;
import kd.bos.algo.olap.impl.Stats;
import kd.bos.algo.olap.mdx.CellReader;
import kd.bos.algo.olap.mdx.MdxQuery;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.UserDefineFunTable;
import org.apache.log4j.Logger;

public class Database
implements Serializable {
    private static Logger logger = Logger.getLogger(Database.class);
    public Schema schema;
    ICubeData cubeData;
    private MetadataAPIImpl metadataAPI;
    private SchemaReaderImpl schemaReader;
    private CubeEvaluateContext evaluateContext;
    private ConnectionImpl con;
    private BuildContext buildContext;
    private OlapConfig config;
    private Stats stats;
    private MdxQuery mdxQuery;
    private CubeDef cubeDef;

    public Database(Schema _schema, CubeDef cubeDef, BuildContext buildContext, OlapConfig config, Stats stats) {
        this.schema = _schema;
        this.cubeDef = cubeDef;
        this.buildContext = buildContext;
        this.config = config;
        this.stats = stats;
        this.schemaReader = new SchemaReaderImpl((SchemaImpl)this.schema, null);
        this.metadataAPI = new MetadataAPIImpl(this.schemaReader);
        this.schemaReader.setUserDefineFunTable(this.metadataAPI.getUdfTable());
    }

    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    private BBFilterIndexes buildScopeIndexes() {
        for (Dimension dim : this.schema.getCube().getDimensions()) {
            if (!((DimensionImpl)dim).hasCalcMembers()) continue;
            return dim.buildScopeIndexes(this.getEvaluateContext().createEvaluator());
        }
        return null;
    }

    public CubeDataReader getCubeDataReader(String name) {
        return (CubeDataReader)((Object)this.cubeData);
    }

    public CubeDataReader getCubeDataReader(Cube cube) {
        return this.getCubeDataReader(cube.getName());
    }

    public CellReader getCellReader() {
        return new CellReaderImpl((CubeDataReader)((Object)this.cubeData));
    }

    public CellReader getCellReader(String name) {
        return new CellReaderImpl((CubeDataReader)((Object)this.cubeData));
    }

    public void setData(String name, ICubeData data) {
        this.cubeData = data;
    }

    public MetadataAPI getMetadataAPI() {
        return this.metadataAPI;
    }

    public void printStatistics(Stats stats) {
        this.cubeData.printStatistics(stats);
    }

    public void release() {
        this.schema = null;
        if (this.cubeData != null) {
            this.cubeData.release();
        }
    }

    public String getDefaultCubeName() {
        return this.schema.getCube().getName();
    }

    public CubeEvaluateContext getEvaluateContext() {
        if (this.evaluateContext == null) {
            this.con.buildCubeData();
            this.evaluateContext = new CubeEvaluateContext(this);
        }
        return this.evaluateContext;
    }

    public void setConnection(ConnectionImpl con) {
        this.con = con;
    }

    public ConnectionImpl getConnection() {
        return this.con;
    }

    public Database rollUpBuild() {
        if (this.cubeData != null) {
            return this;
        }
        try {
            this.cubeData = CubeBuilder.buildCubeData(this.metadataAPI, this.buildContext, (SchemaImpl)this.schema, (CubeImpl)this.schema.getCube(), this.cubeDef, this.config, this.stats);
        }
        catch (Exception e) {
            throw new OlapException(e);
        }
        finally {
            this.buildContext.close();
        }
        this.cubeData.afterBuild(this.getEvaluateContext(), this.metadataAPI, null, null);
        return this;
    }

    public void build(MdxQuery mdxQuery, List<Map<String, Member>> allLinkMembers) {
        if (this.cubeData != null) {
            return;
        }
        this.mdxQuery = mdxQuery;
        try {
            this.cubeData = CubeBuilder.buildCubeData(this.metadataAPI, this.buildContext, (SchemaImpl)this.schema, (CubeImpl)this.schema.getCube(), this.cubeDef, this.config, this.stats);
        }
        catch (Exception e) {
            throw new OlapException(e);
        }
        finally {
            this.buildContext.close();
        }
        this.cubeData.afterBuild(this.getEvaluateContext(), this.metadataAPI, mdxQuery, allLinkMembers);
    }

    public ICubeData getCubeData() {
        return this.cubeData;
    }

    public OlapConfig getConfig() {
        return this.config;
    }

    public UserDefineFunTable getUdfTable() {
        return this.metadataAPI.getUdfTable();
    }
}

